/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableContext;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.query.QueryException;
import com.hazelcast.query.impl.AttributeType;
import com.hazelcast.query.impl.PortableExtractor;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.getters.ReflectionHelper;

public class QueryEntry
implements QueryableEntry {
    private Data indexKey;
    private Data keyData;
    private Object keyObject;
    private Data valueData;
    private Object valueObject;
    private SerializationService serializationService;

    public QueryEntry() {
    }

    public QueryEntry(SerializationService serializationService, Data indexKey, Object key, Object value) {
        this.init(serializationService, indexKey, key, value);
    }

    public void init(SerializationService serializationService, Data indexKey, Object key, Object value) {
        if (indexKey == null) {
            throw new IllegalArgumentException("index keyData cannot be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("keyData cannot be null");
        }
        this.indexKey = indexKey;
        this.serializationService = serializationService;
        this.keyData = null;
        this.keyObject = null;
        if (key instanceof Data) {
            this.keyData = (Data)key;
        } else {
            this.keyObject = key;
        }
        this.valueData = null;
        this.valueObject = null;
        if (value instanceof Data) {
            this.valueData = (Data)value;
        } else {
            this.valueObject = value;
        }
    }

    @Override
    public Object getValue() {
        if (this.valueObject == null && this.serializationService != null) {
            this.valueObject = this.serializationService.toObject(this.valueData);
        }
        return this.valueObject;
    }

    @Override
    public Object getKey() {
        if (this.keyObject == null && this.serializationService != null) {
            this.keyObject = this.serializationService.toObject(this.keyData);
        }
        return this.keyObject;
    }

    @Override
    public Comparable getAttribute(String attributeName) throws QueryException {
        if ("__key".equals(attributeName)) {
            return (Comparable)this.getKey();
        }
        if ("this".equals(attributeName)) {
            return (Comparable)this.getValue();
        }
        boolean isKey = this.isKey(attributeName);
        attributeName = this.getAttributeName(isKey, attributeName);
        Data targetData = this.getOptionalTargetData(isKey);
        if (targetData != null && targetData.isPortable()) {
            return this.extractViaPortable(attributeName, targetData);
        }
        return this.extractViaReflection(attributeName, isKey);
    }

    private Comparable extractViaPortable(String attributeName, Data data) {
        try {
            return PortableExtractor.extractValue(this.serializationService, data, attributeName);
        }
        catch (QueryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QueryException(e);
        }
    }

    private Comparable extractViaReflection(String attributeName, boolean isKey) {
        try {
            Object obj = isKey ? this.getKey() : this.getValue();
            return ReflectionHelper.extractValue(obj, attributeName);
        }
        catch (QueryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QueryException(e);
        }
    }

    @Override
    public AttributeType getAttributeType(String attributeName) {
        if ("__key".equals(attributeName)) {
            return ReflectionHelper.getAttributeType(this.getKey().getClass());
        }
        if ("this".equals(attributeName)) {
            return ReflectionHelper.getAttributeType(this.getValue().getClass());
        }
        boolean isKey = this.isKey(attributeName);
        attributeName = this.getAttributeName(isKey, attributeName);
        Data data = this.getOptionalTargetData(isKey);
        if (data != null && data.isPortable()) {
            PortableContext portableContext = this.serializationService.getPortableContext();
            return PortableExtractor.getAttributeType(portableContext, data, attributeName);
        }
        return ReflectionHelper.getAttributeType(isKey ? this.getKey() : this.getValue(), attributeName);
    }

    private String getAttributeName(boolean isKey, String attributeName) {
        if (isKey) {
            return attributeName.substring("__key".length() + 1);
        }
        return attributeName;
    }

    private Data getOptionalTargetData(boolean isKey) {
        if (isKey) {
            if (this.keyObject instanceof Portable) {
                return this.getKeyData();
            }
            return this.keyData;
        }
        if (this.valueObject instanceof Portable) {
            return this.getValueData();
        }
        return this.valueData;
    }

    public boolean isKey(String attributeName) {
        return attributeName.startsWith("__key");
    }

    @Override
    public Data getKeyData() {
        if (this.keyData == null && this.serializationService != null) {
            this.keyData = this.serializationService.toData(this.keyObject);
        }
        return this.keyData;
    }

    @Override
    public Data getValueData() {
        if (this.valueData == null && this.serializationService != null) {
            this.valueData = this.serializationService.toData(this.valueObject);
        }
        return this.valueData;
    }

    @Override
    public Data getIndexKey() {
        return this.indexKey;
    }

    public Object setValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryEntry that = (QueryEntry)o;
        return this.indexKey.equals(that.indexKey);
    }

    @Override
    public int hashCode() {
        return this.indexKey.hashCode();
    }
}

