/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization.serializers;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;
import java.util.ArrayList;

public class ArrayListSerializerHook
implements SerializerHook<ArrayList> {
    @Override
    public Class<ArrayList> getSerializationType() {
        return ArrayList.class;
    }

    @Override
    public Serializer createSerializer() {
        return new ArrayListStreamSerializer();
    }

    @Override
    public boolean isOverwritable() {
        return true;
    }

    public static class ArrayListStreamSerializer
    implements StreamSerializer<ArrayList> {
        @Override
        public void write(ObjectDataOutput out, ArrayList object) throws IOException {
            out.writeBoolean(object != null);
            if (object != null) {
                int size = object.size();
                out.writeInt(size);
                for (int i = 0; i < size; ++i) {
                    out.writeObject(object.get(i));
                }
            }
        }

        @Override
        public ArrayList read(ObjectDataInput in) throws IOException {
            if (in.readBoolean()) {
                int size = in.readInt();
                ArrayList result = new ArrayList(size);
                for (int i = 0; i < size; ++i) {
                    result.add(i, in.readObject());
                }
                return result;
            }
            return null;
        }

        @Override
        public int getTypeId() {
            return -100;
        }

        @Override
        public void destroy() {
        }
    }
}

