/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.cluster.MemberAttributeOperationType;
import com.hazelcast.cluster.impl.operations.MemberAttributeChangedOperation;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.Member;
import com.hazelcast.instance.AbstractMember;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.Preconditions;
import java.util.Map;

public final class MemberImpl
extends AbstractMember
implements Member,
HazelcastInstanceAware,
IdentifiedDataSerializable {
    private boolean localMember;
    private volatile HazelcastInstanceImpl instance;
    private volatile long lastRead;
    private volatile long lastWrite;
    private volatile long lastPing;
    private volatile ILogger logger;

    public MemberImpl() {
    }

    public MemberImpl(Address address, boolean localMember) {
        this(address, localMember, null, null);
    }

    public MemberImpl(Address address, boolean localMember, String uuid, HazelcastInstanceImpl instance) {
        this(address, localMember, uuid, instance, null);
    }

    public MemberImpl(Address address, boolean localMember, String uuid, HazelcastInstanceImpl instance, Map<String, Object> attributes) {
        super(address, uuid, attributes);
        this.localMember = localMember;
        this.lastRead = Clock.currentTimeMillis();
        this.instance = instance;
    }

    public MemberImpl(MemberImpl member) {
        super(member);
        this.localMember = member.localMember;
        this.lastRead = member.lastRead;
    }

    @Override
    protected ILogger getLogger() {
        return this.logger;
    }

    @Override
    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        if (hazelcastInstance instanceof HazelcastInstanceImpl) {
            this.instance = (HazelcastInstanceImpl)hazelcastInstance;
            this.localMember = this.instance.node.address.equals(this.address);
            this.logger = this.instance.node.getLogger(this.getClass().getName());
        }
    }

    @Override
    public boolean localMember() {
        return this.localMember;
    }

    public void didWrite() {
        this.lastWrite = Clock.currentTimeMillis();
    }

    public void didRead() {
        this.lastRead = Clock.currentTimeMillis();
    }

    public void didPing() {
        this.lastPing = Clock.currentTimeMillis();
    }

    public long getLastPing() {
        return this.lastPing;
    }

    public long getLastRead() {
        return this.lastRead;
    }

    public long getLastWrite() {
        return this.lastWrite;
    }

    @Override
    public String getStringAttribute(String key) {
        return (String)this.getAttribute(key);
    }

    @Override
    public void setStringAttribute(String key, String value) {
        this.setAttribute(key, value);
    }

    @Override
    public Boolean getBooleanAttribute(String key) {
        return (Boolean)this.getAttribute(key);
    }

    @Override
    public void setBooleanAttribute(String key, boolean value) {
        this.setAttribute(key, value);
    }

    @Override
    public Byte getByteAttribute(String key) {
        return (Byte)this.getAttribute(key);
    }

    @Override
    public void setByteAttribute(String key, byte value) {
        this.setAttribute(key, value);
    }

    @Override
    public Short getShortAttribute(String key) {
        return (Short)this.getAttribute(key);
    }

    @Override
    public void setShortAttribute(String key, short value) {
        this.setAttribute(key, value);
    }

    @Override
    public Integer getIntAttribute(String key) {
        return (Integer)this.getAttribute(key);
    }

    @Override
    public void setIntAttribute(String key, int value) {
        this.setAttribute(key, value);
    }

    @Override
    public Long getLongAttribute(String key) {
        return (Long)this.getAttribute(key);
    }

    @Override
    public void setLongAttribute(String key, long value) {
        this.setAttribute(key, value);
    }

    @Override
    public Float getFloatAttribute(String key) {
        return (Float)this.getAttribute(key);
    }

    @Override
    public void setFloatAttribute(String key, float value) {
        this.setAttribute(key, Float.valueOf(value));
    }

    @Override
    public Double getDoubleAttribute(String key) {
        return (Double)this.getAttribute(key);
    }

    @Override
    public void setDoubleAttribute(String key, double value) {
        this.setAttribute(key, value);
    }

    @Override
    public void removeAttribute(String key) {
        this.isLocalMember();
        Preconditions.isNotNull(key, "key");
        Object value = this.attributes.remove(key);
        if (value == null) {
            return;
        }
        if (this.instance != null) {
            MemberAttributeChangedOperation operation = new MemberAttributeChangedOperation(MemberAttributeOperationType.REMOVE, key, null);
            this.invokeOnAllMembers(operation);
        }
    }

    private void isLocalMember() {
        if (!this.localMember) {
            throw new UnsupportedOperationException("Attributes on remote members must not be changed");
        }
    }

    private void setAttribute(String key, Object value) {
        this.isLocalMember();
        Preconditions.isNotNull(key, "key");
        Preconditions.isNotNull(value, "value");
        Object oldValue = this.attributes.put(key, value);
        if (value.equals(oldValue)) {
            return;
        }
        if (this.instance != null) {
            MemberAttributeChangedOperation operation = new MemberAttributeChangedOperation(MemberAttributeOperationType.PUT, key, value);
            this.invokeOnAllMembers(operation);
        }
    }

    private void invokeOnAllMembers(Operation operation) {
        NodeEngineImpl nodeEngine = this.instance.node.nodeEngine;
        InternalOperationService os = nodeEngine.getOperationService();
        String uuid = nodeEngine.getLocalMember().getUuid();
        operation.setCallerUuid(uuid).setNodeEngine(nodeEngine);
        try {
            for (MemberImpl member : nodeEngine.getClusterService().getMemberList()) {
                if (!member.localMember()) {
                    os.send(operation, member.getAddress());
                    continue;
                }
                os.executeOperation(operation);
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public int getFactoryId() {
        return 0;
    }

    @Override
    public int getId() {
        return 2;
    }
}

