/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster.impl;

import com.hazelcast.cluster.ClusterClock;
import com.hazelcast.logging.ILogger;
import com.hazelcast.util.Clock;

public class ClusterClockImpl
implements ClusterClock {
    private final ILogger logger;
    private volatile long clusterTimeDiff = Long.MAX_VALUE;
    private volatile long clusterStartTime = Long.MIN_VALUE;

    public ClusterClockImpl(ILogger logger) {
        this.logger = logger;
    }

    @Override
    public long getClusterTime() {
        return Clock.currentTimeMillis() + (this.clusterTimeDiff == Long.MAX_VALUE ? 0L : this.clusterTimeDiff);
    }

    public void setMasterTime(long masterTime) {
        long diff = masterTime - Clock.currentTimeMillis();
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Setting cluster time diff to " + diff + "ms.");
        }
        this.clusterTimeDiff = diff;
    }

    @Override
    public long getClusterTimeDiff() {
        return this.clusterTimeDiff == Long.MAX_VALUE ? 0L : this.clusterTimeDiff;
    }

    @Override
    public long getClusterUpTime() {
        return Clock.currentTimeMillis() - this.clusterStartTime;
    }

    public void setClusterStartTime(long startTime) {
        if (this.clusterStartTime == Long.MIN_VALUE) {
            this.clusterStartTime = startTime;
        }
    }

    public long getClusterStartTime() {
        return this.clusterStartTime;
    }
}

