/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.client.DistributedObjectInfo;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientMessageType;
import com.hazelcast.client.impl.protocol.codec.DistributedObjectInfoCodec;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collection;

@SuppressWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class ClientGetDistributedObjectCodec {
    public static final ClientMessageType REQUEST_TYPE = ClientMessageType.CLIENT_GETDISTRIBUTEDOBJECT;
    public static final int RESPONSE_TYPE = 112;
    public static final boolean RETRYABLE = false;

    public static ClientMessage encodeRequest() {
        int requiredDataSize = RequestParameters.calculateDataSize();
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(false);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        RequestParameters parameters = new RequestParameters();
        return parameters;
    }

    public static ClientMessage encodeResponse(Collection<DistributedObjectInfo> infoCollection) {
        int requiredDataSize = ResponseParameters.calculateDataSize(infoCollection);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(112);
        clientMessage.set(infoCollection.size());
        for (DistributedObjectInfo infoCollection_item : infoCollection) {
            DistributedObjectInfoCodec.encode(infoCollection_item, clientMessage);
        }
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        ArrayList<DistributedObjectInfo> infoCollection = null;
        int infoCollection_size = clientMessage.getInt();
        infoCollection = new ArrayList<DistributedObjectInfo>(infoCollection_size);
        for (int infoCollection_index = 0; infoCollection_index < infoCollection_size; ++infoCollection_index) {
            DistributedObjectInfo infoCollection_item = DistributedObjectInfoCodec.decode(clientMessage);
            infoCollection.add(infoCollection_item);
        }
        parameters.infoCollection = infoCollection;
        return parameters;
    }

    public static class ResponseParameters {
        public Collection<DistributedObjectInfo> infoCollection;

        public static int calculateDataSize(Collection<DistributedObjectInfo> infoCollection) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += 4;
            for (DistributedObjectInfo infoCollection_item : infoCollection) {
                dataSize += DistributedObjectInfoCodec.calculateDataSize(infoCollection_item);
            }
            return dataSize;
        }
    }

    public static class RequestParameters {
        public static final ClientMessageType TYPE = REQUEST_TYPE;

        public static int calculateDataSize() {
            int dataSize = ClientMessage.HEADER_SIZE;
            return dataSize;
        }
    }
}

