/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.operation;

import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.ICacheRecordStore;
import com.hazelcast.cache.impl.operation.AbstractCacheOperation;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupOperation;
import java.io.IOException;

public class CachePutBackupOperation
extends AbstractCacheOperation
implements BackupOperation {
    private CacheRecord cacheRecord;

    public CachePutBackupOperation() {
    }

    public CachePutBackupOperation(String name, Data key, CacheRecord cacheRecord) {
        super(name, key);
        this.cacheRecord = cacheRecord;
    }

    @Override
    public void run() throws Exception {
        CacheService service = (CacheService)this.getService();
        ICacheRecordStore cache = service.getOrCreateCache(this.name, this.getPartitionId());
        cache.putRecord(this.key, this.cacheRecord);
        this.response = Boolean.TRUE;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.cacheRecord);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.cacheRecord = (CacheRecord)in.readObject();
    }

    @Override
    public int getId() {
        return 9;
    }
}

