/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.map;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapPutAllCodec;
import com.hazelcast.client.impl.protocol.task.AbstractAllPartitionsMessageTask;
import com.hazelcast.instance.Node;
import com.hazelcast.map.impl.MapEntrySet;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.operation.MapPutAllOperationFactory;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.OperationFactory;
import com.hazelcast.util.ExceptionUtil;
import java.security.Permission;
import java.util.Map;

public class MapPutAllMessageTask
extends AbstractAllPartitionsMessageTask<MapPutAllCodec.RequestParameters> {
    public MapPutAllMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected OperationFactory createOperationFactory() {
        MapEntrySet mapEntrySet = new MapEntrySet();
        for (Map.Entry<Data, Data> entry : ((MapPutAllCodec.RequestParameters)this.parameters).entries.entrySet()) {
            mapEntrySet.add(entry.getKey(), entry.getValue());
        }
        return new MapPutAllOperationFactory(((MapPutAllCodec.RequestParameters)this.parameters).name, mapEntrySet);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        MapService mapService = (MapService)this.getService("hz:impl:mapService");
        for (Map.Entry<Integer, Object> entry : map.entrySet()) {
            Object result = mapService.getMapServiceContext().toObject(entry.getValue());
            if (!(result instanceof Throwable)) continue;
            throw ExceptionUtil.rethrow((Throwable)result);
        }
        return null;
    }

    @Override
    protected MapPutAllCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return MapPutAllCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MapPutAllCodec.encodeResponse();
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(((MapPutAllCodec.RequestParameters)this.parameters).name, "put");
    }

    @Override
    public String getDistributedObjectName() {
        return ((MapPutAllCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return "putAll";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{((MapPutAllCodec.RequestParameters)this.parameters).entries};
    }
}

