/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.conn.ConnCommand;

public class SetIdleCmd
extends ConnCommand {
    public static final long IDLETIME_NOT_IDLE = 0L;
    private final long seconds;

    protected SetIdleCmd(SnacPacket packet) {
        super(17);
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ByteBlock snacData = packet.getData();
        this.seconds = BinaryTools.getUInt((ByteBlock)snacData, (int)0);
    }

    public SetIdleCmd(long seconds) {
        super(17);
        DefensiveTools.checkRange((long)seconds, (String)"seconds", (long)0L);
        this.seconds = seconds;
    }

    public final long getSecondsIdle() {
        return this.seconds;
    }

    public void writeData(OutputStream out) throws IOException {
        BinaryTools.writeUInt((OutputStream)out, (long)this.seconds);
    }

    public String toString() {
        return "SetIdleCmd: seconds=" + this.seconds;
    }
}

