/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.monitor.impl;

import com.hazelcast.com.eclipsesource.json.JsonObject;
import com.hazelcast.monitor.LocalExecutorStats;
import com.hazelcast.util.Clock;
import com.hazelcast.util.JsonUtil;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class LocalExecutorStatsImpl
implements LocalExecutorStats {
    private static final AtomicLongFieldUpdater<LocalExecutorStatsImpl> PENDING_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalExecutorStatsImpl.class, "pending");
    private static final AtomicLongFieldUpdater<LocalExecutorStatsImpl> STARTED_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalExecutorStatsImpl.class, "started");
    private static final AtomicLongFieldUpdater<LocalExecutorStatsImpl> COMPLETED_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalExecutorStatsImpl.class, "completed");
    private static final AtomicLongFieldUpdater<LocalExecutorStatsImpl> CANCELLED_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalExecutorStatsImpl.class, "cancelled");
    private static final AtomicLongFieldUpdater<LocalExecutorStatsImpl> TOTAL_START_LATENCY_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalExecutorStatsImpl.class, "totalStartLatency");
    private static final AtomicLongFieldUpdater<LocalExecutorStatsImpl> TOTAL_EXECUTION_TIME_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalExecutorStatsImpl.class, "totalExecutionTime");
    private long creationTime = Clock.currentTimeMillis();
    private volatile long pending;
    private volatile long started;
    private volatile long completed;
    private volatile long cancelled;
    private volatile long totalStartLatency;
    private volatile long totalExecutionTime;

    public void startPending() {
        PENDING_UPDATER.incrementAndGet(this);
    }

    public void startExecution(long elapsed) {
        TOTAL_START_LATENCY_UPDATER.addAndGet(this, elapsed);
        STARTED_UPDATER.incrementAndGet(this);
        PENDING_UPDATER.decrementAndGet(this);
    }

    public void finishExecution(long elapsed) {
        TOTAL_EXECUTION_TIME_UPDATER.addAndGet(this, elapsed);
        COMPLETED_UPDATER.incrementAndGet(this);
    }

    public void rejectExecution() {
        PENDING_UPDATER.decrementAndGet(this);
    }

    public void cancelExecution() {
        CANCELLED_UPDATER.incrementAndGet(this);
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getPendingTaskCount() {
        return this.pending;
    }

    @Override
    public long getStartedTaskCount() {
        return this.started;
    }

    @Override
    public long getCompletedTaskCount() {
        return this.completed;
    }

    @Override
    public long getCancelledTaskCount() {
        return this.cancelled;
    }

    @Override
    public long getTotalStartLatency() {
        return this.totalStartLatency;
    }

    @Override
    public long getTotalExecutionLatency() {
        return this.totalExecutionTime;
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("creationTime", this.creationTime);
        root.add("pending", this.pending);
        root.add("started", this.started);
        root.add("totalStartLatency", this.totalStartLatency);
        root.add("completed", this.completed);
        root.add("totalExecutionTime", this.totalExecutionTime);
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        this.creationTime = JsonUtil.getLong(json, "creationTime", -1L);
        PENDING_UPDATER.set(this, JsonUtil.getLong(json, "pending", -1L));
        STARTED_UPDATER.set(this, JsonUtil.getLong(json, "started", -1L));
        TOTAL_START_LATENCY_UPDATER.set(this, JsonUtil.getLong(json, "totalStartLatency", -1L));
        COMPLETED_UPDATER.set(this, JsonUtil.getLong(json, "completed", -1L));
        TOTAL_EXECUTION_TIME_UPDATER.set(this, JsonUtil.getLong(json, "totalExecutionTime", -1L));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalExecutorStatsImpl that = (LocalExecutorStatsImpl)o;
        if (this.creationTime != that.creationTime) {
            return false;
        }
        if (this.pending != that.pending) {
            return false;
        }
        if (this.started != that.started) {
            return false;
        }
        if (this.completed != that.completed) {
            return false;
        }
        if (this.cancelled != that.cancelled) {
            return false;
        }
        if (this.totalStartLatency != that.totalStartLatency) {
            return false;
        }
        return this.totalExecutionTime == that.totalExecutionTime;
    }

    public int hashCode() {
        int result = (int)(this.creationTime ^ this.creationTime >>> 32);
        result = 31 * result + (int)(this.pending ^ this.pending >>> 32);
        result = 31 * result + (int)(this.started ^ this.started >>> 32);
        result = 31 * result + (int)(this.completed ^ this.completed >>> 32);
        result = 31 * result + (int)(this.cancelled ^ this.cancelled >>> 32);
        result = 31 * result + (int)(this.totalStartLatency ^ this.totalStartLatency >>> 32);
        result = 31 * result + (int)(this.totalExecutionTime ^ this.totalExecutionTime >>> 32);
        return result;
    }

    public String toString() {
        return "LocalExecutorStatsImpl{creationTime=" + this.creationTime + ", pending=" + this.pending + ", started=" + this.started + ", completed=" + this.completed + ", cancelled=" + this.cancelled + ", totalStartLatency=" + this.totalStartLatency + ", totalExecutionTime=" + this.totalExecutionTime + '}';
    }
}

