/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb.packet;

import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;

public class Open
extends IQ {
    private final String sessionID;
    private final int blockSize;
    private final InBandBytestreamManager.StanzaType stanza;

    public Open(String sessionID, int blockSize, InBandBytestreamManager.StanzaType stanza) {
        if (sessionID == null || "".equals(sessionID)) {
            throw new IllegalArgumentException("Session ID must not be null or empty");
        }
        if (blockSize <= 0) {
            throw new IllegalArgumentException("Block size must be greater than zero");
        }
        this.sessionID = sessionID;
        this.blockSize = blockSize;
        this.stanza = stanza;
        this.setType(IQ.Type.SET);
    }

    public Open(String sessionID, int blockSize) {
        this(sessionID, blockSize, InBandBytestreamManager.StanzaType.IQ);
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public InBandBytestreamManager.StanzaType getStanza() {
        return this.stanza;
    }

    @Override
    public String getChildElementXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<open ");
        buf.append("xmlns=\"");
        buf.append("http://jabber.org/protocol/ibb");
        buf.append("\" ");
        buf.append("block-size=\"");
        buf.append(this.blockSize);
        buf.append("\" ");
        buf.append("sid=\"");
        buf.append(this.sessionID);
        buf.append("\" ");
        buf.append("stanza=\"");
        buf.append(this.stanza.toString().toLowerCase());
        buf.append("\"");
        buf.append("/>");
        return buf.toString();
    }
}

