/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.logging;

import java.io.IOException;
import java.io.Writer;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import org.apache.log4j.helpers.LogLog;

public class LogViewerWriter
extends Writer {
    private final int SYSLOG_PORT = 514;
    private InetAddress address;
    private String host;
    private final int port;
    private DatagramSocket ds;
    private final int maxMsgLength;

    public LogViewerWriter(String syslogHost, int maxMsgLength) {
        this.maxMsgLength = maxMsgLength;
        if (syslogHost == null) {
            throw new NullPointerException("syslogHost");
        }
        this.host = syslogHost;
        int urlPort = -1;
        if (this.host.indexOf("[") != -1 || this.host.indexOf(58) == this.host.lastIndexOf(58)) {
            try {
                URL url = new URL("http://" + this.host);
                if (url.getHost() != null) {
                    this.host = url.getHost();
                    if (this.host.startsWith("[") && this.host.charAt(this.host.length() - 1) == ']') {
                        this.host = this.host.substring(1, this.host.length() - 1);
                    }
                    urlPort = url.getPort();
                }
            }
            catch (MalformedURLException e) {
                LogLog.error((String)"Malformed URL: will attempt to interpret as InetAddress.", (Throwable)e);
            }
        }
        if (urlPort == -1) {
            urlPort = 514;
        }
        this.port = urlPort;
        this.resolveHost(true);
        try {
            this.ds = new DatagramSocket();
        }
        catch (SocketException e) {
            e.printStackTrace();
            LogLog.error((String)("Could not instantiate DatagramSocket to " + this.host + ". All logging will FAIL."), (Throwable)e);
        }
    }

    private void resolveHost(boolean shouldLog) {
        block2: {
            try {
                this.address = InetAddress.getByName(this.host);
            }
            catch (UnknownHostException e) {
                if (!shouldLog) break block2;
                LogLog.warn((String)("Could not find '" + this.host + "'. All logging will FAIL untill the connection can be established."), (Throwable)e);
            }
        }
    }

    public void write(char[] buf, int off, int len) throws IOException {
        this.write(new String(buf, off, len));
    }

    public void write(String string) throws IOException {
        if (this.address == null) {
            this.resolveHost(false);
        }
        if (this.ds != null && this.address != null) {
            byte[] bytes;
            int bytesLength = (bytes = string.getBytes()).length;
            DatagramPacket packet = new DatagramPacket(bytes, bytesLength > this.maxMsgLength ? this.maxMsgLength : bytesLength, this.address, this.port);
            this.ds.send(packet);
        }
    }

    public void flush() {
    }

    public void close() {
        if (this.ds != null) {
            this.ds.close();
        }
    }
}

