/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.packets;

import java.nio.ByteBuffer;
import net.sf.jqql.beans.QQUser;
import net.sf.jqql.packets.PacketParseException;
import net.sf.jqql.packets._08OutPacket;

public abstract class _05OutPacket
extends _08OutPacket {
    private int qqNum;

    public _05OutPacket(char c, boolean bl, QQUser qQUser) {
        super((byte)5, c, bl, qQUser);
    }

    public _05OutPacket(ByteBuffer byteBuffer, int n, QQUser qQUser) throws PacketParseException {
        super(byteBuffer, n, qQUser);
    }

    public _05OutPacket(ByteBuffer byteBuffer, QQUser qQUser) throws PacketParseException {
        this(byteBuffer, byteBuffer.limit() - byteBuffer.position(), qQUser);
    }

    protected int getLength(int n) {
        return 14 + n;
    }

    protected boolean validateHeader() {
        return this.qqNum == this.user.getQQ();
    }

    protected int getHeadLength() {
        return 13;
    }

    protected int getTailLength() {
        return 1;
    }

    public String getPacketName() {
        return "Unknown Outcoming _08Packet - 05 Family";
    }

    protected void putHead(ByteBuffer byteBuffer) {
        byteBuffer.put((byte)5);
        byteBuffer.putChar(this.source);
        byteBuffer.putChar('\u0000');
        byteBuffer.putChar(this.command);
        byteBuffer.putChar(this.sequence);
        byteBuffer.putInt(this.user.getQQ());
    }

    protected void putTail(ByteBuffer byteBuffer) {
        byteBuffer.put((byte)3);
    }

    protected void postFill(ByteBuffer byteBuffer, int n) {
        byteBuffer.putChar(n + 3, (char)(byteBuffer.position() - n));
    }

    protected void parseHeader(ByteBuffer byteBuffer) throws PacketParseException {
        this.header = byteBuffer.get();
        this.source = byteBuffer.getChar();
        byteBuffer.getChar();
        this.command = byteBuffer.getChar();
        this.sequence = byteBuffer.getChar();
        this.qqNum = byteBuffer.getInt();
    }

    protected void parseTail(ByteBuffer byteBuffer) throws PacketParseException {
        byteBuffer.get();
    }

    protected byte[] getBodyBytes(ByteBuffer byteBuffer, int n) {
        int n2 = n - 13 - 1;
        byte[] byArray = new byte[n2];
        byteBuffer.get(byArray);
        return byArray;
    }

    public int getFamily() {
        return 2;
    }
}

