/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icon;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.StringBlock;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ExtraInfoBlock;
import net.kano.joscar.snaccmd.icon.IconCommand;

public class IconDataCmd
extends IconCommand {
    public static final int CODE_DEFAULT = 0;
    private final String sn;
    private final ExtraInfoBlock iconInfo;
    private final ByteBlock iconData;

    protected IconDataCmd(SnacPacket packet) {
        super(5);
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ByteBlock snacData = packet.getData();
        StringBlock snInfo = OscarTools.readScreenname(snacData);
        this.sn = snInfo.getString();
        ByteBlock rest = snacData.subBlock(snInfo.getTotalSize());
        this.iconInfo = ExtraInfoBlock.readExtraInfoBlock(rest);
        rest = rest.subBlock(this.iconInfo.getTotalSize());
        int iconSize = BinaryTools.getUShort((ByteBlock)rest, (int)0);
        this.iconData = rest.subBlock(2, iconSize);
    }

    public IconDataCmd(String sn, ExtraInfoBlock iconInfo, ByteBlock iconData) {
        super(5);
        DefensiveTools.checkNull((Object)sn, (String)"sn");
        this.sn = sn;
        this.iconInfo = iconInfo;
        this.iconData = iconData;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public final ExtraInfoBlock getIconInfo() {
        return this.iconInfo;
    }

    public final ByteBlock getIconData() {
        return this.iconData;
    }

    public void writeData(OutputStream out) throws IOException {
        OscarTools.writeScreenname(out, this.sn);
        if (this.iconInfo != null) {
            this.iconInfo.write(out);
            if (this.iconData != null) {
                BinaryTools.writeUShort((OutputStream)out, (int)this.iconData.getLength());
                this.iconData.write(out);
            }
        }
    }

    public String toString() {
        return "IconDataCmd: icon for " + this.sn + ": iconInfo=<" + this.iconInfo + ">, icon=" + (this.iconData == null ? -1 : this.iconData.getLength()) + " bytes";
    }
}

