/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pl.mn.communicator.IMessage;
import pl.mn.communicator.MessageClass;

public abstract class AbstractMessage
implements IMessage {
    private static final Log LOGGER = LogFactory.getLog((Class)AbstractMessage.class);
    protected int m_recipientUin = -1;
    protected String m_messageBody = null;
    protected MessageClass m_messageClass = null;
    protected int m_messageID = -1;

    protected AbstractMessage(int recepientUin, String messageBody, MessageClass messageClass) {
        if (recepientUin < 0) {
            throw new IllegalArgumentException("uin cannot be less than 0");
        }
        if (messageBody == null) {
            throw new NullPointerException("messageBody cannot be null");
        }
        if (messageClass == null) {
            throw new NullPointerException("messageClass cannot be null");
        }
        this.m_recipientUin = recepientUin;
        this.m_messageBody = messageBody;
        this.m_messageClass = messageClass;
    }

    public int getRecipientUin() {
        return this.m_recipientUin;
    }

    public String getMessageBody() {
        return this.m_messageBody;
    }

    public int getMessageID() {
        return this.m_messageID;
    }

    public MessageClass getMessageClass() {
        return this.m_messageClass;
    }

    public String toString() {
        return "[RecipientUin: " + this.m_recipientUin + ", messageBody: " + this.m_messageBody + ", messageClass: " + this.m_messageClass + "]";
    }
}

