/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.content.merge;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.IncompatibleSourceException;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.MediaProxy;
import javax.media.NoDataSourceException;
import net.sf.fmj.media.protocol.merge.DataSource;
import net.sf.fmj.utility.LoggerSingleton;

public class Handler
implements MediaProxy {
    private static final Logger logger = LoggerSingleton.logger;
    private DataSource source;

    public javax.media.protocol.DataSource getDataSource() throws IOException, NoDataSourceException {
        try {
            String string = this.source.getLocator().getRemainder();
            if (string.length() < 3) {
                throw new NoDataSourceException("URL is too short to contain start char, end char, and at least 1 embedded URL");
            }
            String string2 = "" + string.charAt(0);
            String string3 = "" + string.charAt(string.length() - 1);
            String string4 = "\\" + string3 + "\\" + string2;
            String[] stringArray = string.substring(1, string.length() - 1).split(string4);
            if (stringArray.length == 0) {
                throw new NoDataSourceException("No URLs embedded within URL: " + this.source.getLocator());
            }
            javax.media.protocol.DataSource[] dataSourceArray = new javax.media.protocol.DataSource[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string5 = stringArray[i];
                dataSourceArray[i] = Manager.createDataSource(new MediaLocator(string5));
            }
            try {
                return Manager.createMergingDataSource(dataSourceArray);
            }
            catch (IncompatibleSourceException incompatibleSourceException) {
                logger.log(Level.WARNING, "" + incompatibleSourceException, incompatibleSourceException);
                throw new NoDataSourceException("" + incompatibleSourceException);
            }
        }
        catch (NoDataSourceException noDataSourceException) {
            logger.log(Level.WARNING, "" + noDataSourceException, noDataSourceException);
            throw noDataSourceException;
        }
    }

    public void setSource(javax.media.protocol.DataSource dataSource) throws IOException, IncompatibleSourceException {
        if (!(dataSource instanceof DataSource)) {
            throw new IncompatibleSourceException();
        }
        this.source = (DataSource)dataSource;
    }
}

