/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.media.codec.audio.ilbc;

import net.java.sip.communicator.impl.media.codec.audio.ilbc.bitpack;
import net.java.sip.communicator.impl.media.codec.audio.ilbc.bitstream;
import net.java.sip.communicator.impl.media.codec.audio.ilbc.ilbc_common;
import net.java.sip.communicator.impl.media.codec.audio.ilbc.ilbc_constants;
import net.java.sip.communicator.impl.media.codec.audio.ilbc.ilbc_ulp;

class ilbc_encoder {
    int mode;
    float[] anaMem;
    float[] lsfold;
    float[] lsfdeqold;
    float[] lpc_buffer;
    float[] hpimem;
    ilbc_ulp ULP_inst = null;

    public ilbc_encoder(int n) throws Error {
        int n2;
        this.mode = n;
        if (this.mode != 30 && this.mode != 20) {
            throw new Error("invalid mode");
        }
        this.ULP_inst = new ilbc_ulp(this.mode);
        this.anaMem = new float[ilbc_constants.LPC_FILTERORDER];
        this.lsfold = new float[ilbc_constants.LPC_FILTERORDER];
        this.lsfdeqold = new float[ilbc_constants.LPC_FILTERORDER];
        this.lpc_buffer = new float[ilbc_constants.LPC_LOOKBACK + ilbc_constants.BLOCKL_MAX];
        this.hpimem = new float[4];
        for (n2 = 0; n2 < this.anaMem.length; ++n2) {
            this.anaMem[n2] = 0.0f;
        }
        System.arraycopy(ilbc_constants.lsfmeanTbl, 0, this.lsfdeqold, 0, ilbc_constants.LPC_FILTERORDER);
        System.arraycopy(ilbc_constants.lsfmeanTbl, 0, this.lsfold, 0, ilbc_constants.LPC_FILTERORDER);
        for (n2 = 0; n2 < this.lpc_buffer.length; ++n2) {
            this.lpc_buffer[n2] = 0.0f;
        }
        for (n2 = 0; n2 < this.hpimem.length; ++n2) {
            this.hpimem[n2] = 0.0f;
        }
    }

    void a2lsf(float[] fArray, int n, float[] fArray2) {
        int n2;
        float[] fArray3 = new float[]{0.00635f, 0.003175f, 0.0015875f, 7.9375E-4f};
        float[] fArray4 = new float[ilbc_constants.LPC_HALFORDER];
        float[] fArray5 = new float[ilbc_constants.LPC_HALFORDER];
        float[] fArray6 = new float[ilbc_constants.LPC_HALFORDER];
        float[] fArray7 = new float[ilbc_constants.LPC_HALFORDER];
        int n3 = 0;
        int n4 = 1;
        float[] fArray8 = new float[2];
        for (n2 = 0; n2 < ilbc_constants.LPC_HALFORDER; ++n2) {
            fArray4[n2] = -1.0f * (fArray2[n2 + 1] + fArray2[ilbc_constants.LPC_FILTERORDER - n2]);
            fArray5[n2] = fArray2[ilbc_constants.LPC_FILTERORDER - n2] - fArray2[n2 + 1];
        }
        fArray6[0] = -1.0f - fArray4[0];
        fArray6[1] = -fArray6[0] - fArray4[1];
        fArray6[2] = -fArray6[1] - fArray4[2];
        fArray6[3] = -fArray6[2] - fArray4[3];
        fArray6[4] = -fArray6[3] - fArray4[4];
        fArray6[4] = fArray6[4] / 2.0f;
        fArray7[0] = 1.0f - fArray5[0];
        fArray7[1] = fArray7[0] - fArray5[1];
        fArray7[2] = fArray7[1] - fArray5[2];
        fArray7[3] = fArray7[2] - fArray5[3];
        fArray7[4] = fArray7[3] - fArray5[4];
        fArray7[4] = fArray7[4] / 2.0f;
        float f = 0.0f;
        float f2 = 0.0f;
        fArray8[n3] = ilbc_constants.DOUBLE_MAX;
        fArray8[n4] = ilbc_constants.DOUBLE_MAX;
        for (int i = 0; i < ilbc_constants.LPC_FILTERORDER; ++i) {
            int n5;
            float[] fArray9;
            if ((i & 1) == 0) {
                fArray9 = fArray6;
                n5 = n3;
            } else {
                fArray9 = fArray7;
                n5 = n4;
            }
            int n6 = 0;
            float f3 = fArray3[n6];
            while (n6 < ilbc_constants.LSF_NUMBER_OF_STEPS) {
                float f4;
                float f5;
                float f6;
                float f7;
                float f8 = (float)Math.cos(f * ilbc_constants.TWO_PI);
                float f9 = f8 * (f7 = 2.0f * f8 * (f6 = 2.0f * f8 * (f5 = 2.0f * f8 * (f4 = 2.0f * f8 + fArray9[0]) - 1.0f + fArray9[1]) - f4 + fArray9[2]) - f5 + fArray9[3]) - f6 + fArray9[4];
                if (f9 * fArray8[n5] <= 0.0f || (double)f >= 0.5) {
                    if (n6 == ilbc_constants.LSF_NUMBER_OF_STEPS - 1) {
                        fArray[n + i] = Math.abs(f9) >= Math.abs(fArray8[n5]) ? f - f3 : f;
                        fArray8[n5] = fArray8[n5] >= 0.0f ? -1.0f * ilbc_constants.DOUBLE_MAX : ilbc_constants.DOUBLE_MAX;
                        f = f2;
                        n6 = 0;
                        n6 = ilbc_constants.LSF_NUMBER_OF_STEPS;
                        continue;
                    }
                    if (n6 == 0) {
                        f2 = f;
                    }
                    f -= fArray3[++n6];
                    f3 = fArray3[n6];
                    continue;
                }
                fArray8[n5] = f9;
                f += f3;
            }
        }
        for (n2 = 0; n2 < ilbc_constants.LPC_FILTERORDER; ++n2) {
            fArray[n + n2] = fArray[n + n2] * ilbc_constants.TWO_PI;
        }
    }

    void AbsQuantW(float[] fArray, int n, float[] fArray2, int n2, float[] fArray3, int n3, int[] nArray, int n4, int n5) {
        float[] fArray4 = new float[ilbc_constants.LPC_FILTERORDER + ilbc_constants.STATE_SHORT_LEN_30MS];
        int[] nArray2 = new int[1];
        for (int i = 0; i < ilbc_constants.LPC_FILTERORDER; ++i) {
            fArray4[i] = 0.0f;
        }
        int n6 = ilbc_constants.LPC_FILTERORDER;
        if (n5 != 0) {
            ilbc_common.AllPoleFilter(fArray, n, fArray3, n3, ilbc_constants.SUBL, ilbc_constants.LPC_FILTERORDER);
        } else {
            ilbc_common.AllPoleFilter(fArray, n, fArray3, n3, this.ULP_inst.state_short_len - ilbc_constants.SUBL, ilbc_constants.LPC_FILTERORDER);
        }
        for (int i = 0; i < n4; ++i) {
            if (n5 != 0 && i == ilbc_constants.SUBL) {
                n2 += ilbc_constants.LPC_FILTERORDER + 1;
                ilbc_common.AllPoleFilter(fArray, n + i, fArray3, n3 += ilbc_constants.LPC_FILTERORDER + 1, n4 - i, ilbc_constants.LPC_FILTERORDER);
            } else if (n5 == 0 && i == this.ULP_inst.state_short_len - ilbc_constants.SUBL) {
                n2 += ilbc_constants.LPC_FILTERORDER + 1;
                ilbc_common.AllPoleFilter(fArray, n + i, fArray3, n3 += ilbc_constants.LPC_FILTERORDER + 1, n4 - i, ilbc_constants.LPC_FILTERORDER);
            }
            fArray4[n6 + i] = 0.0f;
            ilbc_common.AllPoleFilter(fArray4, n6 + i, fArray3, n3, 1, ilbc_constants.LPC_FILTERORDER);
            float f = fArray[n + i] - fArray4[n6 + i];
            float f2 = this.sort_sq(nArray2, 0, f, ilbc_constants.state_sq3Tbl, 8);
            nArray[i] = nArray2[0];
            fArray4[n6 + i] = ilbc_constants.state_sq3Tbl[nArray[i]];
            ilbc_common.AllPoleFilter(fArray4, n6 + i, fArray3, n3, 1, ilbc_constants.LPC_FILTERORDER);
        }
    }

    private void anaFilter(float[] fArray, int n, float[] fArray2, int n2, int n3, float[] fArray3, int n4, float[] fArray4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = n4;
        for (n8 = 0; n8 < ilbc_constants.LPC_FILTERORDER; ++n8) {
            n7 = n + n8;
            int n10 = ilbc_constants.LPC_FILTERORDER - 1;
            n6 = n2;
            fArray3[n9] = 0.0f;
            for (n5 = 0; n5 <= n8; ++n5) {
                int n11 = n9;
                fArray3[n11] = fArray3[n11] + fArray2[n6] * fArray[n7];
                ++n6;
                --n7;
            }
            for (n5 = n8 + 1; n5 < ilbc_constants.LPC_FILTERORDER + 1; ++n5) {
                int n12 = n9;
                fArray3[n12] = fArray3[n12] + fArray2[n6] * fArray4[n10];
                ++n6;
                --n10;
            }
            ++n9;
        }
        for (n8 = ilbc_constants.LPC_FILTERORDER; n8 < n3; ++n8) {
            n7 = n + n8;
            n6 = n2;
            fArray3[n9] = 0.0f;
            for (n5 = 0; n5 < ilbc_constants.LPC_FILTERORDER + 1; ++n5) {
                int n13 = n9;
                fArray3[n13] = fArray3[n13] + fArray2[n6] * fArray[n7];
                ++n6;
                --n7;
            }
            ++n9;
        }
        System.arraycopy(fArray, n + n3 - ilbc_constants.LPC_FILTERORDER, fArray4, 0, ilbc_constants.LPC_FILTERORDER);
    }

    public void autocorr(float[] fArray, float[] fArray2, int n, int n2) {
        for (int i = 0; i <= n2; ++i) {
            float f = 0.0f;
            for (int j = 0; j < n - i; ++j) {
                f += fArray2[j] * fArray2[j + i];
            }
            fArray[i] = f;
        }
    }

    private void createAugmentedVec(int n, float[] fArray, int n2, float[] fArray2) {
        int n3 = n - 5;
        int n4 = n2 - n;
        System.arraycopy(fArray, n4, fArray2, 0, n);
        float f = 0.2f;
        float f2 = 0.0f;
        int n5 = n2 - 5;
        int n6 = n2 - n - 5;
        for (int i = n3; i < n; ++i) {
            float f3 = (1.0f - f2) * fArray[n5] + f2 * fArray[n6];
            ++n5;
            ++n6;
            fArray2[i] = f3;
            f2 += f;
        }
        n4 = n2 - n;
        System.arraycopy(fArray, n4, fArray2, n, ilbc_constants.SUBL - n);
    }

    public short encode(short[] sArray, short[] sArray2) {
        int n;
        float[] fArray = new float[this.ULP_inst.blockl];
        bitstream bitstream2 = new bitstream(this.ULP_inst.no_of_bytes * 2);
        for (n = 0; n < this.ULP_inst.blockl; ++n) {
            fArray[n] = sArray2[n];
        }
        this.iLBC_encode(bitstream2, fArray);
        for (n = 0; n < sArray.length; ++n) {
            sArray[n] = (short)(bitstream2.buffer[2 * n] << 8 & 0xFF00 | (short)bitstream2.buffer[2 * n + 1] & 0xFF);
        }
        return (short)this.ULP_inst.no_of_bytes;
    }

    private void filteredCBvecs(float[] fArray, float[] fArray2, int n, int n2) {
        int n3;
        float[] fArray3 = new float[ilbc_constants.CB_MEML + ilbc_constants.CB_FILTERLEN];
        for (n3 = 0; n3 < ilbc_constants.CB_HALFFILTERLEN; ++n3) {
            fArray3[n3] = 0.0f;
        }
        System.arraycopy(fArray2, n, fArray3, ilbc_constants.CB_HALFFILTERLEN - 1, n2);
        for (n3 = n2 + ilbc_constants.CB_HALFFILTERLEN - 1; n3 < n2 + ilbc_constants.CB_FILTERLEN; ++n3) {
            fArray3[n3] = 0.0f;
        }
        int n4 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            fArray[n3] = 0.0f;
        }
        for (int i = 0; i < n2; ++i) {
            int n5 = i;
            int n6 = ilbc_constants.CB_FILTERLEN - 1;
            for (int j = 0; j < ilbc_constants.CB_FILTERLEN; ++j) {
                int n7 = n4;
                fArray[n7] = fArray[n7] + fArray3[n5] * ilbc_constants.cbfiltersTbl[n6];
                ++n5;
                --n6;
            }
            ++n4;
        }
    }

    int FrameClassify(float[] fArray) {
        int n;
        int n2;
        float[] fArray2 = new float[ilbc_constants.NSUB_MAX];
        float[] fArray3 = new float[ilbc_constants.NSUB_MAX];
        float[] fArray4 = new float[]{0.8f, 0.9f, 1.0f, 0.9f, 0.8f};
        float[] fArray5 = new float[]{0.16666667f, 0.33333334f, 0.5f, 0.6666667f, 0.8333333f};
        for (n2 = 0; n2 < ilbc_constants.NSUB_MAX; ++n2) {
            fArray2[n2] = 0.0f;
        }
        for (n2 = 0; n2 < ilbc_constants.NSUB_MAX; ++n2) {
            fArray3[n2] = 0.0f;
        }
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < 5; ++n) {
            int n5 = n3;
            fArray2[n5] = fArray2[n5] + fArray5[n] * fArray[n4] * fArray[n4];
            ++n4;
        }
        for (n = 5; n < ilbc_constants.SUBL; ++n) {
            int n6 = n3;
            fArray2[n6] = fArray2[n6] + fArray[n4] * fArray[n4];
            ++n4;
        }
        for (n3 = 1; n3 < this.ULP_inst.nsub - 1; ++n3) {
            n4 = n3 * ilbc_constants.SUBL;
            for (n = 0; n < 5; ++n) {
                int n7 = n3;
                fArray2[n7] = fArray2[n7] + fArray5[n] * fArray[n4] * fArray[n4];
                int n8 = n3;
                fArray3[n8] = fArray3[n8] + fArray[n4] * fArray[n4];
                ++n4;
            }
            for (n = 5; n < ilbc_constants.SUBL - 5; ++n) {
                int n9 = n3;
                fArray2[n9] = fArray2[n9] + fArray[n4] * fArray[n4];
                int n10 = n3;
                fArray3[n10] = fArray3[n10] + fArray[n4] * fArray[n4];
                ++n4;
            }
            for (n = ilbc_constants.SUBL - 5; n < ilbc_constants.SUBL; ++n) {
                int n11 = n3;
                fArray2[n11] = fArray2[n11] + fArray[n4] * fArray[n4];
                int n12 = n3;
                fArray3[n12] = fArray3[n12] + fArray5[ilbc_constants.SUBL - n - 1] * fArray[n4] * fArray[n4];
                ++n4;
            }
        }
        n3 = this.ULP_inst.nsub - 1;
        n4 = n3 * ilbc_constants.SUBL;
        for (n = 0; n < ilbc_constants.SUBL - 5; ++n) {
            int n13 = n3;
            fArray3[n13] = fArray3[n13] + fArray[n4] * fArray[n4];
            ++n4;
        }
        for (n = ilbc_constants.SUBL - 5; n < ilbc_constants.SUBL; ++n) {
            int n14 = n3;
            fArray3[n14] = fArray3[n14] + fArray5[ilbc_constants.SUBL - n - 1] * fArray[n4] * fArray[n4];
            ++n4;
        }
        n = this.ULP_inst.mode == 20 ? 1 : 0;
        float f = (fArray2[0] + fArray3[1]) * fArray4[n];
        int n15 = 1;
        for (n3 = 2; n3 < this.ULP_inst.nsub; ++n3) {
            if (!((fArray2[n3 - 1] + fArray3[n3]) * fArray4[++n] > f)) continue;
            f = (fArray2[n3 - 1] + fArray3[n3]) * fArray4[n];
            n15 = n3;
        }
        return n15;
    }

    public void hpInput(float[] fArray, int n, float[] fArray2, float[] fArray3) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            fArray2[n4] = ilbc_constants.hpi_zero_coefsTbl[0] * fArray[n3];
            int n5 = n4;
            fArray2[n5] = fArray2[n5] + ilbc_constants.hpi_zero_coefsTbl[1] * fArray3[0];
            int n6 = n4++;
            fArray2[n6] = fArray2[n6] + ilbc_constants.hpi_zero_coefsTbl[2] * fArray3[1];
            fArray3[1] = fArray3[0];
            fArray3[0] = fArray[n3];
            ++n3;
        }
        n4 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            int n7 = n4;
            fArray2[n7] = fArray2[n7] - ilbc_constants.hpi_pole_coefsTbl[1] * fArray3[2];
            int n8 = n4;
            fArray2[n8] = fArray2[n8] - ilbc_constants.hpi_pole_coefsTbl[2] * fArray3[3];
            fArray3[3] = fArray3[2];
            fArray3[2] = fArray2[n4];
            ++n4;
        }
    }

    public void iCBSearch(int[] nArray, int n, int[] nArray2, int n2, float[] fArray, int n3, float[] fArray2, int n4, int n5, int n6, int n7, float[] fArray3, int n8, float[] fArray4, int n9) {
        float f;
        int n10;
        int n11;
        int n12;
        float[] fArray5 = new float[ilbc_constants.CB_NSTAGES];
        float[] fArray6 = new float[ilbc_constants.SUBL];
        int n13 = 0;
        int n14 = 0;
        float[] fArray7 = new float[ilbc_constants.CB_MEML + ilbc_constants.SUBL + 2 * ilbc_constants.LPC_FILTERORDER];
        float[] fArray8 = new float[ilbc_constants.CB_EXPAND * 128];
        float[] fArray9 = new float[ilbc_constants.CB_EXPAND * 128];
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        float[] fArray10 = new float[ilbc_constants.CB_MEML];
        float[] fArray11 = new float[ilbc_constants.SUBL];
        float[] fArray12 = new float[ilbc_constants.SUBL];
        float[] fArray13 = new float[1];
        int[] nArray3 = new int[1];
        float[] fArray14 = new float[1];
        for (n12 = 0; n12 < ilbc_constants.SUBL; ++n12) {
            fArray11[n12] = 0.0f;
        }
        int n18 = n5 - n6 + 1;
        if (n6 == ilbc_constants.SUBL) {
            n18 = n5 - n6 + 1 + n6 / 2;
        }
        System.arraycopy(fArray4, 0, fArray7, 0, ilbc_constants.LPC_FILTERORDER);
        System.arraycopy(fArray2, n4, fArray7, ilbc_constants.LPC_FILTERORDER, n5);
        System.arraycopy(fArray, n3, fArray7, ilbc_constants.LPC_FILTERORDER + n5, n6);
        ilbc_common.AllPoleFilter(fArray7, ilbc_constants.LPC_FILTERORDER, fArray3, n8, n5 + n6, ilbc_constants.LPC_FILTERORDER);
        System.arraycopy(fArray7, ilbc_constants.LPC_FILTERORDER + n5, fArray6, 0, n6);
        float f2 = 0.0f;
        for (n11 = 0; n11 < n6; ++n11) {
            f2 += fArray6[n11] * fArray6[n11];
        }
        this.filteredCBvecs(fArray10, fArray7, ilbc_constants.LPC_FILTERORDER, n5);
        for (int i = 0; i < n7; ++i) {
            float[] fArray15;
            int n19;
            int n20;
            int n21;
            float f3;
            int n22 = ilbc_constants.search_rangeTbl[n9][i];
            float f4 = -1.0E7f;
            float f5 = 0.0f;
            int n23 = 0;
            float f6 = 0.0f;
            int n24 = ilbc_constants.LPC_FILTERORDER + n5 - n6;
            for (n10 = 0; n10 < n6; ++n10) {
                f6 += fArray6[n10] * fArray7[n24];
                ++n24;
            }
            if (i == 0) {
                n17 = 0;
                n15 = ilbc_constants.LPC_FILTERORDER + n5 - n6 - 1;
                n16 = ilbc_constants.LPC_FILTERORDER + n5 - 1;
                fArray9[n17] = 0.0f;
                n24 = ilbc_constants.LPC_FILTERORDER + n5 - n6;
                for (n10 = 0; n10 < n6; ++n10) {
                    int n25 = n17;
                    fArray9[n25] = fArray9[n25] + fArray7[n24] * fArray7[n24];
                    ++n24;
                }
                fArray8[0] = fArray9[n17] > 0.0f ? 1.0f / (fArray9[n17] + ilbc_constants.EPS) : 0.0f;
                ++n17;
                f3 = -1.0E7f;
                if (f6 > 0.0f) {
                    f3 = f6 * f6 * fArray8[0];
                }
            } else {
                f3 = f6 * f6 * fArray8[0];
            }
            f = f6 * fArray8[0];
            if (f3 > f4 && Math.abs(f) < ilbc_constants.CB_MAXGAIN) {
                n23 = 0;
                f4 = f3;
                f5 = f;
            }
            for (n21 = 1; n21 < n22; ++n21) {
                f6 = 0.0f;
                n24 = ilbc_constants.LPC_FILTERORDER + n5 - n6 - n21;
                for (n10 = 0; n10 < n6; ++n10) {
                    f6 += fArray6[n10] * fArray7[n24];
                    ++n24;
                }
                if (i == 0) {
                    fArray9[n17] = fArray9[n21 - 1] + fArray7[n15] * fArray7[n15] - fArray7[n16] * fArray7[n16];
                    ++n17;
                    --n16;
                    --n15;
                    fArray8[n21] = fArray9[n21] > 0.0f ? 1.0f / (fArray9[n21] + ilbc_constants.EPS) : 0.0f;
                    f3 = -1.0E7f;
                    if (f6 > 0.0f) {
                        f3 = f6 * f6 * fArray8[n21];
                    }
                } else {
                    f3 = f6 * f6 * fArray8[n21];
                }
                f = f6 * fArray8[n21];
                if (!(f3 > f4) || !(Math.abs(f) < ilbc_constants.CB_MAXGAIN)) continue;
                n23 = n21;
                f4 = f3;
                f5 = f;
            }
            if (n6 == ilbc_constants.SUBL) {
                fArray13[0] = f4;
                nArray3[0] = n23;
                fArray14[0] = f5;
                this.searchAugmentedCB(20, 39, i, n18 - n6 / 2, fArray6, fArray7, ilbc_constants.LPC_FILTERORDER + n5, fArray13, nArray3, fArray14, fArray9, fArray8);
                f4 = fArray13[0];
                n23 = nArray3[0];
                f5 = fArray14[0];
            }
            int n26 = n23;
            if (ilbc_constants.CB_RESRANGE == -1) {
                n20 = 0;
                n19 = n22 - 1;
                n13 = 20;
                n14 = 39;
            } else {
                n13 = 0;
                n14 = 0;
                n20 = n26 - ilbc_constants.CB_RESRANGE / 2;
                n19 = n20 + ilbc_constants.CB_RESRANGE;
                if (n6 == ilbc_constants.SUBL) {
                    if (n20 < 0) {
                        n13 = 40 + n20;
                        n14 = 39;
                        n20 = 0;
                    } else if (n26 < n18 - 20) {
                        if (n19 > n22) {
                            n20 -= n19 - n22;
                            n19 = n22;
                        }
                    } else if (n20 < n18 - 20) {
                        n13 = 20;
                        n20 = 0;
                        n19 = 0;
                        n14 = 19 + ilbc_constants.CB_RESRANGE;
                        if (n14 > 39) {
                            n19 = n14 - 39;
                            n14 = 39;
                        }
                    } else {
                        n13 = 20 + n20 - (n18 - 20);
                        n14 = 39;
                        n20 = 0;
                        n19 = ilbc_constants.CB_RESRANGE - (n14 - n13 + 1);
                    }
                } else {
                    if (n20 < 0) {
                        n19 -= n20;
                        n20 = 0;
                    }
                    if (n19 > n22) {
                        n20 -= n19 - n22;
                        n19 = n22;
                    }
                }
            }
            int n27 = n20;
            n20 += n18;
            n19 += n18;
            if (i == 0) {
                n17 = n18;
                fArray9[n17] = 0.0f;
                n24 = n5 - n6;
                for (n10 = 0; n10 < n6; ++n10) {
                    int n28 = n17;
                    fArray9[n28] = fArray9[n28] + fArray10[n24] * fArray10[n24];
                    ++n24;
                }
                n15 = n5 - 1 - n6;
                n16 = n5 - 1;
                for (n10 = 0; n10 < n22 - 1; ++n10) {
                    fArray9[n17 + 1] = fArray9[n17] + fArray10[n15] * fArray10[n15] - fArray10[n16] * fArray10[n16];
                    --n16;
                    --n15;
                    ++n17;
                }
            }
            for (n21 = n20; n21 < n19; ++n21) {
                f6 = 0.0f;
                n24 = n5 - n27++ - n6;
                for (n10 = 0; n10 < n6; ++n10) {
                    f6 += fArray6[n10] * fArray10[n24];
                    ++n24;
                }
                fArray8[n21] = fArray9[n21] > 0.0f ? 1.0f / (fArray9[n21] + ilbc_constants.EPS) : 0.0f;
                if (i == 0) {
                    f3 = -1.0E7f;
                    if (f6 > 0.0f) {
                        f3 = f6 * f6 * fArray8[n21];
                    }
                } else {
                    f3 = f6 * f6 * fArray8[n21];
                }
                f = f6 * fArray8[n21];
                if (!(f3 > f4) || !(Math.abs(f) < ilbc_constants.CB_MAXGAIN)) continue;
                n23 = n21;
                f4 = f3;
                f5 = f;
            }
            if (n6 == ilbc_constants.SUBL && n13 != 0) {
                fArray13[0] = f4;
                nArray3[0] = n23;
                fArray14[0] = f5;
                this.searchAugmentedCB(n13, n14, i, 2 * n18 - 20, fArray6, fArray10, n5, fArray13, nArray3, fArray14, fArray9, fArray8);
                f4 = fArray13[0];
                n23 = nArray3[0];
                f5 = fArray14[0];
            }
            nArray[n + i] = n23;
            if (i == 0) {
                if (f5 < 0.0f) {
                    f5 = 0.0f;
                }
                if (f5 > ilbc_constants.CB_MAXGAIN) {
                    f5 = ilbc_constants.CB_MAXGAIN;
                }
                f5 = ilbc_common.gainquant(f5, 1.0f, 32, nArray2, n2 + i);
            } else {
                f5 = i == 1 ? ilbc_common.gainquant(f5, Math.abs(fArray5[i - 1]), 16, nArray2, n2 + i) : ilbc_common.gainquant(f5, Math.abs(fArray5[i - 1]), 8, nArray2, n2 + i);
            }
            if (n6 == ilbc_constants.STATE_LEN - this.ULP_inst.state_short_len) {
                if (nArray[n + i] < n18) {
                    n24 = ilbc_constants.LPC_FILTERORDER + n5 - n6 - nArray[n + i];
                    fArray15 = fArray7;
                } else {
                    n24 = n5 - n6 - nArray[n + i] + n18;
                    fArray15 = fArray10;
                }
            } else if (nArray[n + i] < n18) {
                if (nArray[n + i] < n18 - 20) {
                    n24 = ilbc_constants.LPC_FILTERORDER + n5 - n6 - nArray[n + i];
                    fArray15 = fArray7;
                } else {
                    this.createAugmentedVec(nArray[n + i] - n18 + 40, fArray7, ilbc_constants.LPC_FILTERORDER + n5, fArray12);
                    n24 = 0;
                    fArray15 = fArray12;
                }
            } else {
                n12 = nArray[n + i] / n18;
                int n29 = nArray[n + i] - n12 * n18;
                if (n29 < n18 - 20) {
                    n24 = n12 * n5 - n6 - nArray[n + i] + n12 * n18;
                    fArray15 = fArray10;
                } else {
                    this.createAugmentedVec(nArray[n + i] - (n12 + 1) * n18 + 40, fArray10, n12 * n5, fArray12);
                    n24 = 0;
                    fArray15 = fArray12;
                }
            }
            n10 = 0;
            while (n10 < n6) {
                int n30 = n10;
                fArray11[n30] = fArray11[n30] + f5 * fArray15[n24];
                int n31 = n10++;
                fArray6[n31] = fArray6[n31] - f5 * fArray15[n24];
                ++n24;
            }
            fArray5[i] = f5;
        }
        float f7 = 0.0f;
        for (n11 = 0; n11 < n6; ++n11) {
            f7 += fArray11[n11] * fArray11[n11];
        }
        n10 = nArray2[n2 + 0];
        for (n11 = nArray2[n2 + 0]; n11 < 32; ++n11) {
            f = f7 * ilbc_constants.gain_sq5Tbl[n11] * ilbc_constants.gain_sq5Tbl[n11];
            if (!(f < f2 * fArray5[0] * fArray5[0]) || !(ilbc_constants.gain_sq5Tbl[n10] < 2.0f * fArray5[0])) continue;
            n10 = n11;
        }
        nArray2[n2 + 0] = n10;
    }

    public void iLBC_encode(bitstream bitstream2, float[] fArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int[] nArray = new int[1];
        float[] fArray2 = new float[ilbc_constants.BLOCKL_MAX];
        float[] fArray3 = new float[ilbc_constants.BLOCKL_MAX];
        float[] fArray4 = new float[ilbc_constants.BLOCKL_MAX];
        int[] nArray2 = new int[ilbc_constants.STATE_LEN];
        float[] fArray5 = new float[ilbc_constants.BLOCKL_MAX];
        float[] fArray6 = new float[ilbc_constants.CB_MEML];
        int[] nArray3 = new int[ilbc_constants.CB_NSTAGES * ilbc_constants.NASUB_MAX];
        int[] nArray4 = new int[ilbc_constants.CB_NSTAGES];
        int[] nArray5 = new int[ilbc_constants.CB_NSTAGES * ilbc_constants.NASUB_MAX];
        int[] nArray6 = new int[ilbc_constants.CB_NSTAGES];
        int[] nArray7 = new int[ilbc_constants.LSF_NSPLIT * ilbc_constants.LPC_N_MAX];
        float[] fArray7 = new float[ilbc_constants.LPC_FILTERORDER];
        float[] fArray8 = new float[ilbc_constants.NSUB_MAX * (ilbc_constants.LPC_FILTERORDER + 1)];
        float[] fArray9 = new float[ilbc_constants.NSUB_MAX * (ilbc_constants.LPC_FILTERORDER + 1)];
        float[] fArray10 = new float[ilbc_constants.BLOCKL_MAX];
        this.hpInput(fArray, this.ULP_inst.blockl, fArray2, this.hpimem);
        this.LPCencode(fArray8, fArray9, nArray7, fArray2);
        for (n9 = 0; n9 < this.ULP_inst.nsub; ++n9) {
            this.anaFilter(fArray2, n9 * ilbc_constants.SUBL, fArray8, n9 * (ilbc_constants.LPC_FILTERORDER + 1), ilbc_constants.SUBL, fArray3, n9 * ilbc_constants.SUBL, this.anaMem);
        }
        int n10 = this.FrameClassify(fArray3);
        int n11 = ilbc_constants.STATE_LEN - this.ULP_inst.state_short_len;
        float f = 0.0f;
        int n12 = (n10 - 1) * ilbc_constants.SUBL;
        for (n8 = 0; n8 < this.ULP_inst.state_short_len; ++n8) {
            f += fArray3[n12 + n8] * fArray3[n12 + n8];
        }
        float f2 = 0.0f;
        n12 = (n10 - 1) * ilbc_constants.SUBL + n11;
        for (n8 = 0; n8 < this.ULP_inst.state_short_len; ++n8) {
            f2 += fArray3[n12 + n8] * fArray3[n12 + n8];
        }
        if (f > f2) {
            n7 = 1;
            n6 = (n10 - 1) * ilbc_constants.SUBL;
        } else {
            n7 = 0;
            n6 = (n10 - 1) * ilbc_constants.SUBL + n11;
        }
        this.StateSearchW(fArray3, n6, fArray8, (n10 - 1) * (ilbc_constants.LPC_FILTERORDER + 1), fArray9, (n10 - 1) * (ilbc_constants.LPC_FILTERORDER + 1), nArray, nArray2, this.ULP_inst.state_short_len, n7);
        ilbc_common.StateConstructW(nArray[0], nArray2, fArray8, (n10 - 1) * (ilbc_constants.LPC_FILTERORDER + 1), fArray10, n6, this.ULP_inst.state_short_len);
        if (n7 != 0) {
            for (n5 = 0; n5 < ilbc_constants.CB_MEML - this.ULP_inst.state_short_len; ++n5) {
                fArray6[n5] = 0.0f;
            }
            System.arraycopy(fArray10, n6, fArray6, ilbc_constants.CB_MEML - this.ULP_inst.state_short_len, this.ULP_inst.state_short_len);
            for (n5 = 0; n5 < ilbc_constants.LPC_FILTERORDER; ++n5) {
                fArray7[n5] = 0.0f;
            }
            this.iCBSearch(nArray6, 0, nArray4, 0, fArray3, n6 + this.ULP_inst.state_short_len, fArray6, ilbc_constants.CB_MEML - ilbc_constants.stMemLTbl, ilbc_constants.stMemLTbl, n11, ilbc_constants.CB_NSTAGES, fArray9, n10 * (ilbc_constants.LPC_FILTERORDER + 1), fArray7, 0);
            ilbc_common.iCBConstruct(fArray10, n6 + this.ULP_inst.state_short_len, nArray6, 0, nArray4, 0, fArray6, ilbc_constants.CB_MEML - ilbc_constants.stMemLTbl, ilbc_constants.stMemLTbl, n11, ilbc_constants.CB_NSTAGES);
        } else {
            for (n4 = 0; n4 < n11; ++n4) {
                fArray4[n4] = fArray3[(n10 + 1) * ilbc_constants.SUBL - 1 - (n4 + this.ULP_inst.state_short_len)];
            }
            n3 = this.ULP_inst.state_short_len;
            for (n4 = 0; n4 < n3; ++n4) {
                fArray6[ilbc_constants.CB_MEML - 1 - n4] = fArray10[n6 + n4];
            }
            for (n5 = 0; n5 < ilbc_constants.CB_MEML - n4; ++n5) {
                fArray6[n5] = 0.0f;
            }
            for (n5 = 0; n5 < ilbc_constants.LPC_FILTERORDER; ++n5) {
                fArray7[n5] = 0.0f;
            }
            this.iCBSearch(nArray6, 0, nArray4, 0, fArray4, 0, fArray6, ilbc_constants.CB_MEML - ilbc_constants.stMemLTbl, ilbc_constants.stMemLTbl, n11, ilbc_constants.CB_NSTAGES, fArray9, (n10 - 1) * (ilbc_constants.LPC_FILTERORDER + 1), fArray7, 0);
            ilbc_common.iCBConstruct(fArray5, 0, nArray6, 0, nArray4, 0, fArray6, ilbc_constants.CB_MEML - ilbc_constants.stMemLTbl, ilbc_constants.stMemLTbl, n11, ilbc_constants.CB_NSTAGES);
            for (n4 = 0; n4 < n11; ++n4) {
                fArray10[n6 - 1 - n4] = fArray5[n4];
            }
        }
        int n13 = 0;
        int n14 = this.ULP_inst.nsub - n10 - 1;
        if (n14 > 0) {
            for (n5 = 0; n5 < ilbc_constants.CB_MEML - ilbc_constants.STATE_LEN; ++n5) {
                fArray6[n5] = 0.0f;
            }
            System.arraycopy(fArray10, (n10 - 1) * ilbc_constants.SUBL, fArray6, ilbc_constants.CB_MEML - ilbc_constants.STATE_LEN, ilbc_constants.STATE_LEN);
            for (n5 = 0; n5 < ilbc_constants.LPC_FILTERORDER; ++n5) {
                fArray7[n5] = 0.0f;
            }
            for (n2 = 0; n2 < n14; ++n2) {
                this.iCBSearch(nArray5, n13 * ilbc_constants.CB_NSTAGES, nArray3, n13 * ilbc_constants.CB_NSTAGES, fArray3, (n10 + 1 + n2) * ilbc_constants.SUBL, fArray6, ilbc_constants.CB_MEML - ilbc_constants.memLfTbl[n13], ilbc_constants.memLfTbl[n13], ilbc_constants.SUBL, ilbc_constants.CB_NSTAGES, fArray9, (n10 + 1 + n2) * (ilbc_constants.LPC_FILTERORDER + 1), fArray7, n13 + 1);
                ilbc_common.iCBConstruct(fArray10, (n10 + 1 + n2) * ilbc_constants.SUBL, nArray5, n13 * ilbc_constants.CB_NSTAGES, nArray3, n13 * ilbc_constants.CB_NSTAGES, fArray6, ilbc_constants.CB_MEML - ilbc_constants.memLfTbl[n13], ilbc_constants.memLfTbl[n13], ilbc_constants.SUBL, ilbc_constants.CB_NSTAGES);
                System.arraycopy(fArray6, ilbc_constants.SUBL, fArray6, 0, ilbc_constants.CB_MEML - ilbc_constants.SUBL);
                System.arraycopy(fArray10, (n10 + 1 + n2) * ilbc_constants.SUBL, fArray6, ilbc_constants.CB_MEML - ilbc_constants.SUBL, ilbc_constants.SUBL);
                for (n5 = 0; n5 < ilbc_constants.LPC_FILTERORDER; ++n5) {
                    fArray7[n5] = 0.0f;
                }
                ++n13;
            }
        }
        if ((n = n10 - 1) > 0) {
            for (n9 = 0; n9 < n; ++n9) {
                for (n4 = 0; n4 < ilbc_constants.SUBL; ++n4) {
                    fArray4[n9 * ilbc_constants.SUBL + n4] = fArray3[(n10 - 1) * ilbc_constants.SUBL - 1 - n9 * ilbc_constants.SUBL - n4];
                    fArray5[n9 * ilbc_constants.SUBL + n4] = fArray10[(n10 - 1) * ilbc_constants.SUBL - 1 - n9 * ilbc_constants.SUBL - n4];
                }
            }
            n3 = ilbc_constants.SUBL * (this.ULP_inst.nsub + 1 - n10);
            if (n3 > ilbc_constants.CB_MEML) {
                n3 = ilbc_constants.CB_MEML;
            }
            for (n4 = 0; n4 < n3; ++n4) {
                fArray6[ilbc_constants.CB_MEML - 1 - n4] = fArray10[(n10 - 1) * ilbc_constants.SUBL + n4];
            }
            for (n5 = 0; n5 < ilbc_constants.CB_MEML - n4; ++n5) {
                fArray6[n5] = 0.0f;
            }
            for (n5 = 0; n5 < ilbc_constants.LPC_FILTERORDER; ++n5) {
                fArray7[n5] = 0.0f;
            }
            for (n2 = 0; n2 < n; ++n2) {
                this.iCBSearch(nArray5, n13 * ilbc_constants.CB_NSTAGES, nArray3, n13 * ilbc_constants.CB_NSTAGES, fArray4, n2 * ilbc_constants.SUBL, fArray6, ilbc_constants.CB_MEML - ilbc_constants.memLfTbl[n13], ilbc_constants.memLfTbl[n13], ilbc_constants.SUBL, ilbc_constants.CB_NSTAGES, fArray9, (n10 - 2 - n2) * (ilbc_constants.LPC_FILTERORDER + 1), fArray7, n13 + 1);
                ilbc_common.iCBConstruct(fArray5, n2 * ilbc_constants.SUBL, nArray5, n13 * ilbc_constants.CB_NSTAGES, nArray3, n13 * ilbc_constants.CB_NSTAGES, fArray6, ilbc_constants.CB_MEML - ilbc_constants.memLfTbl[n13], ilbc_constants.memLfTbl[n13], ilbc_constants.SUBL, ilbc_constants.CB_NSTAGES);
                System.arraycopy(fArray6, ilbc_constants.SUBL, fArray6, 0, ilbc_constants.CB_MEML - ilbc_constants.SUBL);
                System.arraycopy(fArray5, n2 * ilbc_constants.SUBL, fArray6, ilbc_constants.CB_MEML - ilbc_constants.SUBL, ilbc_constants.SUBL);
                for (n5 = 0; n5 < ilbc_constants.LPC_FILTERORDER; ++n5) {
                    fArray7[n5] = 0.0f;
                }
                ++n13;
            }
            for (n8 = 0; n8 < ilbc_constants.SUBL * n; ++n8) {
                fArray10[ilbc_constants.SUBL * n - n8 - 1] = fArray5[n8];
            }
        }
        this.index_conv_enc(nArray5);
        boolean bl = false;
        for (int i = 0; i < 3; ++i) {
            int n15;
            bitpack bitpack2;
            int[] nArray8 = new int[1];
            for (n4 = 0; n4 < ilbc_constants.LSF_NSPLIT * this.ULP_inst.lpc_n; ++n4) {
                bitpack2 = bitstream2.packsplit(nArray7[n4], this.ULP_inst.lsf_bits[n4][i], this.ULP_inst.lsf_bits[n4][i] + this.ULP_inst.lsf_bits[n4][i + 1] + this.ULP_inst.lsf_bits[n4][i + 2]);
                n15 = bitpack2.get_firstpart();
                nArray7[n4] = bitpack2.get_rest();
                bitstream2.dopack(n15, this.ULP_inst.lsf_bits[n4][i]);
            }
            bitpack2 = bitstream2.packsplit(n10, this.ULP_inst.start_bits[i], this.ULP_inst.start_bits[i] + this.ULP_inst.start_bits[i + 1] + this.ULP_inst.start_bits[i + 2]);
            n15 = bitpack2.get_firstpart();
            n10 = bitpack2.get_rest();
            bitstream2.dopack(n15, this.ULP_inst.start_bits[i]);
            bitpack2 = bitstream2.packsplit(n7, this.ULP_inst.startfirst_bits[i], this.ULP_inst.startfirst_bits[i] + this.ULP_inst.startfirst_bits[i + 1] + this.ULP_inst.startfirst_bits[i + 2]);
            n15 = bitpack2.get_firstpart();
            n7 = bitpack2.get_rest();
            bitstream2.dopack(n15, this.ULP_inst.startfirst_bits[i]);
            bitpack2 = bitstream2.packsplit(nArray[0], this.ULP_inst.scale_bits[i], this.ULP_inst.scale_bits[i] + this.ULP_inst.scale_bits[i + 1] + this.ULP_inst.scale_bits[i + 2]);
            n15 = bitpack2.get_firstpart();
            nArray[0] = bitpack2.get_rest();
            bitstream2.dopack(n15, this.ULP_inst.scale_bits[i]);
            for (n4 = 0; n4 < this.ULP_inst.state_short_len; ++n4) {
                bitpack2 = bitstream2.packsplit(nArray2[n4], this.ULP_inst.state_bits[i], this.ULP_inst.state_bits[i] + this.ULP_inst.state_bits[i + 1] + this.ULP_inst.state_bits[i + 2]);
                n15 = bitpack2.get_firstpart();
                nArray2[n4] = bitpack2.get_rest();
                bitstream2.dopack(n15, this.ULP_inst.state_bits[i]);
            }
            for (n4 = 0; n4 < ilbc_constants.CB_NSTAGES; ++n4) {
                bitpack2 = bitstream2.packsplit(nArray6[n4], this.ULP_inst.extra_cb_index[n4][i], this.ULP_inst.extra_cb_index[n4][i] + this.ULP_inst.extra_cb_index[n4][i + 1] + this.ULP_inst.extra_cb_index[n4][i + 2]);
                n15 = bitpack2.get_firstpart();
                nArray6[n4] = bitpack2.get_rest();
                bitstream2.dopack(n15, this.ULP_inst.extra_cb_index[n4][i]);
            }
            for (n4 = 0; n4 < ilbc_constants.CB_NSTAGES; ++n4) {
                bitpack2 = bitstream2.packsplit(nArray4[n4], this.ULP_inst.extra_cb_gain[n4][i], this.ULP_inst.extra_cb_gain[n4][i] + this.ULP_inst.extra_cb_gain[n4][i + 1] + this.ULP_inst.extra_cb_gain[n4][i + 2]);
                n15 = bitpack2.get_firstpart();
                nArray4[n4] = bitpack2.get_rest();
                bitstream2.dopack(n15, this.ULP_inst.extra_cb_gain[n4][i]);
            }
            for (n8 = 0; n8 < this.ULP_inst.nasub; ++n8) {
                for (n4 = 0; n4 < ilbc_constants.CB_NSTAGES; ++n4) {
                    bitpack2 = bitstream2.packsplit(nArray5[n8 * ilbc_constants.CB_NSTAGES + n4], this.ULP_inst.cb_index[n8][n4][i], this.ULP_inst.cb_index[n8][n4][i] + this.ULP_inst.cb_index[n8][n4][i + 1] + this.ULP_inst.cb_index[n8][n4][i + 2]);
                    n15 = bitpack2.get_firstpart();
                    nArray5[n8 * ilbc_constants.CB_NSTAGES + n4] = bitpack2.get_rest();
                    bitstream2.dopack(n15, this.ULP_inst.cb_index[n8][n4][i]);
                }
            }
            for (n8 = 0; n8 < this.ULP_inst.nasub; ++n8) {
                for (n4 = 0; n4 < ilbc_constants.CB_NSTAGES; ++n4) {
                    bitpack2 = bitstream2.packsplit(nArray3[n8 * ilbc_constants.CB_NSTAGES + n4], this.ULP_inst.cb_gain[n8][n4][i], this.ULP_inst.cb_gain[n8][n4][i] + this.ULP_inst.cb_gain[n8][n4][i + 1] + this.ULP_inst.cb_gain[n8][n4][i + 2]);
                    n15 = bitpack2.get_firstpart();
                    nArray3[n8 * ilbc_constants.CB_NSTAGES + n4] = bitpack2.get_rest();
                    bitstream2.dopack(n15, this.ULP_inst.cb_gain[n8][n4][i]);
                }
            }
        }
        bitstream2.dopack(0, 1);
    }

    public void index_conv_enc(int[] nArray) {
        for (int i = 1; i < ilbc_constants.CB_NSTAGES; ++i) {
            if (nArray[i] >= 108 && nArray[i] < 172) {
                int n = i;
                nArray[n] = nArray[n] - 64;
                continue;
            }
            if (nArray[i] < 236) continue;
            int n = i;
            nArray[n] = nArray[n] - 128;
        }
    }

    public void levdurb(float[] fArray, float[] fArray2, float[] fArray3, int n) {
        fArray[0] = 1.0f;
        if (fArray3[0] < ilbc_constants.EPS) {
            for (int i = 0; i < n; ++i) {
                fArray2[i] = 0.0f;
                fArray[i + 1] = 0.0f;
            }
        } else {
            fArray[1] = fArray2[0] = -fArray3[1] / fArray3[0];
            float f = fArray3[0] + fArray3[1] * fArray2[0];
            for (int i = 1; i < n; ++i) {
                int n2;
                float f2 = fArray3[i + 1];
                for (n2 = 0; n2 < i; ++n2) {
                    f2 += fArray[n2 + 1] * fArray3[i - n2];
                }
                fArray2[i] = -f2 / f;
                f += fArray2[i] * f2;
                int n3 = i + 1 >> 1;
                for (n2 = 0; n2 < n3; ++n2) {
                    f2 = fArray[n2 + 1] + fArray2[i] * fArray[i - n2];
                    int n4 = i - n2;
                    fArray[n4] = fArray[n4] + fArray2[i] * fArray[n2 + 1];
                    fArray[n2 + 1] = f2;
                }
                fArray[i + 1] = fArray2[i];
            }
        }
    }

    void LPCencode(float[] fArray, float[] fArray2, int[] nArray, float[] fArray3) {
        float[] fArray4 = new float[ilbc_constants.LPC_FILTERORDER * ilbc_constants.LPC_N_MAX];
        float[] fArray5 = new float[ilbc_constants.LPC_FILTERORDER * ilbc_constants.LPC_N_MAX];
        int n = 0;
        this.SimpleAnalysis(fArray4, fArray3);
        this.SimplelsfQ(fArray5, nArray, fArray4, this.ULP_inst.lpc_n);
        n = ilbc_common.LSF_check(fArray5, ilbc_constants.LPC_FILTERORDER, this.ULP_inst.lpc_n);
        this.SimpleInterpolateLSF(fArray, fArray2, fArray4, fArray5, this.lsfold, this.lsfdeqold, ilbc_constants.LPC_FILTERORDER);
    }

    void LSFinterpolate2a_enc(float[] fArray, float[] fArray2, float[] fArray3, int n, float f, long l) {
        float[] fArray4 = new float[ilbc_constants.LPC_FILTERORDER];
        ilbc_common.interpolate(fArray4, fArray2, fArray3, n, f, (int)l);
        ilbc_common.lsf2a(fArray, fArray4);
    }

    private void searchAugmentedCB(int n, int n2, int n3, int n4, float[] fArray, float[] fArray2, int n5, float[] fArray3, int[] nArray, float[] fArray4, float[] fArray5, float[] fArray6) {
        int n6;
        float f = 0.0f;
        int n7 = 1 - n + n5;
        for (n6 = 0; n6 < n - 5; ++n6) {
            f += fArray2[n7] * fArray2[n7];
            ++n7;
        }
        int n8 = n5 - n;
        for (int i = n; i <= n2; ++i) {
            float f2;
            int n9 = n4 + i - 20;
            int n10 = i - 4;
            fArray5[n9] = f += fArray2[--n8] * fArray2[n8];
            float f3 = 0.0f;
            n7 = n5 - i;
            for (n6 = 0; n6 < n10; ++n6) {
                f3 += fArray[n6] * fArray2[n7];
                ++n7;
            }
            float f4 = 0.2f;
            int n11 = n5 - 4;
            int n12 = n5 - i - 4;
            for (n6 = n10; n6 < i; ++n6) {
                float f5 = (1.0f - f4) * fArray2[n11] + f4 * fArray2[n12];
                ++n11;
                ++n12;
                int n13 = n9;
                fArray5[n13] = fArray5[n13] + f5 * f5;
                f3 += fArray[n6] * f5;
                f4 += 0.2f;
            }
            n7 = n5 - i;
            for (n6 = i; n6 < ilbc_constants.SUBL; ++n6) {
                int n14 = n9;
                fArray5[n14] = fArray5[n14] + fArray2[n7] * fArray2[n7];
                f3 += fArray[n6] * fArray2[n7];
                ++n7;
            }
            fArray6[n9] = fArray5[n9] > 0.0f ? 1.0f / (fArray5[n9] + ilbc_constants.EPS) : 0.0f;
            if (n3 == 0) {
                f2 = -1.0E7f;
                if (f3 > 0.0f) {
                    f2 = f3 * f3 * fArray6[n9];
                }
            } else {
                f2 = f3 * f3 * fArray6[n9];
            }
            float f6 = f3 * fArray6[n9];
            if (!(f2 > fArray3[0]) || !(Math.abs(f6) < ilbc_constants.CB_MAXGAIN)) continue;
            nArray[0] = n9;
            fArray3[0] = f2;
            fArray4[0] = f6;
        }
    }

    void SimpleAnalysis(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[ilbc_constants.BLOCKL_MAX];
        float[] fArray4 = new float[ilbc_constants.LPC_FILTERORDER + 1];
        float[] fArray5 = new float[ilbc_constants.LPC_FILTERORDER + 1];
        float[] fArray6 = new float[ilbc_constants.LPC_FILTERORDER + 1];
        int n = ilbc_constants.LPC_LOOKBACK + ilbc_constants.BLOCKL_MAX - this.ULP_inst.blockl;
        System.arraycopy(fArray2, 0, this.lpc_buffer, n, this.ULP_inst.blockl);
        for (int i = 0; i < this.ULP_inst.lpc_n; ++i) {
            n = ilbc_constants.LPC_LOOKBACK;
            if (i < this.ULP_inst.lpc_n - 1) {
                this.window(fArray3, ilbc_constants.lpc_winTbl, this.lpc_buffer, 0, ilbc_constants.BLOCKL_MAX);
            } else {
                this.window(fArray3, ilbc_constants.lpc_asymwinTbl, this.lpc_buffer, n, ilbc_constants.BLOCKL_MAX);
            }
            this.autocorr(fArray6, fArray3, ilbc_constants.BLOCKL_MAX, ilbc_constants.LPC_FILTERORDER);
            this.window(fArray6, fArray6, ilbc_constants.lpc_lagwinTbl, 0, ilbc_constants.LPC_FILTERORDER + 1);
            this.levdurb(fArray4, fArray3, fArray6, ilbc_constants.LPC_FILTERORDER);
            ilbc_common.bwexpand(fArray5, 0, fArray4, ilbc_constants.LPC_CHIRP_SYNTDENUM, ilbc_constants.LPC_FILTERORDER + 1);
            this.a2lsf(fArray, i * ilbc_constants.LPC_FILTERORDER, fArray5);
        }
        n = ilbc_constants.LPC_LOOKBACK + ilbc_constants.BLOCKL_MAX - this.ULP_inst.blockl;
        System.arraycopy(this.lpc_buffer, ilbc_constants.LPC_LOOKBACK + ilbc_constants.BLOCKL_MAX - n, this.lpc_buffer, 0, n);
    }

    void SimpleInterpolateLSF(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5, float[] fArray6, int n) {
        float[] fArray7 = new float[ilbc_constants.LPC_FILTERORDER + 1];
        int n2 = n;
        int n3 = n;
        int n4 = n + 1;
        if (this.ULP_inst.mode == 30) {
            this.LSFinterpolate2a_enc(fArray7, fArray6, fArray4, 0, ilbc_constants.lsf_weightTbl_30ms[0], n);
            System.arraycopy(fArray7, 0, fArray, 0, n4);
            this.LSFinterpolate2a_enc(fArray7, fArray5, fArray3, 0, ilbc_constants.lsf_weightTbl_30ms[0], n);
            ilbc_common.bwexpand(fArray2, 0, fArray7, ilbc_constants.LPC_CHIRP_WEIGHTDENUM, n4);
            int n5 = n4;
            for (int i = 1; i < this.ULP_inst.nsub; ++i) {
                this.LSFinterpolate2a_enc(fArray7, fArray4, fArray4, n3, ilbc_constants.lsf_weightTbl_30ms[i], n);
                System.arraycopy(fArray7, 0, fArray, n5, n4);
                this.LSFinterpolate2a_enc(fArray7, fArray3, fArray3, n2, ilbc_constants.lsf_weightTbl_30ms[i], n);
                ilbc_common.bwexpand(fArray2, n5, fArray7, ilbc_constants.LPC_CHIRP_WEIGHTDENUM, n4);
                n5 += n4;
            }
        } else {
            int n6 = 0;
            for (int i = 0; i < this.ULP_inst.nsub; ++i) {
                this.LSFinterpolate2a_enc(fArray7, fArray6, fArray4, 0, ilbc_constants.lsf_weightTbl_20ms[i], n);
                System.arraycopy(fArray7, 0, fArray, n6, n4);
                for (int j = 0; j < n4; ++j) {
                    this.LSFinterpolate2a_enc(fArray7, fArray5, fArray3, 0, ilbc_constants.lsf_weightTbl_20ms[i], n);
                }
                ilbc_common.bwexpand(fArray2, n6, fArray7, ilbc_constants.LPC_CHIRP_WEIGHTDENUM, n4);
                n6 += n4;
            }
        }
        if (this.ULP_inst.mode == 30) {
            System.arraycopy(fArray3, n2, fArray5, 0, n);
            System.arraycopy(fArray4, n3, fArray6, 0, n);
        } else {
            System.arraycopy(fArray3, 0, fArray5, 0, n);
            System.arraycopy(fArray4, 0, fArray6, 0, n);
        }
    }

    void SimplelsfQ(float[] fArray, int[] nArray, float[] fArray2, int n) {
        this.SplitVQ(fArray, 0, nArray, 0, fArray2, 0, ilbc_constants.lsfCbTbl, ilbc_constants.LSF_NSPLIT, ilbc_constants.dim_lsfCbTbl, ilbc_constants.size_lsfCbTbl);
        if (n == 2) {
            this.SplitVQ(fArray, ilbc_constants.LPC_FILTERORDER, nArray, ilbc_constants.LSF_NSPLIT, fArray2, ilbc_constants.LPC_FILTERORDER, ilbc_constants.lsfCbTbl, ilbc_constants.LSF_NSPLIT, ilbc_constants.dim_lsfCbTbl, ilbc_constants.size_lsfCbTbl);
        }
    }

    public float sort_sq(int[] nArray, int n, float f, float[] fArray, int n2) {
        float f2;
        if (f <= fArray[0]) {
            nArray[n] = 0;
            f2 = fArray[0];
        } else {
            int n3;
            for (n3 = 0; f > fArray[n3] && n3 < n2 - 1; ++n3) {
            }
            if (f > (fArray[n3] + fArray[n3 - 1]) / 2.0f) {
                nArray[n] = n3;
                f2 = fArray[n3];
            } else {
                nArray[n] = n3 - 1;
                f2 = fArray[n3 - 1];
            }
        }
        return f2;
    }

    public void SplitVQ(float[] fArray, int n, int[] nArray, int n2, float[] fArray2, int n3, float[] fArray3, int n4, int[] nArray2, int[] nArray3) {
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n4; ++i) {
            this.vq(fArray, n6 + n, nArray, i + n2, fArray3, n5, fArray2, n6 + n3, nArray3[i], nArray2[i]);
            n6 += nArray2[i];
            n5 += nArray2[i] * nArray3[i];
        }
    }

    void StateSearchW(float[] fArray, int n, float[] fArray2, int n2, float[] fArray3, int n3, int[] nArray, int[] nArray2, int n4, int n5) {
        int n6;
        int n7;
        float[] fArray4 = new float[ilbc_constants.LPC_FILTERORDER + 2 * ilbc_constants.STATE_SHORT_LEN_30MS];
        float[] fArray5 = new float[1 + ilbc_constants.LPC_FILTERORDER];
        float[] fArray6 = new float[ilbc_constants.LPC_FILTERORDER + 2 * ilbc_constants.STATE_SHORT_LEN_30MS];
        for (n7 = 0; n7 < ilbc_constants.LPC_FILTERORDER; ++n7) {
            fArray4[n7] = 0.0f;
            fArray6[n7] = 0.0f;
        }
        for (n6 = 0; n6 < ilbc_constants.LPC_FILTERORDER; ++n6) {
            fArray5[n6] = fArray2[n2 + ilbc_constants.LPC_FILTERORDER - n6];
        }
        fArray5[ilbc_constants.LPC_FILTERORDER] = fArray2[n2];
        int n8 = ilbc_constants.LPC_FILTERORDER;
        int n9 = ilbc_constants.LPC_FILTERORDER;
        System.arraycopy(fArray, n, fArray4, n8, n4);
        for (n7 = 0; n7 < n4; ++n7) {
            fArray4[n8 + n4 + n7] = 0.0f;
        }
        ilbc_common.ZeroPoleFilter(fArray4, n8, fArray5, fArray2, n2, 2 * n4, ilbc_constants.LPC_FILTERORDER, fArray6, n9);
        for (n6 = 0; n6 < n4; ++n6) {
            int n10 = n9 + n6;
            fArray6[n10] = fArray6[n10] + fArray6[n9 + n6 + n4];
        }
        float f = fArray6[n9 + 0];
        for (n6 = 1; n6 < n4; ++n6) {
            if (!(fArray6[n9 + n6] * fArray6[n9 + n6] > f * f)) continue;
            f = fArray6[n9 + n6];
        }
        if ((f = Math.abs(f)) < 10.0f) {
            f = 10.0f;
        }
        f = (float)(Math.log(f) / Math.log(10.0));
        float f2 = this.sort_sq(nArray, 0, f, ilbc_constants.state_frgqTbl, 64);
        f = ilbc_constants.state_frgqTbl[nArray[0]];
        float f3 = (float)Math.pow(10.0, f);
        float f4 = 4.5f / f3;
        for (n6 = 0; n6 < n4; ++n6) {
            int n11 = n9 + n6;
            fArray6[n11] = fArray6[n11] * f4;
        }
        this.AbsQuantW(fArray6, n9, fArray2, n2, fArray3, n3, nArray2, n4, n5);
    }

    public void vq(float[] fArray, int n, int[] nArray, int n2, float[] fArray2, int n3, float[] fArray3, int n4, int n5, int n6) {
        int n7;
        int n8 = 0;
        float f = ilbc_constants.DOUBLE_MAX;
        int n9 = 0;
        for (int i = 0; i < n5; ++i) {
            float f2 = fArray3[n4] - fArray2[n8 + n3];
            f2 *= f2;
            for (n7 = 1; n7 < n6; ++n7) {
                float f3 = fArray3[n7 + n4] - fArray2[n8 + n7 + n3];
                f2 += f3 * f3;
            }
            if (f2 < f) {
                f = f2;
                n9 = i;
            }
            n8 += n6;
        }
        for (n7 = 0; n7 < n6; ++n7) {
            fArray[n7 + n] = fArray2[n9 * n6 + n7 + n3];
        }
        nArray[n2] = n9;
    }

    public void window(float[] fArray, float[] fArray2, float[] fArray3, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            fArray[i] = fArray2[i] * fArray3[i + n];
        }
    }
}

