/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.sctp4j;

import java.io.IOException;
import org.jitsi.sctp4j.NetworkLink;
import org.jitsi.sctp4j.Sctp;
import org.jitsi.sctp4j.SctpDataCallback;
import org.jitsi.sctp4j.SctpNotification;
import org.jitsi.util.Logger;

public class SctpSocket {
    private static final Logger logger = Logger.getLogger(SctpSocket.class);
    private boolean closed = false;
    private SctpDataCallback dataCallback;
    private NetworkLink link;
    private final int localPort;
    private NotificationListener notificationListener = new NotificationListener(){

        @Override
        public void onSctpNotification(SctpSocket socket, SctpNotification notification) {
            if (logger.isTraceEnabled()) {
                logger.trace("SctpSocket 0x" + Long.toHexString(SctpSocket.this.ptr) + " notification: " + notification);
            }
        }
    };
    private long ptr;
    private int ptrLockCount = 0;

    private static long bytes_to_long(byte[] buffer, int offset) {
        int fByte = 0xFF & buffer[offset];
        int sByte = 0xFF & buffer[offset + 1];
        int tByte = 0xFF & buffer[offset + 2];
        int foByte = 0xFF & buffer[offset + 3];
        return (long)(fByte << 24 | sByte << 16 | tByte << 8 | foByte) & 0xFFFFFFFFL;
    }

    private static int bytes_to_short(byte[] buffer, int offset) {
        int fByte = 0xFF & buffer[offset];
        int sByte = 0xFF & buffer[offset + 1];
        return (fByte << 8 | sByte) & 0xFFFF;
    }

    private static void debugChunks(byte[] packet) {
        int offset = 12;
        while (packet.length - offset >= 4) {
            int chunkType = packet[offset++] & 0xFF;
            int chunkFlags = packet[offset++] & 0xFF;
            int chunkLength = SctpSocket.bytes_to_short(packet, offset);
            offset += 2;
            logger.debug("CH: " + chunkType + " FL: " + chunkFlags + " L: " + chunkLength);
            if (chunkType == 1) {
                long initTag = SctpSocket.bytes_to_long(packet, offset);
                long a_rwnd = SctpSocket.bytes_to_long(packet, offset += 4);
                int nOutStream = SctpSocket.bytes_to_short(packet, offset += 4);
                int nInStream = SctpSocket.bytes_to_short(packet, offset += 2);
                long initTSN = SctpSocket.bytes_to_long(packet, offset += 2);
                offset += 4;
                logger.debug("ITAG: 0x" + Long.toHexString(initTag) + " a_rwnd: " + a_rwnd + " nOutStream: " + nOutStream + " nInStream: " + nInStream + " initTSN: 0x" + Long.toHexString(initTSN));
                offset += chunkLength - 4 - 16;
                continue;
            }
            if (chunkType == 0) {
                boolean U = (chunkFlags & 4) > 0;
                boolean B = (chunkFlags & 2) > 0;
                boolean E = (chunkFlags & 1) > 0;
                long TSN = SctpSocket.bytes_to_long(packet, offset);
                int streamIdS = SctpSocket.bytes_to_short(packet, offset += 4);
                int streamSeq = SctpSocket.bytes_to_short(packet, offset += 2);
                long PPID = SctpSocket.bytes_to_long(packet, offset += 2);
                offset += 4;
                logger.debug("U: " + U + " B: " + B + " E: " + E + " TSN: 0x" + Long.toHexString(TSN) + " SID: 0x" + Integer.toHexString(streamIdS) + " SSEQ: 0x" + Integer.toHexString(streamSeq) + " PPID: 0x" + Long.toHexString(PPID));
                offset += chunkLength - 4 - 12;
                continue;
            }
            if (chunkType == 6) {
                logger.debug("We have abort!!!");
                if (offset >= chunkLength) {
                    logger.debug("No abort CAUSE!!!");
                }
                while (offset < chunkLength) {
                    int causeCode = SctpSocket.bytes_to_short(packet, offset);
                    int causeLength = SctpSocket.bytes_to_short(packet, offset += 2);
                    offset += 2;
                    logger.debug("Cause: " + causeCode + " L: " + causeLength);
                }
                continue;
            }
            offset += chunkLength - 4;
        }
    }

    public static void debugSctpPacket(byte[] packet, String id) {
        System.out.println(id);
        if (packet.length >= 12) {
            int srcPort = SctpSocket.bytes_to_short(packet, 0);
            int dstPort = SctpSocket.bytes_to_short(packet, 2);
            long verificationTag = SctpSocket.bytes_to_long(packet, 4);
            long checksum = SctpSocket.bytes_to_long(packet, 8);
            logger.debug("SRC P: " + srcPort + " DST P: " + dstPort + " VTAG: 0x" + Long.toHexString(verificationTag) + " CHK: 0x" + Long.toHexString(checksum));
            SctpSocket.debugChunks(packet);
        }
    }

    SctpSocket(long ptr, int localPort) {
        if (ptr == 0L) {
            throw new NullPointerException("ptr");
        }
        this.ptr = ptr;
        this.localPort = localPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean accept() throws IOException {
        boolean r;
        long ptr = this.lockPtr();
        try {
            r = Sctp.usrsctp_accept(ptr);
        }
        finally {
            this.unlockPtr();
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        long ptr;
        this.closed = true;
        SctpSocket sctpSocket = this;
        synchronized (sctpSocket) {
            if (this.ptrLockCount == 0) {
                ptr = this.ptr;
                this.ptr = 0L;
            } else {
                ptr = 0L;
            }
        }
        if (ptr != 0L) {
            Sctp.closeSocket(ptr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(int remotePort) throws IOException {
        long ptr = this.lockPtr();
        try {
            if (!Sctp.usrsctp_connect(ptr, remotePort)) {
                throw new IOException("Failed to connect SCTP");
            }
        }
        finally {
            this.unlockPtr();
        }
    }

    public int getPort() {
        return this.localPort;
    }

    public void listen() throws IOException {
        long ptr = this.lockPtr();
        try {
            Sctp.usrsctp_listen(ptr);
        }
        finally {
            this.unlockPtr();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long lockPtr() throws IOException {
        long ptr;
        SctpSocket sctpSocket = this;
        synchronized (sctpSocket) {
            if (this.closed) {
                throw new IOException("SctpSocket is closed!");
            }
            ptr = this.ptr;
            if (ptr == 0L) {
                throw new IOException("SctpSocket is closed!");
            }
            ++this.ptrLockCount;
        }
        return ptr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnIn(byte[] packet, int offset, int len) throws IOException {
        if (packet == null) {
            throw new NullPointerException("packet");
        }
        if (offset < 0 || len <= 0 || offset + len > packet.length) {
            throw new IllegalArgumentException("o: " + offset + " l: " + len + " packet l: " + packet.length);
        }
        long ptr = this.lockPtr();
        try {
            Sctp.onConnIn(ptr, packet, offset, len);
        }
        finally {
            this.unlockPtr();
        }
    }

    private void onNotification(SctpNotification notification) {
        if (this.notificationListener != null) {
            this.notificationListener.onSctpNotification(this, notification);
        }
    }

    private void onSctpIn(byte[] data, int sid, int ssn, int tsn, long ppid, int context, int flags) {
        if (this.dataCallback != null) {
            this.dataCallback.onSctpPacket(data, sid, ssn, tsn, ppid, context, flags);
        }
    }

    void onSctpInboundPacket(byte[] data, int sid, int ssn, int tsn, long ppid, int context, int flags) {
        if ((flags & 0x2000) != 0) {
            this.onNotification(SctpNotification.parse(data));
        } else {
            this.onSctpIn(data, sid, ssn, tsn, ppid, context, flags);
        }
    }

    int onSctpOut(byte[] packet, int tos, int set_df) {
        NetworkLink link = this.link;
        int ret = -1;
        if (link != null) {
            try {
                link.onConnOut(this, packet);
                ret = 0;
            }
            catch (IOException e) {
                logger.error("Error while sending packet trough the link: " + link, e);
            }
        }
        return ret;
    }

    public int send(byte[] data, boolean ordered, int sid, int ppid) throws IOException {
        return this.send(data, 0, data.length, ordered, sid, ppid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send(byte[] data, int offset, int len, boolean ordered, int sid, int ppid) throws IOException {
        int r;
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (offset < 0 || len <= 0 || offset + len > data.length) {
            throw new IllegalArgumentException("o: " + offset + " l: " + len + " data l: " + data.length);
        }
        long ptr = this.lockPtr();
        try {
            r = Sctp.usrsctp_send(ptr, data, offset, len, ordered, sid, ppid);
        }
        finally {
            this.unlockPtr();
        }
        return r;
    }

    public void setDataCallback(SctpDataCallback callback) {
        this.dataCallback = callback;
    }

    public void setLink(NetworkLink link) {
        this.link = link;
    }

    public void setNotificationListener(NotificationListener l) {
        this.notificationListener = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockPtr() {
        long ptr;
        SctpSocket sctpSocket = this;
        synchronized (sctpSocket) {
            int ptrLockCount = this.ptrLockCount - 1;
            if (ptrLockCount < 0) {
                throw new RuntimeException("Unbalanced SctpSocket#unlockPtr() method invocation!");
            }
            this.ptrLockCount = ptrLockCount;
            if (this.closed && ptrLockCount == 0) {
                ptr = this.ptr;
                this.ptr = 0L;
            } else {
                ptr = 0L;
            }
        }
        if (ptr != 0L) {
            Sctp.closeSocket(ptr);
        }
    }

    public static interface NotificationListener {
        public void onSctpNotification(SctpSocket var1, SctpNotification var2);
    }
}

