/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.multiplexer;

import java.awt.Component;
import java.io.IOException;
import javax.media.Buffer;
import javax.media.Clock;
import javax.media.ClockStoppedException;
import javax.media.Control;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleTimeBaseException;
import javax.media.Multiplexer;
import javax.media.Owned;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.control.StreamWriterControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.Seekable;
import javax.media.protocol.SourceTransferHandler;
import net.sf.fmj.media.BasicClock;
import net.sf.fmj.media.BasicPlugIn;
import net.sf.fmj.media.MediaTimeBase;
import net.sf.fmj.media.Syncable;
import net.sf.fmj.media.control.MonitorAdapter;
import net.sf.fmj.media.datasink.RandomAccess;

public abstract class BasicMux
extends BasicPlugIn
implements Multiplexer,
Clock {
    protected Format[] supportedInputs;
    protected ContentDescriptor[] supportedOutputs;
    protected int numTracks = 0;
    protected Format[] inputs;
    protected BasicMuxDataSource source;
    protected BasicMuxPushStream stream;
    protected ContentDescriptor outputCD;
    protected boolean flushing = false;
    protected Integer sourceLock = new Integer(0);
    protected boolean eos = false;
    protected boolean firstBuffer = true;
    protected int fileSize = 0;
    protected int filePointer = 0;
    protected long fileSizeLimit = -1L;
    protected boolean streamSizeLimitSupported = true;
    protected boolean fileSizeLimitReached = false;
    protected SourceTransferHandler sth = null;
    protected boolean isLiveData = false;
    protected StreamWriterControl swc = null;
    protected MonitorAdapter[] mc = null;
    protected BasicMuxTimeBase timeBase = null;
    Object startup = new Integer(0);
    boolean readyToStart = false;
    long[] mediaTime;
    boolean[] ready;
    protected BasicClock clock = null;
    int master = 0;
    boolean mClosed = false;
    boolean dataReady = false;
    boolean startCompensated = false;
    Object dataLock = new Object();
    Buffer[] firstBuffers;
    boolean[] firstBuffersDone;
    int[] nonKeyCount;
    long masterTime = -1L;
    VideoFormat jpegFmt = new VideoFormat("jpeg");
    VideoFormat mjpgFmt = new VideoFormat("mjpg");
    VideoFormat rgbFmt = new VideoFormat("rgb");
    VideoFormat yuvFmt = new VideoFormat("yuv");
    protected int maxBufSize = 32768;
    protected byte[] buf = new byte[this.maxBufSize];
    protected int bufOffset;
    protected int bufLength;
    Object timeSetSync = new Object();
    boolean started = false;
    long systemStartTime = System.currentTimeMillis() * 1000000L;

    public BasicMux() {
        this.timeBase = new BasicMuxTimeBase();
        this.clock = new BasicClock();
        try {
            this.clock.setTimeBase(this.timeBase);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.swc = new SWC(this);
        this.controls = new Control[]{this.swc};
    }

    protected void bufClear() {
        this.bufOffset = 0;
        this.bufLength = 0;
    }

    protected void bufFlush() {
        this.filePointer -= this.bufLength;
        this.write(this.buf, 0, this.bufLength);
    }

    protected void bufSkip(int size) {
        this.bufOffset += size;
        this.bufLength += size;
        this.filePointer += size;
    }

    protected void bufWriteByte(byte value) {
        this.buf[this.bufOffset] = value;
        ++this.bufOffset;
        ++this.bufLength;
        ++this.filePointer;
    }

    protected void bufWriteBytes(byte[] bytes) {
        System.arraycopy(bytes, 0, this.buf, this.bufOffset, bytes.length);
        this.bufOffset += bytes.length;
        this.bufLength += bytes.length;
        this.filePointer += bytes.length;
    }

    protected void bufWriteBytes(String s) {
        byte[] bytes = s.getBytes();
        this.bufWriteBytes(bytes);
    }

    protected void bufWriteInt(int value) {
        this.buf[this.bufOffset + 0] = (byte)(value >> 24 & 0xFF);
        this.buf[this.bufOffset + 1] = (byte)(value >> 16 & 0xFF);
        this.buf[this.bufOffset + 2] = (byte)(value >> 8 & 0xFF);
        this.buf[this.bufOffset + 3] = (byte)(value >> 0 & 0xFF);
        this.bufOffset += 4;
        this.bufLength += 4;
        this.filePointer += 4;
    }

    protected void bufWriteIntLittleEndian(int value) {
        this.buf[this.bufOffset + 3] = (byte)(value >>> 24 & 0xFF);
        this.buf[this.bufOffset + 2] = (byte)(value >>> 16 & 0xFF);
        this.buf[this.bufOffset + 1] = (byte)(value >>> 8 & 0xFF);
        this.buf[this.bufOffset + 0] = (byte)(value >>> 0 & 0xFF);
        this.bufOffset += 4;
        this.bufLength += 4;
        this.filePointer += 4;
    }

    protected void bufWriteShort(short value) {
        this.buf[this.bufOffset + 0] = (byte)(value >> 8 & 0xFF);
        this.buf[this.bufOffset + 1] = (byte)(value >> 0 & 0xFF);
        this.bufOffset += 2;
        this.bufLength += 2;
        this.filePointer += 2;
    }

    protected void bufWriteShortLittleEndian(short value) {
        this.buf[this.bufOffset + 1] = (byte)(value >> 8 & 0xFF);
        this.buf[this.bufOffset + 0] = (byte)(value >> 0 & 0xFF);
        this.bufOffset += 2;
        this.bufLength += 2;
        this.filePointer += 2;
    }

    private boolean checkReady() {
        if (this.readyToStart) {
            return true;
        }
        for (int i = 0; i < this.ready.length; ++i) {
            if (this.ready[i]) continue;
            return false;
        }
        this.readyToStart = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.sth != null) {
            this.writeFooter();
            this.write(null, 0, -1);
        }
        for (int i = 0; i < this.mc.length; ++i) {
            if (this.mc[i] == null) continue;
            this.mc[i].close();
        }
        Object object = this.dataLock;
        synchronized (object) {
            this.mClosed = true;
            this.dataLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean compensateStart(Buffer buffer, int trackID) {
        Object object = this.dataLock;
        synchronized (object) {
            int i3;
            if (this.dataReady) {
                if (this.firstBuffersDone[trackID]) return true;
                if (buffer.getTimeStamp() < this.masterTime) {
                    return false;
                }
                if (buffer.getFormat() instanceof VideoFormat) {
                    boolean isKey;
                    Format fmt = buffer.getFormat();
                    boolean bl = isKey = this.jpegFmt.matches(fmt) || this.mjpgFmt.matches(fmt) || this.rgbFmt.matches(fmt) || this.yuvFmt.matches(fmt);
                    if (!isKey && (buffer.getFlags() & 0x10) == 0) {
                        int n = trackID;
                        int n2 = this.nonKeyCount[n];
                        this.nonKeyCount[n] = n2 + 1;
                        if (n2 <= 30) return false;
                    }
                    buffer.setTimeStamp(this.masterTime);
                    this.firstBuffersDone[trackID] = true;
                } else {
                    buffer.setTimeStamp(this.masterTime);
                    this.firstBuffersDone[trackID] = true;
                }
                for (int i2 = 0; i2 < this.firstBuffersDone.length; ++i2) {
                    if (this.firstBuffersDone[i2]) continue;
                    return true;
                }
                this.startCompensated = true;
                return true;
            }
            if (buffer.getTimeStamp() < 0L) {
                this.startCompensated = true;
                this.dataReady = true;
                this.dataLock.notifyAll();
                return true;
            }
            this.firstBuffers[trackID] = buffer;
            boolean done = true;
            for (i3 = 0; i3 < this.firstBuffers.length; ++i3) {
                if (this.firstBuffers[i3] != null) continue;
                done = false;
            }
            if (!done) {
                while (!this.dataReady && !this.mClosed) {
                    try {
                        this.dataLock.wait();
                    }
                    catch (Exception i3) {}
                }
                if (this.mClosed) return false;
                if (this.firstBuffers[trackID] != null) return true;
                return false;
            }
            this.masterTime = this.firstBuffers[0].getTimeStamp();
            for (i3 = 0; i3 < this.firstBuffers.length; ++i3) {
                if (this.firstBuffers[i3].getFormat() instanceof AudioFormat) {
                    this.masterTime = this.firstBuffers[i3].getTimeStamp();
                    break;
                }
                if (this.firstBuffers[i3].getTimeStamp() >= this.masterTime) continue;
                this.masterTime = this.firstBuffers[i3].getTimeStamp();
            }
            this.startCompensated = true;
            for (i3 = 0; i3 < this.firstBuffers.length; ++i3) {
                if (this.firstBuffers[i3].getTimeStamp() >= this.masterTime) {
                    this.firstBuffers[i3].setTimeStamp(this.masterTime);
                    this.firstBuffersDone[i3] = true;
                    continue;
                }
                this.firstBuffers[i3] = null;
                this.startCompensated = false;
            }
            Object object2 = this.dataLock;
            synchronized (object2) {
                this.dataReady = true;
                this.dataLock.notifyAll();
            }
            if (this.firstBuffers[trackID] == null) return false;
            return true;
        }
    }

    protected int doProcess(Buffer buffer, int trackID) {
        byte[] data = (byte[])buffer.getData();
        int dataLen = buffer.getLength();
        if (!buffer.isEOM()) {
            this.write(data, buffer.getOffset(), dataLen);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource getDataOutput() {
        if (this.source == null) {
            this.source = new BasicMuxDataSource(this, this.outputCD);
            Integer n = this.sourceLock;
            synchronized (n) {
                this.sourceLock.notifyAll();
            }
        }
        return this.source;
    }

    private long getDuration(Buffer buffer) {
        AudioFormat format = (AudioFormat)buffer.getFormat();
        long duration = format.computeDuration(buffer.getLength());
        if (duration < 0L) {
            return 0L;
        }
        return duration;
    }

    public long getMediaNanoseconds() {
        return this.clock.getMediaNanoseconds();
    }

    public Time getMediaTime() {
        return this.clock.getMediaTime();
    }

    public float getRate() {
        return this.clock.getRate();
    }

    public Time getStopTime() {
        return this.clock.getStopTime();
    }

    long getStreamSize() {
        return this.fileSize;
    }

    public Format[] getSupportedInputFormats() {
        return this.supportedInputs;
    }

    public ContentDescriptor[] getSupportedOutputContentDescriptors(Format[] inputs) {
        return this.supportedOutputs;
    }

    public Time getSyncTime() {
        return this.clock.getSyncTime();
    }

    public TimeBase getTimeBase() {
        return this.clock.getTimeBase();
    }

    boolean isEOS() {
        return this.eos;
    }

    public Time mapToTimeBase(Time t) throws ClockStoppedException {
        return this.clock.mapToTimeBase(t);
    }

    boolean needsSeekable() {
        return false;
    }

    public void open() {
        int i;
        this.firstBuffer = true;
        this.firstBuffers = new Buffer[this.inputs.length];
        this.firstBuffersDone = new boolean[this.inputs.length];
        this.nonKeyCount = new int[this.inputs.length];
        this.mediaTime = new long[this.inputs.length];
        for (i = 0; i < this.inputs.length; ++i) {
            this.firstBuffers[i] = null;
            this.firstBuffersDone[i] = false;
            this.nonKeyCount[i] = 0;
            this.mediaTime[i] = 0L;
        }
        this.ready = new boolean[this.inputs.length];
        this.resetReady();
        int len = 0;
        this.mc = new MonitorAdapter[this.inputs.length];
        for (i = 0; i < this.inputs.length; ++i) {
            if (!(this.inputs[i] instanceof VideoFormat) && !(this.inputs[i] instanceof AudioFormat)) continue;
            this.mc[i] = new MonitorAdapter(this.inputs[i], this);
            if (this.mc[i] == null) continue;
            ++len;
        }
        int j = 0;
        this.controls = new Control[len + 1];
        for (i = 0; i < this.mc.length; ++i) {
            if (this.mc[i] == null) continue;
            this.controls[j++] = this.mc[i];
        }
        this.controls[j] = this.swc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int process(Buffer buffer, int trackID) {
        Object object;
        if (buffer.isDiscard()) {
            return 0;
        }
        if (!this.isLiveData && (buffer.getFlags() & 0x8000) > 0) {
            this.isLiveData = true;
        }
        while (this.source == null || !this.source.isConnected() || !this.source.isStarted()) {
            object = this.sourceLock;
            synchronized (object) {
                try {
                    this.sourceLock.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.flushing) {
                    this.flushing = false;
                    buffer.setLength(0);
                    return 0;
                }
            }
        }
        object = this;
        synchronized (object) {
            if (this.firstBuffer) {
                this.writeHeader();
                this.firstBuffer = false;
            }
        }
        if (this.numTracks > 1) {
            if ((buffer.getFlags() & 0x1000) != 0 && buffer.getTimeStamp() <= 0L) {
                return 0;
            }
            if (!this.startCompensated && !this.compensateStart(buffer, trackID)) {
                return 0;
            }
        }
        this.updateClock(buffer, trackID);
        if (this.mc[trackID] != null && this.mc[trackID].isEnabled()) {
            this.mc[trackID].process(buffer);
        }
        int processResult = this.doProcess(buffer, trackID);
        if (this.fileSizeLimitReached) {
            processResult |= 8;
        }
        return processResult;
    }

    public boolean requireTwoPass() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        for (int i = 0; i < this.mediaTime.length; ++i) {
            this.mediaTime[i] = 0L;
            if (this.mc[i] == null) continue;
            this.mc[i].reset();
        }
        this.timeBase.update();
        this.resetReady();
        Integer n = this.sourceLock;
        synchronized (n) {
            this.flushing = true;
            this.sourceLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetReady() {
        for (int i = 0; i < this.ready.length; ++i) {
            this.ready[i] = false;
        }
        this.readyToStart = false;
        Object object = this.startup;
        synchronized (object) {
            this.startup.notifyAll();
        }
    }

    protected int seek(int location) {
        if (this.source == null || !this.source.isConnected()) {
            return location;
        }
        this.filePointer = this.stream.seek(location);
        return this.filePointer;
    }

    public ContentDescriptor setContentDescriptor(ContentDescriptor outputCD) {
        if (BasicMux.matches(outputCD, this.supportedOutputs) == null) {
            return null;
        }
        this.outputCD = outputCD;
        return outputCD;
    }

    public Format setInputFormat(Format format, int trackID) {
        this.inputs[trackID] = format;
        return format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMediaTime(Time now) {
        Object object = this.timeSetSync;
        synchronized (object) {
            this.clock.setMediaTime(now);
            for (int i = 0; i < this.mediaTime.length; ++i) {
                this.mediaTime[i] = now.getNanoseconds();
            }
            this.timeBase.update();
        }
    }

    public int setNumTracks(int numTracks) {
        this.numTracks = numTracks;
        if (this.inputs == null) {
            this.inputs = new Format[numTracks];
        } else {
            Format[] newInputs = new Format[numTracks];
            for (int i = 0; i < this.inputs.length; ++i) {
                newInputs[i] = this.inputs[i];
            }
            this.inputs = newInputs;
        }
        return numTracks;
    }

    public float setRate(float factor) {
        if (factor == this.clock.getRate()) {
            return factor;
        }
        return this.clock.setRate(1.0f);
    }

    public void setStopTime(Time stopTime) {
        this.clock.setStopTime(stopTime);
    }

    void setStream(BasicMuxPushStream ps) {
        this.stream = ps;
    }

    public void setTimeBase(TimeBase master) throws IncompatibleTimeBaseException {
        if (master != this.timeBase) {
            throw new IncompatibleTimeBaseException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.timeSetSync;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.started = false;
            this.clock.stop();
            this.timeBase.mediaStopped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncStart(Time at) {
        Object object = this.timeSetSync;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.started = true;
            this.clock.syncStart(at);
            this.timeBase.mediaStarted();
            this.systemStartTime = System.currentTimeMillis() * 1000000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateClock(Buffer buffer, int trackID) {
        long timestamp;
        if (!this.readyToStart && this.numTracks > 1) {
            Object object = this.startup;
            synchronized (object) {
                this.ready[trackID] = true;
                if (this.checkReady()) {
                    this.startup.notifyAll();
                } else {
                    try {
                        while (!this.readyToStart) {
                            this.startup.wait(1000L);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if ((timestamp = buffer.getTimeStamp()) <= 0L && buffer.getFormat() instanceof AudioFormat) {
            timestamp = this.mediaTime[trackID];
            int n = trackID;
            this.mediaTime[n] = this.mediaTime[n] + this.getDuration(buffer);
        } else {
            this.mediaTime[trackID] = timestamp <= 0L ? System.currentTimeMillis() * 1000000L - this.systemStartTime : timestamp;
        }
        this.timeBase.update();
    }

    protected int write(byte[] data, int offset, int length) {
        if (this.source == null || !this.source.isConnected()) {
            return length;
        }
        if (length > 0) {
            this.filePointer += length;
            if (this.filePointer > this.fileSize) {
                this.fileSize = this.filePointer;
            }
            if (this.fileSizeLimit > 0L && (long)this.fileSize >= this.fileSizeLimit) {
                this.fileSizeLimitReached = true;
            }
        }
        return this.stream.write(data, offset, length);
    }

    protected void writeFooter() {
    }

    protected void writeHeader() {
    }

    class SWC
    implements StreamWriterControl,
    Owned {
        private BasicMux bmx;

        public SWC(BasicMux bmx) {
            this.bmx = bmx;
        }

        public Component getControlComponent() {
            return null;
        }

        public Object getOwner() {
            return this.bmx;
        }

        public long getStreamSize() {
            return this.bmx.getStreamSize();
        }

        public boolean setStreamSizeLimit(long limit) {
            this.bmx.fileSizeLimit = limit;
            return BasicMux.this.streamSizeLimitSupported;
        }
    }

    class BasicMuxTimeBase
    extends MediaTimeBase {
        long ticks = 0L;
        boolean updated = false;

        BasicMuxTimeBase() {
        }

        public long getMediaTime() {
            if (!this.updated) {
                return this.ticks;
            }
            if (BasicMux.this.mediaTime.length == 1) {
                this.ticks = BasicMux.this.mediaTime[0];
            } else {
                this.ticks = BasicMux.this.mediaTime[0];
                for (int i = 1; i < BasicMux.this.mediaTime.length; ++i) {
                    if (BasicMux.this.mediaTime[i] >= this.ticks) continue;
                    this.ticks = BasicMux.this.mediaTime[i];
                }
            }
            this.updated = false;
            return this.ticks;
        }

        public void update() {
            this.updated = true;
        }
    }

    class BasicMuxPushStream
    implements PushSourceStream {
        private ContentDescriptor cd;
        private byte[] data;
        private int dataLen;
        private int dataOff;
        private Integer writeLock = new Integer(0);

        public BasicMuxPushStream(ContentDescriptor cd) {
            this.cd = cd;
        }

        public boolean endOfStream() {
            return BasicMux.this.isEOS();
        }

        public ContentDescriptor getContentDescriptor() {
            return this.cd;
        }

        public long getContentLength() {
            return -1L;
        }

        public Object getControl(String s) {
            return null;
        }

        public Object[] getControls() {
            return new Control[0];
        }

        public int getMinimumTransferSize() {
            return this.dataLen;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] buffer, int offset, int length) throws IOException {
            int transferred = 0;
            Integer n = this.writeLock;
            synchronized (n) {
                if (this.dataLen == -1) {
                    transferred = -1;
                } else {
                    transferred = length >= this.dataLen ? this.dataLen : length;
                    System.arraycopy(this.data, this.dataOff, buffer, offset, transferred);
                    this.dataLen -= transferred;
                    this.dataOff += transferred;
                }
                this.writeLock.notifyAll();
                return transferred;
            }
        }

        synchronized int seek(int location) {
            if (BasicMux.this.sth != null) {
                ((Seekable)((Object)BasicMux.this.sth)).seek(location);
                int seekVal = (int)((Seekable)((Object)BasicMux.this.sth)).tell();
                return seekVal;
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTransferHandler(SourceTransferHandler sth) {
            Integer n = this.writeLock;
            synchronized (n) {
                BasicMux.this.sth = sth;
                if (sth != null && BasicMux.this.needsSeekable() && !(sth instanceof Seekable)) {
                    throw new Error("SourceTransferHandler needs to be seekable");
                }
                boolean requireTwoPass = BasicMux.this.requireTwoPass();
                if (requireTwoPass && sth != null && sth instanceof RandomAccess) {
                    RandomAccess st = (RandomAccess)((Object)sth);
                    st.setEnabled(true);
                }
                this.writeLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized int write(byte[] data, int offset, int length) {
            if (BasicMux.this.sth == null) {
                return 0;
            }
            if (BasicMux.this.isLiveData && BasicMux.this.sth instanceof Syncable) {
                ((Syncable)((Object)BasicMux.this.sth)).setSyncEnabled();
            }
            Integer n = this.writeLock;
            synchronized (n) {
                this.data = data;
                this.dataOff = offset;
                this.dataLen = length;
                BasicMux.this.sth.transferData(this);
                while (this.dataLen > 0) {
                    if (this.dataLen == length) {
                        try {
                            this.writeLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (BasicMux.this.sth == null) break;
                    if (this.dataLen <= 0 || this.dataLen == length) continue;
                    length = this.dataLen;
                    BasicMux.this.sth.transferData(this);
                }
            }
            return length;
        }
    }

    class BasicMuxDataSource
    extends PushDataSource {
        private BasicMux mux;
        private ContentDescriptor cd;
        private BasicMuxPushStream[] streams;
        private BasicMuxPushStream stream;
        private boolean connected = false;
        private boolean started = false;

        public BasicMuxDataSource(BasicMux mux, ContentDescriptor cd) {
            this.cd = cd;
            this.mux = mux;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connect() throws IOException {
            if (this.streams == null) {
                this.getStreams();
            }
            this.connected = true;
            Integer n = BasicMux.this.sourceLock;
            synchronized (n) {
                BasicMux.this.sourceLock.notifyAll();
            }
        }

        public void disconnect() {
            this.connected = false;
        }

        public String getContentType() {
            return this.cd.getContentType();
        }

        public Object getControl(String s) {
            return null;
        }

        public Object[] getControls() {
            return new Control[0];
        }

        public Time getDuration() {
            return Duration.DURATION_UNKNOWN;
        }

        public PushSourceStream[] getStreams() {
            if (this.streams == null) {
                this.streams = new BasicMuxPushStream[1];
                this.streams[0] = this.stream = new BasicMuxPushStream(this.cd);
                BasicMux.this.setStream(this.stream);
            }
            return this.streams;
        }

        boolean isConnected() {
            return this.connected;
        }

        boolean isStarted() {
            return this.started;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() throws IOException {
            if (this.streams == null || !this.connected) {
                throw new IOException("Source not connected yet!");
            }
            this.started = true;
            Integer n = BasicMux.this.sourceLock;
            synchronized (n) {
                BasicMux.this.sourceLock.notifyAll();
            }
        }

        public void stop() {
            this.started = false;
        }
    }
}

