/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CircularBuffer<T>
extends AbstractList<T>
implements RandomAccess {
    private Object[] buffer;
    private int pointer;
    private int size;

    public CircularBuffer(int capacity) {
        this.buffer = new Object[capacity];
        this.pointer = 0;
        this.size = 0;
    }

    public CircularBuffer() {
        this(1000);
    }

    public CircularBuffer(Collection<? extends T> collection) {
        this(collection.size());
        this.addAll(collection);
    }

    @Override
    public T set(int index, T element) {
        if (index >= this.buffer.length || index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        int trueIndex = this.translateIndex(index);
        Object last = this.buffer[trueIndex];
        this.buffer[trueIndex] = element;
        return (T)last;
    }

    private int translateIndex(int index) {
        int trueIndex = this.pointer - this.size;
        if (trueIndex < 0) {
            trueIndex = this.buffer.length + trueIndex;
        }
        if ((trueIndex += index) >= this.buffer.length) {
            trueIndex -= this.buffer.length;
        }
        return trueIndex;
    }

    @Override
    public void add(int index, T element) {
        int trueIndex = this.translateIndex(this.size);
        this.buffer[trueIndex] = element;
        if (this.size < this.buffer.length) {
            ++this.size;
        }
        ++this.pointer;
        if (this.pointer == this.buffer.length) {
            this.pointer = 0;
        }
        for (int i = this.size - 2; i >= index; --i) {
            this.set(i + 1, this.get(i));
            this.set(i, element);
        }
    }

    @Override
    public T get(int index) {
        return (T)this.buffer[this.translateIndex(index)];
    }

    @Override
    public T remove(int index) {
        int translatedIndex = this.translateIndex(index);
        Object element = this.buffer[translatedIndex];
        this.buffer[translatedIndex] = null;
        for (int i = index + 1; i < this.size; ++i) {
            this.set(i - 1, this.get(i));
        }
        --this.size;
        --this.pointer;
        if (this.pointer == -1) {
            this.pointer = this.buffer.length - 1;
        }
        return (T)element;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.pointer = 0;
        this.size = 0;
        Arrays.fill(this.buffer, null);
    }
}

