/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.g729;

import java.util.Arrays;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.ArrayIOUtils;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.impl.neomedia.codec.audio.g729.Coder;

public class JavaEncoder
extends AbstractCodec2 {
    private static final short BIT_1 = 129;
    private static final int L_FRAME = 80;
    private static final int SERIAL_SIZE = 82;
    private static final int INPUT_FRAME_SIZE_IN_BYTES = 160;
    private static final int OUTPUT_FRAME_SIZE_IN_BYTES = 10;
    private Coder coder;
    private int outFrameCount;
    private byte[] prevIn;
    private int prevInLength;
    private short[] serial;
    private short[] sp16;
    private int duration = 20000000;

    public JavaEncoder() {
        super("G.729 Encoder", AudioFormat.class, new AudioFormat[]{new AudioFormat("g729/rtp", 8000.0, -1, 1)});
        this.inputFormats = new AudioFormat[]{new AudioFormat("LINEAR", 8000.0, 16, 1, 0, 1)};
    }

    @Override
    public Format getOutputFormat() {
        Format f = super.getOutputFormat();
        if (f != null && f.getClass() == AudioFormat.class) {
            AudioFormat af = (AudioFormat)f;
            f = this.setOutputFormat(new AudioFormat(af.getEncoding(), af.getSampleRate(), af.getSampleSizeInBits(), af.getChannels(), af.getEndian(), af.getSigned(), af.getFrameSizeInBits(), af.getFrameRate(), af.getDataType()){
                private static final long serialVersionUID = 0L;

                @Override
                public long computeDuration(long length) {
                    return JavaEncoder.this.duration;
                }
            });
        }
        return f;
    }

    @Override
    protected void discardOutputBuffer(Buffer outputBuffer) {
        super.discardOutputBuffer(outputBuffer);
        this.outFrameCount = 0;
    }

    @Override
    protected void doClose() {
        this.prevIn = null;
        this.prevInLength = 0;
        this.sp16 = null;
        this.serial = null;
        this.coder = null;
    }

    @Override
    protected void doOpen() throws ResourceUnavailableException {
        this.prevIn = new byte[160];
        this.prevInLength = 0;
        this.sp16 = new short[80];
        this.serial = new short[82];
        this.coder = new Coder();
        this.outFrameCount = 0;
    }

    @Override
    protected int doProcess(Buffer inBuffer, Buffer outBuffer) {
        byte[] in = (byte[])inBuffer.getData();
        int inLength = inBuffer.getLength();
        int inOffset = inBuffer.getOffset();
        if (this.prevInLength + inLength < 160) {
            System.arraycopy(in, inOffset, this.prevIn, this.prevInLength, inLength);
            this.prevInLength += inLength;
            return 4;
        }
        int readShorts = 0;
        if (this.prevInLength > 0) {
            readShorts += JavaEncoder.readShorts(this.prevIn, 0, this.sp16, 0, this.prevInLength / 2);
            this.prevInLength = 0;
        }
        readShorts = JavaEncoder.readShorts(in, inOffset, this.sp16, readShorts, this.sp16.length - readShorts);
        int readBytes = 2 * readShorts;
        inBuffer.setLength(inLength -= readBytes);
        inBuffer.setOffset(inOffset += readBytes);
        this.coder.process(this.sp16, this.serial);
        byte[] output = JavaEncoder.validateByteArraySize(outBuffer, outBuffer.getOffset() + 20, true);
        this.packetize(this.serial, output, outBuffer.getOffset() + 10 * this.outFrameCount);
        outBuffer.setLength(outBuffer.getLength() + 10);
        outBuffer.setFormat(this.outputFormat);
        int ret = 0;
        if (this.outFrameCount == 1) {
            this.outFrameCount = 0;
        } else {
            this.outFrameCount = 1;
            ret |= 4;
        }
        if (inLength > 0) {
            ret |= 2;
        }
        if (ret == 0) {
            this.updateOutput(outBuffer, this.getOutputFormat(), outBuffer.getLength(), outBuffer.getOffset());
            outBuffer.setDuration(this.duration);
        }
        return ret;
    }

    private void packetize(short[] serial, byte[] outFrame, int outFrameOffset) {
        Arrays.fill(outFrame, outFrameOffset, outFrameOffset + 10, (byte)0);
        for (int s = 0; s < 80; ++s) {
            if (129 != serial[2 + s]) continue;
            int o = outFrameOffset + s / 8;
            int out = outFrame[o];
            outFrame[o] = (byte)((out |= 1 << 7 - s % 8) & 0xFF);
        }
    }

    private static int readShorts(byte[] in, int inOffset, short[] out, int outOffset, int outLength) {
        int o = outOffset;
        int i = inOffset;
        while (o < outLength) {
            out[o] = ArrayIOUtils.readShort(in, i);
            ++o;
            i += 2;
        }
        return outLength;
    }
}

