/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.neomedia.codec.audio.g722;

import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;

public class JNIDecoder
extends AbstractCodec2 {
    static final Format[] SUPPORTED_INPUT_FORMATS = new Format[]{new AudioFormat("g722/rtp", 8000.0, -1, 1)};
    static final Format[] SUPPORTED_OUTPUT_FORMATS = new Format[]{new AudioFormat("LINEAR", 16000.0, 16, 1, 0, 1, -1, -1.0, Format.byteArray)};
    private long decoder;

    private static native void g722_decoder_close(long var0);

    private static native long g722_decoder_open();

    private static native void g722_decoder_process(long var0, byte[] var2, int var3, byte[] var4, int var5, int var6);

    public JNIDecoder() {
        super("G.722 JNI Decoder", AudioFormat.class, SUPPORTED_OUTPUT_FORMATS);
        this.inputFormats = SUPPORTED_INPUT_FORMATS;
    }

    @Override
    protected void doClose() {
        JNIDecoder.g722_decoder_close(this.decoder);
    }

    @Override
    protected void doOpen() throws ResourceUnavailableException {
        this.decoder = JNIDecoder.g722_decoder_open();
        if (this.decoder == 0L) {
            throw new ResourceUnavailableException("g722_decoder_open");
        }
    }

    @Override
    protected int doProcess(Buffer inputBuffer, Buffer outputBuffer) {
        byte[] input = (byte[])inputBuffer.getData();
        int outputOffset = outputBuffer.getOffset();
        int outputLength = inputBuffer.getLength() * 4;
        byte[] output = JNIDecoder.validateByteArraySize(outputBuffer, outputOffset + outputLength, true);
        JNIDecoder.g722_decoder_process(this.decoder, input, inputBuffer.getOffset(), output, outputOffset, outputLength);
        outputBuffer.setDuration((long)outputLength * 1000000L / 32L);
        outputBuffer.setFormat(this.getOutputFormat());
        outputBuffer.setLength(outputLength);
        return 0;
    }

    static {
        System.loadLibrary("jng722");
    }
}

