/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol.event;

import java.util.EventObject;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.Message;

public class MessageDeliveryFailedEvent
extends EventObject {
    private static final long serialVersionUID = 0L;
    private Contact to = null;
    public static final int UNKNOWN_ERROR = 1;
    public static final int NETWORK_FAILURE = 2;
    public static final int PROVIDER_NOT_REGISTERED = 3;
    public static final int INTERNAL_ERROR = 4;
    public static final int OFFLINE_MESSAGES_NOT_SUPPORTED = 5;
    private int errorCode = 1;
    private String reasonPhrase = null;
    private final long timestamp;
    private String correctedMessageUID;

    public MessageDeliveryFailedEvent(Message source, Contact to, int errorCode) {
        this(source, to, errorCode, System.currentTimeMillis(), null);
    }

    public MessageDeliveryFailedEvent(Message source, Contact to, String correctedMessageUID, int errorCode) {
        this(source, to, errorCode, System.currentTimeMillis(), null);
        this.correctedMessageUID = correctedMessageUID;
    }

    public MessageDeliveryFailedEvent(Message source, Contact to, int errorCode, long timestamp) {
        this(source, to, errorCode, timestamp, null);
    }

    public MessageDeliveryFailedEvent(Message source, Contact to, int errorCode, long timestamp, String reason) {
        super(source);
        this.to = to;
        this.errorCode = errorCode;
        this.timestamp = timestamp;
        this.reasonPhrase = reason;
    }

    public Contact getDestinationContact() {
        return this.to;
    }

    public Message getSourceMessage() {
        return (Message)this.getSource();
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getReason() {
        return this.reasonPhrase;
    }

    public String getCorrectedMessageUID() {
        return this.correctedMessageUID;
    }
}

