/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.client;

import com.hazelcast.cache.impl.CachePortableHook;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.operation.CacheSizeOperationFactory;
import com.hazelcast.client.impl.client.AllPartitionsClientRequest;
import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.OperationFactory;
import java.io.IOException;
import java.security.Permission;
import java.util.Map;

public class CacheSizeRequest
extends AllPartitionsClientRequest
implements RetryableRequest {
    private String name;

    public CacheSizeRequest() {
    }

    public CacheSizeRequest(String name) {
        this.name = name;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    public int getFactoryId() {
        return CachePortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 8;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
    }

    @Override
    protected OperationFactory createOperationFactory() {
        return new CacheSizeOperationFactory(this.name);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        int total = 0;
        CacheService cacheService = (CacheService)this.getService();
        for (Object result : map.values()) {
            Integer size = (Integer)cacheService.toObject(result);
            total += size.intValue();
        }
        return total;
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }
}

