/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.impl.operations.client;

import com.hazelcast.multimap.impl.operations.ContainsEntryOperation;
import com.hazelcast.multimap.impl.operations.client.MultiMapKeyBasedRequest;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class KeyBasedContainsRequest
extends MultiMapKeyBasedRequest {
    private Data value;

    public KeyBasedContainsRequest() {
    }

    public KeyBasedContainsRequest(String name, Data key, Data value) {
        super(name, key);
        this.value = value;
    }

    @Override
    protected Operation prepareOperation() {
        return new ContainsEntryOperation(this.name, this.key, this.value);
    }

    @Override
    public int getClassId() {
        return 26;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        IOUtil.writeNullableData(writer.getRawDataOutput(), this.value);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        ObjectDataInput in = reader.getRawDataInput();
        this.value = IOUtil.readNullableData(in);
    }

    @Override
    public String getMethodName() {
        if (this.value == null) {
            return "containsKey";
        }
        return "containsEntry";
    }

    @Override
    public Object[] getParameters() {
        if (this.value == null) {
            return new Object[]{this.key};
        }
        return new Object[]{this.key, this.value};
    }
}

