/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.web;

import com.voxeo.logging.Loggerf;
import com.voxeo.utils.Objects;
import com.voxeo.utils.Pair;
import com.voxeo.utils.Strings;
import com.voxeo.web.HeaderSettingRequestWrapper;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestHeaderSettingFilter
implements Filter {
    private final Loggerf log = Loggerf.getLogger(RequestHeaderSettingFilter.class);
    private String headerName;
    private Resolver resolver;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            Pair<String, HttpServletRequest> result;
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            try {
                result = this.resolver.resolve(httpRequest);
            }
            catch (IllegalArgumentException e) {
                this.log.debug("Got illegal argument exception from resolver", e);
                httpResponse.sendError(400);
                return;
            }
            String value = (String)result.first;
            if (!Strings.isEmpty(value)) {
                HeaderSettingRequestWrapper wrapper = new HeaderSettingRequestWrapper((HttpServletRequest)result.second);
                wrapper.setHeader(this.headerName, value);
                request = wrapper;
            }
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig config) throws ServletException {
        this.headerName = config.getInitParameter("headerName");
        String resolverClassName = config.getInitParameter("resolverClass");
        try {
            Resolver resolver;
            this.resolver = resolver = (Resolver)Objects.make(resolverClassName, new Object[0]);
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
    }

    public void destroy() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Resolver {
        public Pair<String, HttpServletRequest> resolve(HttpServletRequest var1);
    }
}

