/*
 * Decompiled with CFR 0.152.
 */
package org.xmpp.forms;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import net.jcip.annotations.NotThreadSafe;
import org.dom4j.Element;
import org.dom4j.QName;
import org.jivesoftware.util.FastDateFormat;
import org.xmpp.forms.FormField;
import org.xmpp.packet.PacketExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class DataForm
extends PacketExtension {
    private static final SimpleDateFormat UTC_FORMAT = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
    private static final FastDateFormat FAST_UTC_FORMAT = FastDateFormat.getInstance("yyyyMMdd'T'HH:mm:ss", TimeZone.getTimeZone("UTC"));
    public static final String ELEMENT_NAME = "x";
    public static final String NAMESPACE = "jabber:x:data";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDate(String date) throws ParseException {
        SimpleDateFormat simpleDateFormat = UTC_FORMAT;
        synchronized (simpleDateFormat) {
            return UTC_FORMAT.parse(date);
        }
    }

    public static boolean parseBoolean(String booleanString) throws ParseException {
        return "1".equals(booleanString) || "true".equals(booleanString);
    }

    static String encode(Object object) {
        if (object instanceof String) {
            return object.toString();
        }
        if (object instanceof Boolean) {
            return Boolean.TRUE.equals(object) ? "1" : "0";
        }
        if (object instanceof Date) {
            return FAST_UTC_FORMAT.format((Date)object);
        }
        return object.toString();
    }

    public DataForm(Type type) {
        super(ELEMENT_NAME, NAMESPACE);
        this.element.addAttribute("type", type.toString());
    }

    public DataForm(Element element) {
        super(element);
    }

    public Type getType() {
        String type = this.element.attributeValue("type");
        if (type != null) {
            return Type.valueOf(type);
        }
        return null;
    }

    public void setTitle(String title) {
        if (this.element.element("title") != null) {
            this.element.remove(this.element.element("title"));
        }
        this.element.addElement("title").setText(title);
    }

    public String getTitle() {
        return this.element.elementTextTrim("title");
    }

    public List<String> getInstructions() {
        ArrayList<String> answer = new ArrayList<String>();
        Iterator it = this.element.elementIterator("instructions");
        while (it.hasNext()) {
            answer.add(((Element)it.next()).getTextTrim());
        }
        return Collections.unmodifiableList(answer);
    }

    public void addInstruction(String instruction) {
        if (instruction == null || instruction.trim().length() == 0) {
            return;
        }
        this.element.addElement("instructions").setText(instruction);
    }

    public void clearInstructions() {
        Iterator it = this.element.elementIterator("instructions");
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
    }

    public FormField addField() {
        return new FormField(this.element.addElement("field"));
    }

    public FormField addField(String variable, String label, FormField.Type type) {
        FormField result = this.addField();
        if (variable != null && variable.trim().length() >= 0) {
            result.setVariable(variable);
        }
        if (type != null) {
            result.setType(type);
        }
        if (label != null && label.trim().length() >= 0) {
            result.setLabel(label);
        }
        return result;
    }

    public List<FormField> getFields() {
        ArrayList<FormField> answer = new ArrayList<FormField>();
        Iterator it = this.element.elementIterator("field");
        while (it.hasNext()) {
            answer.add(new FormField((Element)it.next()));
        }
        return answer;
    }

    public FormField getField(String variable) {
        Iterator it = this.element.elementIterator("field");
        while (it.hasNext()) {
            FormField formField = new FormField((Element)it.next());
            if (!variable.equals(formField.getVariable())) continue;
            return formField;
        }
        return null;
    }

    public boolean removeField(String variable) {
        Iterator it = this.element.elementIterator("field");
        while (it.hasNext()) {
            Element field = (Element)it.next();
            String fieldVariable = field.attributeValue("var");
            if (!variable.equals(fieldVariable)) continue;
            return this.element.remove(field);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReportedField(String variable, String label, FormField.Type type) {
        Element reported = this.element.element("reported");
        Element element = this.element;
        synchronized (element) {
            if (reported == null && (reported = this.element.element("reported")) == null) {
                reported = this.element.addElement("reported");
            }
        }
        FormField newField = new FormField(reported.addElement("field"));
        newField.setVariable(variable);
        newField.setType(type);
        newField.setLabel(label);
    }

    public void addItemFields(Map<String, Object> fields) {
        Element item = this.element.addElement("item");
        for (Map.Entry<String, Object> entry : fields.entrySet()) {
            Element field = item.addElement("field");
            field.addAttribute("var", entry.getKey());
            Object value = entry.getValue();
            if (value == null) continue;
            if (value instanceof Collection) {
                for (Object colValue : (Collection)value) {
                    if (colValue == null) continue;
                    field.addElement("value").setText(DataForm.encode(colValue));
                }
                continue;
            }
            field.addElement("value").setText(DataForm.encode(value));
        }
    }

    @Override
    public DataForm createCopy() {
        return new DataForm(this.getElement().createCopy());
    }

    static {
        UTC_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        registeredExtensions.put(QName.get(ELEMENT_NAME, NAMESPACE), DataForm.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        form,
        submit,
        cancel,
        result;

    }
}

