/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.core.ManagedContext;
import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.operation.AbstractMultipleEntryOperation;
import com.hazelcast.map.operation.MultipleEntryBackupOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MultipleEntryOperation
extends AbstractMultipleEntryOperation
implements BackupAwareOperation {
    private Set<Data> keys;

    public MultipleEntryOperation() {
    }

    public MultipleEntryOperation(String name, Set<Data> keys, EntryProcessor entryProcessor) {
        super(name, entryProcessor);
        this.keys = keys;
    }

    @Override
    public void innerBeforeRun() {
        super.innerBeforeRun();
        SerializationService serializationService = this.getNodeEngine().getSerializationService();
        ManagedContext managedContext = serializationService.getManagedContext();
        managedContext.initialize(this.entryProcessor);
    }

    @Override
    public void run() throws Exception {
        Set<Data> keys = this.keys;
        for (Data dataKey : keys) {
            if (this.keyNotOwnedByThisPartition(dataKey)) continue;
            long now = this.getNow();
            Object oldValue = this.getValueFor(dataKey);
            Object key = this.toObject(dataKey);
            Object value = this.toObject(oldValue);
            Map.Entry entry = this.createMapEntry(key, value);
            Data response = this.process(entry);
            this.addToResponses(dataKey, response);
            if (this.noOp(entry, oldValue) || this.entryRemoved(entry, dataKey, oldValue, now)) continue;
            this.entryAddedOrUpdated(entry, dataKey, oldValue, now);
        }
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    public Object getResponse() {
        return this.responses;
    }

    public String toString() {
        return "MultipleEntryOperation{}";
    }

    @Override
    public boolean shouldBackup() {
        return this.entryProcessor.getBackupProcessor() != null;
    }

    @Override
    public int getSyncBackupCount() {
        return 0;
    }

    @Override
    public int getAsyncBackupCount() {
        return this.mapContainer.getTotalBackupCount();
    }

    @Override
    public Operation getBackupOperation() {
        EntryBackupProcessor backupProcessor = this.entryProcessor.getBackupProcessor();
        return backupProcessor != null ? new MultipleEntryBackupOperation(this.name, this.keys, backupProcessor) : null;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.entryProcessor = (EntryProcessor)in.readObject();
        int size = in.readInt();
        this.keys = new HashSet<Data>(size);
        for (int i = 0; i < size; ++i) {
            Data key = new Data();
            key.readData(in);
            this.keys.add(key);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.entryProcessor);
        out.writeInt(this.keys.size());
        for (Data key : this.keys) {
            key.writeData(out);
        }
    }
}

