/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.PartitioningStrategyConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.core.MapLoader;
import com.hazelcast.core.MapLoaderLifecycleSupport;
import com.hazelcast.core.MapStoreFactory;
import com.hazelcast.core.PartitioningStrategy;
import com.hazelcast.map.MapContainerSupport;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.MapServiceContext;
import com.hazelcast.map.MapStoreWrapper;
import com.hazelcast.map.SizeEstimator;
import com.hazelcast.map.SizeEstimators;
import com.hazelcast.map.mapstore.MapStoreManager;
import com.hazelcast.map.mapstore.MapStoreManagers;
import com.hazelcast.map.merge.MapMergePolicy;
import com.hazelcast.map.record.DataRecordFactory;
import com.hazelcast.map.record.ObjectRecordFactory;
import com.hazelcast.map.record.OffHeapRecordFactory;
import com.hazelcast.map.record.Record;
import com.hazelcast.map.record.RecordFactory;
import com.hazelcast.map.record.RecordStatistics;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.impl.IndexService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.UuidUtil;
import com.hazelcast.wan.WanReplicationPublisher;
import com.hazelcast.wan.WanReplicationService;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;

public class MapContainer
extends MapContainerSupport {
    private static final int INITIAL_KEYS_REMOVE_DELAY_MINUTES = 20;
    private final String name;
    private final RecordFactory recordFactory;
    private final MapServiceContext mapServiceContext;
    private final List<MapInterceptor> interceptors;
    private final Map<String, MapInterceptor> interceptorMap;
    private final IndexService indexService = new IndexService();
    private final boolean nearCacheEnabled;
    private final SizeEstimator nearCacheSizeEstimator;
    private final PartitioningStrategy partitioningStrategy;
    private WanReplicationPublisher wanReplicationPublisher;
    private MapMergePolicy wanMergePolicy;
    private final Map<Data, Object> initialKeys = new ConcurrentHashMap<Data, Object>();
    private MapStoreWrapper storeWrapper;
    private MapStoreManager mapStoreManager;

    public MapContainer(String name, MapConfig mapConfig, MapServiceContext mapServiceContext) {
        super(mapConfig);
        this.name = name;
        this.mapServiceContext = mapServiceContext;
        this.partitioningStrategy = this.createPartitioningStrategy();
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        this.recordFactory = this.createRecordFactory(nodeEngine);
        this.initMapStoreOperations(nodeEngine);
        this.initWanReplication(nodeEngine);
        this.interceptors = new CopyOnWriteArrayList<MapInterceptor>();
        this.interceptorMap = new ConcurrentHashMap<String, MapInterceptor>();
        this.nearCacheEnabled = mapConfig.getNearCacheConfig() != null;
        this.nearCacheSizeEstimator = SizeEstimators.createNearCacheSizeEstimator();
        this.mapStoreManager = this.createMapStoreManager(this);
        this.mapStoreManager.start();
    }

    public MapStoreManager createMapStoreManager(MapContainer mapContainer) {
        if (!this.isMapStoreEnabled()) {
            return MapStoreManagers.emptyMapStoreManager();
        }
        if (this.isWriteBehindMapStoreEnabled()) {
            return MapStoreManagers.createWriteBehindManager(mapContainer);
        }
        return MapStoreManagers.createWriteThroughManager(mapContainer);
    }

    public MapStoreManager getMapStoreManager() {
        return this.mapStoreManager;
    }

    private void initMapStoreOperations(NodeEngine nodeEngine) {
        if (!this.isMapStoreEnabled()) {
            return;
        }
        this.storeWrapper = this.createMapStoreWrapper(this.mapConfig.getMapStoreConfig(), nodeEngine);
        if (this.storeWrapper != null) {
            this.initMapStore(this.storeWrapper.getImpl(), this.mapConfig.getMapStoreConfig(), nodeEngine);
        }
    }

    private RecordFactory createRecordFactory(NodeEngine nodeEngine) {
        RecordFactory<Object> recordFactory;
        switch (this.mapConfig.getInMemoryFormat()) {
            case BINARY: {
                recordFactory = new DataRecordFactory(this.mapConfig, nodeEngine.getSerializationService(), this.partitioningStrategy);
                break;
            }
            case OBJECT: {
                recordFactory = new ObjectRecordFactory(this.mapConfig, nodeEngine.getSerializationService());
                break;
            }
            case OFFHEAP: {
                recordFactory = new OffHeapRecordFactory(this.mapConfig, nodeEngine.getOffHeapStorage(), nodeEngine.getSerializationService(), this.partitioningStrategy);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid storage format: " + (Object)((Object)this.mapConfig.getInMemoryFormat()));
            }
        }
        return recordFactory;
    }

    private MapStoreWrapper createMapStoreWrapper(MapStoreConfig mapStoreConfig, NodeEngine nodeEngine) {
        MapLoader store;
        try {
            String factoryClassName;
            MapStoreFactory factory = (MapStoreFactory)mapStoreConfig.getFactoryImplementation();
            if (factory == null && (factoryClassName = mapStoreConfig.getFactoryClassName()) != null && !"".equals(factoryClassName)) {
                factory = (MapStoreFactory)ClassLoaderUtil.newInstance(nodeEngine.getConfigClassLoader(), factoryClassName);
            }
            MapLoader mapLoader = store = factory == null ? mapStoreConfig.getImplementation() : factory.newMapStore(this.name, mapStoreConfig.getProperties());
            if (store == null) {
                String mapStoreClassName = mapStoreConfig.getClassName();
                store = ClassLoaderUtil.newInstance(nodeEngine.getConfigClassLoader(), mapStoreClassName);
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        nodeEngine.getConfig().getMapConfig(this.name).getMapStoreConfig().setImplementation(store);
        MapStoreWrapper storeWrapper = new MapStoreWrapper(store, this.name, mapStoreConfig.isEnabled());
        return storeWrapper;
    }

    private void initMapStore(Object store, MapStoreConfig mapStoreConfig, NodeEngine nodeEngine) {
        if (store instanceof MapLoaderLifecycleSupport) {
            ((MapLoaderLifecycleSupport)store).init(nodeEngine.getHazelcastInstance(), mapStoreConfig.getProperties(), this.name);
        }
        this.loadInitialKeys();
    }

    public void initWanReplication(NodeEngine nodeEngine) {
        WanReplicationRef wanReplicationRef = this.mapConfig.getWanReplicationRef();
        if (wanReplicationRef == null) {
            return;
        }
        String wanReplicationRefName = wanReplicationRef.getName();
        WanReplicationService wanReplicationService = nodeEngine.getWanReplicationService();
        this.wanReplicationPublisher = wanReplicationService.getWanReplicationPublisher(wanReplicationRefName);
        this.wanMergePolicy = this.mapServiceContext.getMergePolicyProvider().getMergePolicy(wanReplicationRef.getMergePolicy());
    }

    private PartitioningStrategy createPartitioningStrategy() {
        PartitioningStrategy strategy = null;
        PartitioningStrategyConfig partitioningStrategyConfig = this.mapConfig.getPartitioningStrategyConfig();
        if (partitioningStrategyConfig != null && (strategy = partitioningStrategyConfig.getPartitioningStrategy()) == null && partitioningStrategyConfig.getPartitioningStrategyClass() != null) {
            try {
                strategy = (PartitioningStrategy)ClassLoaderUtil.newInstance(this.mapServiceContext.getNodeEngine().getConfigClassLoader(), partitioningStrategyConfig.getPartitioningStrategyClass());
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
        return strategy;
    }

    private void loadInitialKeys() {
        this.initialKeys.clear();
        Set keys = this.storeWrapper.loadAllKeys();
        if (keys == null || keys.isEmpty()) {
            return;
        }
        for (Object key : keys) {
            Data dataKey = this.mapServiceContext.toData(key, this.partitioningStrategy);
            this.initialKeys.put(dataKey, key);
        }
        this.mapServiceContext.getNodeEngine().getExecutionService().schedule(new Runnable(){

            @Override
            public void run() {
                MapContainer.this.initialKeys.clear();
            }
        }, 20L, TimeUnit.MINUTES);
    }

    public Map<Data, Object> getInitialKeys() {
        return this.initialKeys;
    }

    public IndexService getIndexService() {
        return this.indexService;
    }

    public WanReplicationPublisher getWanReplicationPublisher() {
        return this.wanReplicationPublisher;
    }

    public MapMergePolicy getWanMergePolicy() {
        return this.wanMergePolicy;
    }

    public String addInterceptor(MapInterceptor interceptor) {
        String id = UuidUtil.buildRandomUuidString();
        this.interceptorMap.put(id, interceptor);
        this.interceptors.add(interceptor);
        return id;
    }

    public void addInterceptor(String id, MapInterceptor interceptor) {
        this.interceptorMap.put(id, interceptor);
        this.interceptors.add(interceptor);
    }

    public List<MapInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public Map<String, MapInterceptor> getInterceptorMap() {
        return this.interceptorMap;
    }

    public void removeInterceptor(String id) {
        MapInterceptor interceptor = this.interceptorMap.remove(id);
        this.interceptors.remove(interceptor);
    }

    public Record createRecord(Data key, Object value, long ttl, long now) {
        Record record = this.getRecordFactory().newRecord(key, value);
        record.setLastAccessTime(now);
        record.setLastUpdateTime(now);
        record.setCreationTime(now);
        long configTTLSeconds = this.mapConfig.getTimeToLiveSeconds();
        long configTTLMillis = this.mapServiceContext.convertTime(configTTLSeconds, TimeUnit.SECONDS);
        if (ttl < 0L && configTTLMillis > 0L) {
            record.setTtl(configTTLMillis);
        } else if (ttl > 0L) {
            record.setTtl(ttl);
        }
        RecordStatistics statistics = record.getStatistics();
        if (statistics != null) {
            long ttlOnRecord = record.getTtl();
            long expirationTime = this.mapServiceContext.getExpirationTime(ttlOnRecord, now);
            statistics.setExpirationTime(expirationTime);
        }
        return record;
    }

    public String getName() {
        return this.name;
    }

    public boolean isNearCacheEnabled() {
        return this.nearCacheEnabled;
    }

    public int getTotalBackupCount() {
        return this.getBackupCount() + this.getAsyncBackupCount();
    }

    public int getBackupCount() {
        return this.mapConfig.getBackupCount();
    }

    public int getAsyncBackupCount() {
        return this.mapConfig.getAsyncBackupCount();
    }

    public MapStoreWrapper getStore() {
        return this.storeWrapper != null && this.storeWrapper.isEnabled() ? this.storeWrapper : null;
    }

    public PartitioningStrategy getPartitioningStrategy() {
        return this.partitioningStrategy;
    }

    public SizeEstimator getNearCacheSizeEstimator() {
        return this.nearCacheSizeEstimator;
    }

    public RecordFactory getRecordFactory() {
        return this.recordFactory;
    }

    public MapServiceContext getMapServiceContext() {
        return this.mapServiceContext;
    }
}

