/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.management.operation;

import com.hazelcast.management.ScriptEngineManagerContext;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class ScriptExecutorOperation
extends Operation {
    private String engineName;
    private String script;
    private Map<String, Object> bindings;
    private Object result;

    public ScriptExecutorOperation() {
    }

    public ScriptExecutorOperation(String engineName, String script, Map<String, Object> bindings) {
        this.engineName = engineName;
        this.script = script;
        this.bindings = bindings;
    }

    @Override
    public void beforeRun() throws Exception {
    }

    @Override
    public void run() throws Exception {
        ScriptEngineManager scriptEngineManager = ScriptEngineManagerContext.getScriptEngineManager();
        ScriptEngine engine = scriptEngineManager.getEngineByName(this.engineName);
        if (engine == null) {
            throw new IllegalArgumentException("Could not find ScriptEngine named '" + this.engineName + "'.");
        }
        engine.put("hazelcast", this.getNodeEngine().getHazelcastInstance());
        if (this.bindings != null) {
            Set<Map.Entry<String, Object>> entries = this.bindings.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                engine.put(entry.getKey(), entry.getValue());
            }
        }
        try {
            this.result = engine.eval(this.script);
        }
        catch (ScriptException e) {
            this.result = e.getMessage();
        }
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    public Object getResponse() {
        return this.result;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.engineName);
        out.writeUTF(this.script);
        if (this.bindings != null) {
            out.writeInt(this.bindings.size());
            Set<Map.Entry<String, Object>> entries = this.bindings.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                out.writeUTF(entry.getKey());
                out.writeObject(entry.getValue());
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.engineName = in.readUTF();
        this.script = in.readUTF();
        int size = in.readInt();
        if (size > 0) {
            this.bindings = new HashMap<String, Object>(size);
            for (int i = 0; i < size; ++i) {
                String key = in.readUTF();
                Object value = in.readObject();
                this.bindings.put(key, value);
            }
        }
    }
}

