/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyOnWriteArrayList<E>
implements List<E>,
Cloneable,
Serializable {
    protected transient E[] array_;

    protected synchronized E[] array() {
        return this.array_;
    }

    public CopyOnWriteArrayList() {
        this.array_ = new Object[0];
    }

    public CopyOnWriteArrayList(Collection<? extends E> collection) {
        this.array_ = new Object[collection.size()];
        Iterator<E> iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            this.array_[n++] = iterator.next();
        }
    }

    public CopyOnWriteArrayList(E[] EArray) {
        this.copyIn(EArray, 0, EArray.length);
    }

    public synchronized void copyIn(E[] EArray, int n, int n2) {
        this.array_ = new Object[n2];
        System.arraycopy(EArray, n, this.array_, 0, n2);
    }

    @Override
    public int size() {
        return this.array().length;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object object) {
        int n;
        Object[] objectArray = this.array();
        return CopyOnWriteArrayList.indexOf(object, objectArray, n = objectArray.length) >= 0;
    }

    @Override
    public int indexOf(Object object) {
        Object[] objectArray = this.array();
        int n = objectArray.length;
        return CopyOnWriteArrayList.indexOf(object, objectArray, n);
    }

    protected static int indexOf(Object object, Object[] objectArray, int n) {
        if (object == null) {
            for (int i = 0; i < n; ++i) {
                if (objectArray[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (!object.equals(objectArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(Object object, int n) {
        E[] EArray = this.array();
        int n2 = EArray.length;
        if (object == null) {
            for (int i = n; i < n2; ++i) {
                if (EArray[i] != null) continue;
                return i;
            }
        } else {
            for (int i = n; i < n2; ++i) {
                if (!object.equals(EArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        Object[] objectArray = this.array();
        int n = objectArray.length;
        return CopyOnWriteArrayList.lastIndexOf(object, objectArray, n);
    }

    protected static int lastIndexOf(Object object, Object[] objectArray, int n) {
        if (object == null) {
            for (int i = n - 1; i >= 0; --i) {
                if (objectArray[i] != null) continue;
                return i;
            }
        } else {
            for (int i = n - 1; i >= 0; --i) {
                if (!object.equals(objectArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object object, int n) {
        E[] EArray = this.array();
        if (object == null) {
            for (int i = n; i >= 0; --i) {
                if (EArray[i] != null) continue;
                return i;
            }
        } else {
            for (int i = n; i >= 0; --i) {
                if (!object.equals(EArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            E[] EArray = this.array();
            CopyOnWriteArrayList copyOnWriteArrayList = (CopyOnWriteArrayList)super.clone();
            copyOnWriteArrayList.array_ = new Object[EArray.length];
            System.arraycopy(EArray, 0, copyOnWriteArrayList.array_, 0, EArray.length);
            return copyOnWriteArrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public Object[] toArray() {
        E[] EArray = this.array();
        Object[] objectArray = new Object[EArray.length];
        System.arraycopy(EArray, 0, objectArray, 0, EArray.length);
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        E[] EArray = this.array();
        if (objectArray.length < EArray.length) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), EArray.length);
        }
        System.arraycopy(EArray, 0, objectArray, 0, EArray.length);
        if (objectArray.length > EArray.length) {
            objectArray[EArray.length] = null;
        }
        return objectArray;
    }

    @Override
    public E get(int n) {
        E[] EArray = this.array();
        this.rangeCheck(n, EArray.length);
        return EArray[n];
    }

    @Override
    public synchronized E set(int n, E e) {
        boolean bl;
        int n2 = this.array_.length;
        this.rangeCheck(n, n2);
        E e2 = this.array_[n];
        boolean bl2 = bl = e2 == e || e != null && e.equals(e2);
        if (!bl) {
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.array_, 0, objectArray, 0, n2);
            objectArray[n] = e;
            this.array_ = objectArray;
        }
        return e2;
    }

    @Override
    public synchronized boolean add(E e) {
        int n = this.array_.length;
        Object[] objectArray = new Object[n + 1];
        System.arraycopy(this.array_, 0, objectArray, 0, n);
        objectArray[n] = e;
        this.array_ = objectArray;
        return true;
    }

    @Override
    public synchronized void add(int n, E e) {
        int n2 = this.array_.length;
        if (n > n2 || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + n2);
        }
        Object[] objectArray = new Object[n2 + 1];
        System.arraycopy(this.array_, 0, objectArray, 0, n);
        objectArray[n] = e;
        System.arraycopy(this.array_, n, objectArray, n + 1, n2 - n);
        this.array_ = objectArray;
    }

    @Override
    public synchronized E remove(int n) {
        int n2 = this.array_.length;
        this.rangeCheck(n, n2);
        E e = this.array_[n];
        Object[] objectArray = new Object[n2 - 1];
        System.arraycopy(this.array_, 0, objectArray, 0, n);
        int n3 = n2 - n - 1;
        if (n3 > 0) {
            System.arraycopy(this.array_, n + 1, objectArray, n, n3);
        }
        this.array_ = objectArray;
        return e;
    }

    @Override
    public synchronized boolean remove(Object object) {
        int n = this.array_.length;
        if (n == 0) {
            return false;
        }
        int n2 = n - 1;
        Object[] objectArray = new Object[n2];
        for (int i = 0; i < n2; ++i) {
            if (object == this.array_[i] || object != null && object.equals(this.array_[i])) {
                for (int j = i + 1; j < n; ++j) {
                    objectArray[j - 1] = this.array_[j];
                }
                this.array_ = objectArray;
                return true;
            }
            objectArray[i] = this.array_[i];
        }
        if (object == this.array_[n2] || object != null && object.equals(this.array_[n2])) {
            this.array_ = objectArray;
            return true;
        }
        return false;
    }

    public synchronized void removeRange(int n, int n2) {
        int n3 = this.array_.length;
        if (n < 0 || n >= n3 || n2 > n3 || n2 < n) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = n3 - n2;
        int n5 = n3 - (n2 - n);
        Object[] objectArray = new Object[n5];
        System.arraycopy(this.array_, 0, objectArray, 0, n);
        System.arraycopy(this.array_, n2, objectArray, n, n4);
        this.array_ = objectArray;
    }

    public synchronized boolean addIfAbsent(E e) {
        int n = this.array_.length;
        Object[] objectArray = new Object[n + 1];
        for (int i = 0; i < n; ++i) {
            if (e == this.array_[i] || e != null && e.equals(this.array_[i])) {
                return false;
            }
            objectArray[i] = this.array_[i];
        }
        objectArray[n] = e;
        this.array_ = objectArray;
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        Object[] objectArray = this.array();
        int n = objectArray.length;
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (CopyOnWriteArrayList.indexOf(iterator.next(), objectArray, n) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> collection) {
        E[] EArray = this.array_;
        int n = EArray.length;
        if (n == 0) {
            return false;
        }
        Object[] objectArray = new Object[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            E e = EArray[i];
            if (collection.contains(e)) continue;
            objectArray[n2++] = e;
        }
        if (n2 == n) {
            return false;
        }
        Object[] objectArray2 = new Object[n2];
        System.arraycopy(objectArray, 0, objectArray2, 0, n2);
        this.array_ = objectArray2;
        return true;
    }

    @Override
    public synchronized boolean retainAll(Collection<?> collection) {
        E[] EArray = this.array_;
        int n = EArray.length;
        if (n == 0) {
            return false;
        }
        Object[] objectArray = new Object[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            E e = EArray[i];
            if (!collection.contains(e)) continue;
            objectArray[n2++] = e;
        }
        if (n2 == n) {
            return false;
        }
        Object[] objectArray2 = new Object[n2];
        System.arraycopy(objectArray, 0, objectArray2, 0, n2);
        this.array_ = objectArray2;
        return true;
    }

    public synchronized int addAllAbsent(Collection collection) {
        Object object2;
        int n = collection.size();
        if (n == 0) {
            return 0;
        }
        Object[] objectArray = this.array_;
        int n2 = objectArray.length;
        Object[] objectArray2 = new Object[n];
        int n3 = 0;
        for (Object object2 : collection) {
            if (CopyOnWriteArrayList.indexOf(object2, objectArray, n2) >= 0 || CopyOnWriteArrayList.indexOf(object2, objectArray2, n3) >= 0) continue;
            objectArray2[n3++] = object2;
        }
        if (n3 == 0) {
            return 0;
        }
        object2 = new Object[n2 + n3];
        System.arraycopy(objectArray, 0, object2, 0, n2);
        System.arraycopy(objectArray2, 0, object2, n2, n3);
        this.array_ = object2;
        return n3;
    }

    @Override
    public synchronized void clear() {
        this.array_ = new Object[0];
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> collection) {
        int n = collection.size();
        if (n == 0) {
            return false;
        }
        int n2 = this.array_.length;
        Object[] objectArray = new Object[n2 + n];
        System.arraycopy(this.array_, 0, objectArray, 0, n2);
        Iterator<E> iterator = collection.iterator();
        for (int i = 0; i < n; ++i) {
            objectArray[n2++] = iterator.next();
        }
        this.array_ = objectArray;
        return true;
    }

    @Override
    public synchronized boolean addAll(int n, Collection<? extends E> collection) {
        int n2 = this.array_.length;
        if (n > n2 || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + n2);
        }
        int n3 = collection.size();
        if (n3 == 0) {
            return false;
        }
        Object[] objectArray = new Object[n2 + n3];
        System.arraycopy(this.array_, 0, objectArray, 0, n2);
        int n4 = n2 - n;
        if (n4 > 0) {
            System.arraycopy(this.array_, n, objectArray, n + n3, n4);
        }
        Iterator<E> iterator = collection.iterator();
        for (int i = 0; i < n3; ++i) {
            objectArray[n++] = iterator.next();
        }
        this.array_ = objectArray;
        return true;
    }

    protected void rangeCheck(int n, int n2) {
        if (n >= n2 || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + n2);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        E[] EArray = this.array();
        objectOutputStream.writeInt(EArray.length);
        for (int i = 0; i < EArray.length; ++i) {
            objectOutputStream.writeObject(EArray[i]);
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = objectInputStream.readObject();
        }
        this.array_ = objectArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<E> iterator = this.iterator();
        stringBuffer.append("[");
        int n = this.size() - 1;
        for (int i = 0; i <= n; ++i) {
            stringBuffer.append(String.valueOf(iterator.next()));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (this.size() != list.size()) {
            return false;
        }
        ListIterator<E> listIterator = this.listIterator();
        ListIterator listIterator2 = list.listIterator();
        while (listIterator.hasNext()) {
            E e = listIterator.next();
            Object e2 = listIterator2.next();
            if (e != null ? e.equals(e2) : e2 == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = 1;
        for (E e : this) {
            n = 31 * n + (e == null ? 0 : e.hashCode());
        }
        return n;
    }

    @Override
    public Iterator<E> iterator() {
        return new COWIterator(this.array(), 0);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new COWIterator(this.array(), 0);
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        E[] EArray = this.array();
        int n2 = EArray.length;
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException("Index: " + n);
        }
        return new COWIterator(this.array(), n);
    }

    @Override
    public synchronized List<E> subList(int n, int n2) {
        int n3 = this.array_.length;
        if (n < 0 || n2 > n3 || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        return new COWSubList(this, n, n2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class COWSubList<E>
    extends AbstractList<E> {
        protected final CopyOnWriteArrayList<E> l;
        protected final int offset;
        protected int size;
        protected E[] expectedArray;

        protected COWSubList(CopyOnWriteArrayList<E> copyOnWriteArrayList, int n, int n2) {
            this.l = copyOnWriteArrayList;
            this.expectedArray = this.l.array();
            this.offset = n;
            this.size = n2 - n;
        }

        protected void checkForComodification() {
            if (this.l.array_ != this.expectedArray) {
                throw new ConcurrentModificationException();
            }
        }

        protected void rangeCheck(int n) {
            if (n < 0 || n >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + n + ",Size: " + this.size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E set(int n, E e) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(n);
                this.checkForComodification();
                E e2 = this.l.set(n + this.offset, e);
                this.expectedArray = this.l.array_;
                return e2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E get(int n) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(n);
                this.checkForComodification();
                return this.l.get(n + this.offset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                return this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int n, E e) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (n < 0 || n > this.size) {
                    throw new IndexOutOfBoundsException();
                }
                this.l.add(n + this.offset, e);
                this.expectedArray = this.l.array_;
                ++this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E remove(int n) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(n);
                this.checkForComodification();
                E e = this.l.remove(n + this.offset);
                this.expectedArray = this.l.array_;
                --this.size;
                return e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<E> iterator() {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                return new COWSubListIterator(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListIterator<E> listIterator(int n) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (n < 0 || n > this.size) {
                    throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
                }
                return new COWSubListIterator(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<E> subList(int n, int n2) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (n < 0 || n2 > this.size) {
                    throw new IndexOutOfBoundsException();
                }
                return new COWSubList<E>(this.l, n + this.offset, n2 + this.offset);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class COWSubListIterator
        implements ListIterator<E> {
            protected final ListIterator<E> i;
            protected final int index;

            protected COWSubListIterator(int n) {
                this.index = n;
                this.i = COWSubList.this.l.listIterator(n + COWSubList.this.offset);
            }

            @Override
            public boolean hasNext() {
                return this.nextIndex() < COWSubList.this.size;
            }

            @Override
            public E next() {
                if (this.hasNext()) {
                    return this.i.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasPrevious() {
                return this.previousIndex() >= 0;
            }

            @Override
            public E previous() {
                if (this.hasPrevious()) {
                    return this.i.previous();
                }
                throw new NoSuchElementException();
            }

            @Override
            public int nextIndex() {
                return this.i.nextIndex() - COWSubList.this.offset;
            }

            @Override
            public int previousIndex() {
                return this.i.previousIndex() - COWSubList.this.offset;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(E e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(E e) {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected static class COWIterator
    implements ListIterator {
        protected final Object[] array;
        protected int cursor;

        protected COWIterator(Object[] objectArray, int n) {
            this.array = objectArray;
            this.cursor = n;
        }

        public boolean hasNext() {
            return this.cursor < this.array.length;
        }

        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        public Object next() {
            try {
                return this.array[this.cursor++];
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        public Object previous() {
            try {
                return this.array[--this.cursor];
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        public int nextIndex() {
            return this.cursor;
        }

        public int previousIndex() {
            return this.cursor - 1;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object object) {
            throw new UnsupportedOperationException();
        }

        public void add(Object object) {
            throw new UnsupportedOperationException();
        }
    }
}

