/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network.chatroom;

import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.openymsg.network.Util;
import org.openymsg.network.chatroom.YahooChatLobby;
import org.openymsg.network.chatroom.YahooChatRoom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YahooChatCategory {
    private static final String PUBLIC_TYPE = "yahoo";
    private static final String CAT_URL = "insider.msg.yahoo.com/ycontent/?chatroom_";
    private final String name;
    private final long id;
    private final String cookieLine;
    private final Set<YahooChatCategory> subcategories;
    private final Set<YahooChatRoom> privateRooms;
    private final Set<YahooChatRoom> publicRooms;
    private final String localePrefix;
    private final Hashtable<String, YahooChatLobby> chatByNetName;

    public YahooChatCategory(long id, String rawName, String cookieLine, String localePrefix) {
        this.id = id;
        this.name = Util.entityDecode(rawName);
        this.cookieLine = cookieLine;
        this.localePrefix = localePrefix;
        this.subcategories = new HashSet<YahooChatCategory>();
        this.privateRooms = new HashSet<YahooChatRoom>();
        this.publicRooms = new HashSet<YahooChatRoom>();
        this.chatByNetName = new Hashtable();
    }

    public void addSubcategory(YahooChatCategory category) {
        this.subcategories.add(category);
    }

    public Set<YahooChatRoom> getPublicRooms() {
        return this.publicRooms;
    }

    public Set<YahooChatRoom> getPrivateRooms() {
        return this.privateRooms;
    }

    public Set<YahooChatCategory> getSubcategories() {
        return this.subcategories;
    }

    public String getName() {
        return this.name;
    }

    public long getId() {
        return this.id;
    }

    public YahooChatLobby getLobby(String networkName) {
        return this.chatByNetName.get(networkName);
    }

    public String toString() {
        return "YahooChatCategory [name=" + this.name + " id=" + this.id + ']';
    }

    public synchronized void loadRooms() throws Exception {
        this.publicRooms.clear();
        this.privateRooms.clear();
        String addr = "http://" + this.localePrefix + CAT_URL;
        URLConnection uConn = new URL(addr + this.id).openConnection();
        Util.initURLConnection(uConn);
        if (this.cookieLine != null) {
            uConn.setRequestProperty("Cookie", this.cookieLine);
        }
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(new URL(addr + this.id));
        Element chatRooms = doc.getRootElement().getChild("chatRooms");
        List rooms = chatRooms.getChildren("room");
        for (Element room : rooms) {
            String roomType = room.getAttributeValue("type");
            long roomId = Long.parseLong(room.getAttributeValue("id"));
            String roomName = room.getAttributeValue("name");
            String roomTopic = room.getAttributeValue("topic");
            YahooChatRoom yahooChatRoom = new YahooChatRoom(roomId, roomName, roomTopic, roomType.equals(PUBLIC_TYPE));
            List lobbies = room.getChildren("lobby");
            for (Element lobby : lobbies) {
                int lobbyNumber = Integer.parseInt(lobby.getAttributeValue("count"));
                int reportedUsers = Integer.parseInt(lobby.getAttributeValue("users", "-1"));
                int reportedVoices = Integer.parseInt(lobby.getAttributeValue("voices", "-1"));
                int reportedWebcams = Integer.parseInt(lobby.getAttributeValue("webcams", "-1"));
                YahooChatLobby l = yahooChatRoom.createLobby(lobbyNumber);
                l.setReportedUsers(reportedUsers);
                l.setReportedVoices(reportedVoices);
                l.setReportedWebcams(reportedWebcams);
                this.chatByNetName.put(l.getNetworkName(), l);
            }
            if (yahooChatRoom.isPublic()) {
                this.publicRooms.add(yahooChatRoom);
                continue;
            }
            this.privateRooms.add(yahooChatRoom);
        }
    }
}

