/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.SocketReadable;
import com.hazelcast.nio.SocketWritable;
import com.hazelcast.nio.serialization.BinaryClassDefinition;
import com.hazelcast.nio.serialization.BinaryClassDefinitionProxy;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableContext;
import java.nio.ByteBuffer;

public class DataAdapter
implements SocketWritable,
SocketReadable {
    private static final int ST_TYPE = 1;
    private static final int ST_CLASS_ID = 2;
    private static final int ST_FACTORY_ID = 3;
    private static final int ST_VERSION = 4;
    private static final int ST_CLASS_DEF_SIZE = 5;
    private static final int ST_CLASS_DEF = 6;
    private static final int ST_SIZE = 7;
    private static final int ST_VALUE = 8;
    private static final int ST_HASH = 9;
    private static final int ST_ALL = 10;
    protected Data data;
    private ByteBuffer buffer;
    private int factoryId;
    private int classId;
    private int version;
    private int classDefSize;
    private boolean skipClassDef;
    private transient short status;
    private transient PortableContext context;

    public DataAdapter(Data data) {
        this.data = data;
    }

    public DataAdapter(PortableContext context) {
        this.context = context;
    }

    public DataAdapter(Data data, PortableContext context) {
        this.data = data;
        this.context = context;
    }

    @Override
    public boolean isUrgent() {
        return false;
    }

    @Override
    public boolean writeTo(ByteBuffer destination) {
        if (!this.isStatusSet(1)) {
            if (destination.remaining() < 4) {
                return false;
            }
            destination.putInt(this.data.type);
            this.setStatus(1);
        }
        if (!this.isStatusSet(2)) {
            if (destination.remaining() < 4) {
                return false;
            }
            this.classId = this.data.classDefinition == null ? 0 : this.data.classDefinition.getClassId();
            destination.putInt(this.classId);
            if (this.classId == 0) {
                this.setStatus(3);
                this.setStatus(4);
                this.setStatus(5);
                this.setStatus(6);
            }
            this.setStatus(2);
        }
        if (!this.isStatusSet(3)) {
            if (destination.remaining() < 4) {
                return false;
            }
            destination.putInt(this.data.classDefinition.getFactoryId());
            this.setStatus(3);
        }
        if (!this.isStatusSet(4)) {
            if (destination.remaining() < 4) {
                return false;
            }
            int version = this.data.classDefinition.getVersion();
            destination.putInt(version);
            this.setStatus(4);
        }
        if (!this.isStatusSet(5)) {
            if (destination.remaining() < 4) {
                return false;
            }
            BinaryClassDefinition cd = (BinaryClassDefinition)this.data.classDefinition;
            byte[] binary = cd.getBinary();
            this.classDefSize = binary == null ? 0 : binary.length;
            destination.putInt(this.classDefSize);
            this.setStatus(5);
            if (this.classDefSize == 0) {
                this.setStatus(6);
            } else {
                this.buffer = ByteBuffer.wrap(binary);
            }
        }
        if (!this.isStatusSet(6)) {
            IOUtil.copyToHeapBuffer(this.buffer, destination);
            if (this.buffer.hasRemaining()) {
                return false;
            }
            this.setStatus(6);
        }
        if (!this.isStatusSet(7)) {
            if (destination.remaining() < 4) {
                return false;
            }
            int size = this.data.bufferSize();
            destination.putInt(size);
            this.setStatus(7);
            if (size <= 0) {
                this.setStatus(8);
            } else {
                this.buffer = ByteBuffer.wrap(this.data.buffer);
            }
        }
        if (!this.isStatusSet(8)) {
            IOUtil.copyToHeapBuffer(this.buffer, destination);
            if (this.buffer.hasRemaining()) {
                return false;
            }
            this.setStatus(8);
        }
        if (!this.isStatusSet(9)) {
            if (destination.remaining() < 4) {
                return false;
            }
            destination.putInt(this.data.getPartitionHash());
            this.setStatus(9);
        }
        this.setStatus(10);
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer source) {
        if (this.data == null) {
            this.data = new Data();
        }
        if (!this.isStatusSet(1)) {
            if (source.remaining() < 4) {
                return false;
            }
            this.data.type = source.getInt();
            this.setStatus(1);
        }
        if (!this.isStatusSet(2)) {
            if (source.remaining() < 4) {
                return false;
            }
            this.classId = source.getInt();
            this.setStatus(2);
            if (this.classId == 0) {
                this.setStatus(3);
                this.setStatus(4);
                this.setStatus(5);
                this.setStatus(6);
            }
        }
        if (!this.isStatusSet(3)) {
            if (source.remaining() < 4) {
                return false;
            }
            this.factoryId = source.getInt();
            this.setStatus(3);
        }
        if (!this.isStatusSet(4)) {
            if (source.remaining() < 4) {
                return false;
            }
            this.version = source.getInt();
            this.setStatus(4);
        }
        if (!this.isStatusSet(6)) {
            ClassDefinition cd = this.context.lookup(this.factoryId, this.classId, this.version);
            if (!this.skipClassDef && cd != null) {
                this.data.classDefinition = cd;
                this.skipClassDef = true;
            }
            if (!this.isStatusSet(5)) {
                if (source.remaining() < 4) {
                    return false;
                }
                this.classDefSize = source.getInt();
                this.setStatus(5);
            }
            if (!this.isStatusSet(6)) {
                if (source.remaining() < this.classDefSize) {
                    return false;
                }
                if (this.skipClassDef) {
                    source.position(this.classDefSize + source.position());
                } else {
                    byte[] binary = new byte[this.classDefSize];
                    source.get(binary);
                    this.data.classDefinition = new BinaryClassDefinitionProxy(this.factoryId, this.classId, this.version, binary);
                }
                this.setStatus(6);
            }
        }
        if (!this.isStatusSet(7)) {
            if (source.remaining() < 4) {
                return false;
            }
            int size = source.getInt();
            this.buffer = ByteBuffer.allocate(size);
            this.setStatus(7);
        }
        if (!this.isStatusSet(8)) {
            IOUtil.copyToHeapBuffer(source, this.buffer);
            if (this.buffer.hasRemaining()) {
                return false;
            }
            this.buffer.flip();
            this.data.buffer = this.buffer.array();
            this.setStatus(8);
        }
        if (!this.isStatusSet(9)) {
            if (source.remaining() < 4) {
                return false;
            }
            this.data.partitionHash = source.getInt();
            this.setStatus(9);
        }
        this.setStatus(10);
        return true;
    }

    protected final void setStatus(int bit) {
        this.status = (short)(this.status | 1 << bit);
    }

    protected final boolean isStatusSet(int bit) {
        return (this.status & 1 << bit) != 0;
    }

    public final Data getData() {
        this.data.postConstruct(this.context);
        return this.data;
    }

    public final void setData(Data data) {
        this.data = data;
    }

    public boolean done() {
        return this.isStatusSet(10);
    }

    public void reset() {
        this.buffer = null;
        this.classId = 0;
        this.version = 0;
        this.classDefSize = 0;
        this.data = null;
        this.status = 0;
    }
}

