/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.operation.AbstractMultipleEntryOperation;
import com.hazelcast.map.record.Record;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.QueryEntry;
import com.hazelcast.spi.BackupOperation;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class PartitionWideEntryBackupOperation
extends AbstractMultipleEntryOperation
implements BackupOperation {
    public PartitionWideEntryBackupOperation() {
    }

    public PartitionWideEntryBackupOperation(String name, EntryBackupProcessor backupProcessor) {
        super(name, backupProcessor);
    }

    @Override
    public void run() {
        long now = this.getNow();
        Iterator<Record> iterator = this.recordStore.iterator(now, true);
        while (iterator.hasNext()) {
            Object value;
            Record record = iterator.next();
            Data dataKey = record.getKey();
            Object oldValue = record.getValue();
            Object key = this.toObject(dataKey);
            if (!this.applyPredicate(dataKey, key, value = this.toObject(oldValue))) continue;
            Map.Entry entry = this.createMapEntry(key, value);
            this.processBackup(entry);
            if (this.noOp(entry, oldValue) || this.entryRemovedBackup(entry, dataKey)) continue;
            this.entryAddedOrUpdatedBackup(entry, dataKey);
            this.evict(true);
        }
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    protected Predicate getPredicate() {
        return null;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.backupProcessor = (EntryBackupProcessor)in.readObject();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.backupProcessor);
    }

    @Override
    public Object getResponse() {
        return true;
    }

    public String toString() {
        return "PartitionWideEntryBackupOperation{}";
    }

    private boolean applyPredicate(Data dataKey, Object key, Object value) {
        if (this.getPredicate() == null) {
            return true;
        }
        SerializationService ss = this.getNodeEngine().getSerializationService();
        QueryEntry queryEntry = new QueryEntry(ss, dataKey, key, value);
        return this.getPredicate().apply(queryEntry);
    }
}

