/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.client;

import com.hazelcast.map.client.MapPutRequest;
import com.hazelcast.map.operation.ReplaceIfSameOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class MapReplaceIfSameRequest
extends MapPutRequest {
    private Data testValue;

    public MapReplaceIfSameRequest() {
    }

    public MapReplaceIfSameRequest(String name, Data key, Data testValue, Data value, long threadId) {
        super(name, key, value, threadId);
        this.testValue = testValue;
    }

    @Override
    public int getClassId() {
        return 16;
    }

    @Override
    protected Operation prepareOperation() {
        ReplaceIfSameOperation op = new ReplaceIfSameOperation(this.name, this.key, this.testValue, this.value);
        op.setThreadId(this.threadId);
        return op;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        ObjectDataOutput out = writer.getRawDataOutput();
        this.testValue.writeData(out);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        ObjectDataInput in = reader.getRawDataInput();
        this.testValue = new Data();
        this.testValue.readData(in);
    }

    @Override
    public String getMethodName() {
        return "replace";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.key, this.testValue, this.value};
    }
}

