/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network;

import java.util.ArrayList;
import org.openymsg.network.ServiceType;

class YMSG9Packet {
    String magic;
    int version;
    int length;
    ServiceType service;
    long status;
    long sessionId;
    String[] body;
    String quickSetAccessSeparator;
    int[] quickSetAccess = null;

    YMSG9Packet() {
    }

    private int getNthLocation(String string, int n) {
        for (int i = 0; i < this.body.length; i += 2) {
            if (this.body[i].equals(string)) {
                --n;
            }
            if (n >= 0) continue;
            return i;
        }
        return -1;
    }

    String getNthValue(String string, int n) {
        int n2 = this.getNthLocation(string, n);
        if (n2 < 0) {
            return null;
        }
        return this.body[n2 + 1];
    }

    String getValue(String string) {
        return this.getNthValue(string, 0);
    }

    String[] getValues(String string) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.body.length; i += 2) {
            if (!this.body[i].equals(string)) continue;
            ++n;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < this.body.length; i += 2) {
            if (!this.body[i].equals(string)) continue;
            stringArray[n2++] = this.body[i + 1];
        }
        return stringArray;
    }

    String getValueFromNthSet(String string, String string2, int n) {
        int n2 = this.getNthLocation(string, n);
        if (n2 < 0) {
            return null;
        }
        n2 += 2;
        while (n2 < this.body.length) {
            if (this.body[n2].equals(string2)) {
                return this.body[n2 + 1];
            }
            if (this.body[n2].equals(string)) {
                return null;
            }
            n2 += 2;
        }
        return null;
    }

    boolean exists(String string) {
        return this.getValue(string) != null;
    }

    void generateQuickSetAccessors(String string) {
        int n;
        if (this.quickSetAccess != null && this.quickSetAccessSeparator.equals(string)) {
            return;
        }
        this.quickSetAccessSeparator = string;
        int n2 = 0;
        for (n = 0; n < this.body.length; n += 2) {
            if (!this.body[n].equals(string)) continue;
            ++n2;
        }
        this.quickSetAccess = new int[n2 + 1];
        n = 0;
        for (int i = 0; i < n2; ++i) {
            while (n < this.body.length && !this.body[n].equals(string)) {
                n += 2;
            }
            this.quickSetAccess[i] = n;
            n += 2;
        }
        this.quickSetAccess[i] = this.body.length;
    }

    String getValueFromNthSetQA(String string, int n) {
        for (int i = this.quickSetAccess[n]; i < this.quickSetAccess[n + 1]; i += 2) {
            if (!this.body[i].equals(string)) continue;
            return this.body[i + 1];
        }
        return null;
    }

    boolean existsSetQA(String string, int n) {
        return this.getValueFromNthSetQA(string, n) != null;
    }

    void append(YMSG9Packet yMSG9Packet) {
        String[] stringArray = new String[this.body.length + yMSG9Packet.body.length];
        System.arraycopy(this.body, 0, stringArray, 0, this.body.length);
        System.arraycopy(yMSG9Packet.body, 0, stringArray, this.body.length, yMSG9Packet.body.length);
        this.body = stringArray;
    }

    void merge(YMSG9Packet yMSG9Packet, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < yMSG9Packet.body.length; i += 2) {
            int n;
            String string = yMSG9Packet.body[i];
            String string2 = yMSG9Packet.body[i + 1];
            boolean bl = false;
            for (n = 0; n < stringArray.length; ++n) {
                if (!stringArray[n].equals(string)) continue;
                bl = true;
                break;
            }
            if (bl) {
                n = this.getNthLocation(string, 0);
                if (n < 0) {
                    arrayList.add(string);
                    arrayList.add(yMSG9Packet.body[i + 1]);
                    continue;
                }
                this.body[n + 1] = this.body[n + 1] + string2;
                continue;
            }
            arrayList.add(string);
            arrayList.add(yMSG9Packet.body[i + 1]);
        }
        if (arrayList.size() > 0) {
            String[] stringArray2 = new String[this.body.length + arrayList.size()];
            System.arraycopy(this.body, 0, stringArray2, 0, this.body.length);
            for (int i = 0; i < arrayList.size(); ++i) {
                stringArray2[this.body.length + i] = (String)arrayList.get(i);
            }
            this.body = stringArray2;
        }
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Magic:").append(this.magic);
        stringBuffer.append(" Version:").append(this.version);
        stringBuffer.append(" Length:").append(this.length);
        stringBuffer.append(" Service:").append((Object)this.service);
        stringBuffer.append(" Status:").append(this.status);
        stringBuffer.append(" SessionId:0x").append(Long.toHexString(this.sessionId));
        stringBuffer.append(" ");
        for (n = 0; n < this.body.length; ++n) {
            stringBuffer.append(" [" + this.body[n] + "]");
        }
        if (this.quickSetAccess != null) {
            stringBuffer.append(" ").append(this.quickSetAccessSeparator).append(":");
            for (n = 0; n < this.quickSetAccess.length; ++n) {
                stringBuffer.append(this.quickSetAccess[n]).append(" ");
            }
        }
        return stringBuffer.toString();
    }
}

