/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.openymsg.network.AccountLockedException;
import org.openymsg.network.AuthenticationState;
import org.openymsg.network.ChallengeResponseV10;
import org.openymsg.network.ChallengeResponseV9;
import org.openymsg.network.ConnectionHandler;
import org.openymsg.network.DirectConnectionHandler;
import org.openymsg.network.EventDispatcher;
import org.openymsg.network.FileTransferFailedException;
import org.openymsg.network.HTTPConnectionHandler;
import org.openymsg.network.IllegalIdentityException;
import org.openymsg.network.InputThread;
import org.openymsg.network.LoginRefusedException;
import org.openymsg.network.NetworkConstants;
import org.openymsg.network.NoSuchChatroomException;
import org.openymsg.network.NoSuchConferenceException;
import org.openymsg.network.PacketBodyBuffer;
import org.openymsg.network.SOCKSConnectionHandler;
import org.openymsg.network.ServiceType;
import org.openymsg.network.SessionPinger;
import org.openymsg.network.SessionState;
import org.openymsg.network.Status;
import org.openymsg.network.StatusConstants;
import org.openymsg.network.UserStore;
import org.openymsg.network.Util;
import org.openymsg.network.YMSG9BadFormatException;
import org.openymsg.network.YMSG9Packet;
import org.openymsg.network.YahooConference;
import org.openymsg.network.YahooException;
import org.openymsg.network.YahooGroup;
import org.openymsg.network.YahooIdentity;
import org.openymsg.network.YahooUser;
import org.openymsg.network.chatroom.ChatroomManager;
import org.openymsg.network.chatroom.YahooChatLobby;
import org.openymsg.network.chatroom.YahooChatUser;
import org.openymsg.network.event.SessionChatEvent;
import org.openymsg.network.event.SessionConferenceEvent;
import org.openymsg.network.event.SessionErrorEvent;
import org.openymsg.network.event.SessionEvent;
import org.openymsg.network.event.SessionExceptionEvent;
import org.openymsg.network.event.SessionFileTransferEvent;
import org.openymsg.network.event.SessionFriendEvent;
import org.openymsg.network.event.SessionGroupEvent;
import org.openymsg.network.event.SessionListener;
import org.openymsg.network.event.SessionNewMailEvent;
import org.openymsg.network.event.SessionNotifyEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Session
implements StatusConstants {
    private YahooIdentity primaryID;
    private YahooIdentity loginID;
    private final Map<String, YahooIdentity> identities = new HashMap<String, YahooIdentity>();
    private String password;
    private String cookieY;
    private String cookieT;
    private String cookieC;
    private String imvironment;
    private Status status;
    private String customStatusMessage;
    private boolean customStatusBusy;
    private final Set<YahooGroup> groups = new HashSet<YahooGroup>();
    private int conferenceCount;
    UserStore userStore;
    private volatile SessionState sessionStatus;
    volatile long sessionId = 0L;
    public volatile ConnectionHandler network;
    private static final ScheduledExecutorService SCHEDULED_PINGER_SERVICE = new ScheduledThreadPoolExecutor(0);
    private ScheduledFuture<?> pingerFuture;
    private InputThread ipThread;
    private final Hashtable<String, TypingNotifier> typingNotifiers = new Hashtable();
    private EventDispatcher eventDispatchQueue;
    private YahooException loginException = null;
    private YMSG9Packet cachePacket;
    private final ChatroomManager chatroomManager;
    private final Hashtable<String, YahooConference> conferences = new Hashtable();
    private SessionState chatSessionStatus;
    private volatile YahooChatLobby currentLobby = null;
    private YahooIdentity chatID;

    public Session() throws NumberFormatException {
        this(null);
    }

    public Session(ConnectionHandler connectionHandler) throws NumberFormatException {
        Properties properties;
        this.network = connectionHandler != null ? connectionHandler : ((properties = System.getProperties()).containsKey("socksProxyHost") ? new SOCKSConnectionHandler() : (properties.containsKey("http.proxyHost") || properties.containsKey("proxyHost") ? new HTTPConnectionHandler() : new DirectConnectionHandler()));
        this.chatroomManager = new ChatroomManager(null, null);
        this.eventDispatchQueue = new EventDispatcher();
        this.eventDispatchQueue.start();
        this.status = Status.AVAILABLE;
        this.sessionId = 0L;
        this.sessionStatus = SessionState.UNSTARTED;
        this.userStore = new UserStore();
        this.network.install(this);
    }

    public void addSessionListener(SessionListener sessionListener) {
        if (sessionListener == null) {
            throw new IllegalArgumentException("Argument 'sessionListener' cannot be null.");
        }
        this.eventDispatchQueue.addSessionListener(sessionListener);
    }

    public void removeSessionListener(SessionListener sessionListener) {
        if (sessionListener == null) {
            throw new IllegalArgumentException("Argument 'sessionListener' cannot be null.");
        }
        this.eventDispatchQueue.removeSessionListener(sessionListener);
    }

    public ConnectionHandler getConnectionHandler() {
        return this.network;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(String string, String string2) throws IllegalStateException, IOException, AccountLockedException, LoginRefusedException {
        if (string == null || string.length() == 0) {
            this.sessionStatus = SessionState.FAILED;
            throw new IllegalArgumentException("Argument 'username' cannot be null or an empty String.");
        }
        if (string2 == null || string2.length() == 0) {
            this.sessionStatus = SessionState.FAILED;
            throw new IllegalArgumentException("Argument 'password' cannot be null or an empty String.");
        }
        Session session = this;
        synchronized (session) {
            if (this.sessionStatus != SessionState.UNSTARTED) {
                throw new IllegalStateException("Session should be unstarted");
            }
            this.sessionStatus = SessionState.CONNECTING;
        }
        string = string.toLowerCase();
        this.resetData();
        this.loginID = new YahooIdentity(string);
        this.primaryID = null;
        this.password = string2;
        this.sessionId = 0L;
        this.imvironment = "0";
        try {
            this.openSession();
            this.transmitAuth();
            long l = System.currentTimeMillis() + (long)Util.loginTimeout(60);
            while (this.sessionStatus != SessionState.LOGGED_ON && this.sessionStatus != SessionState.FAILED && !this.past(l)) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.past(l)) {
                this.sessionStatus = SessionState.FAILED;
                throw new InterruptedIOException("Login timed out");
            }
            if (this.sessionStatus == SessionState.FAILED) {
                throw (LoginRefusedException)this.loginException;
            }
        }
        finally {
            if (this.sessionStatus != SessionState.LOGGED_ON) {
                this.closeSession();
            }
        }
    }

    public synchronized void logout() throws IllegalStateException, IOException {
        this.checkStatus();
        this.sessionStatus = SessionState.UNSTARTED;
        this.transmitLogoff();
        this.network.close();
    }

    public synchronized void reset() throws IllegalStateException {
        if (this.sessionStatus != SessionState.FAILED && this.sessionStatus != SessionState.UNSTARTED) {
            throw new IllegalStateException("Session currently active");
        }
        this.sessionStatus = SessionState.UNSTARTED;
        this.chatSessionStatus = SessionState.UNSTARTED;
        this.resetData();
    }

    public void sendMessage(String string, String string2) throws IllegalStateException, IOException {
        this.sendMessage(string, string2, this.loginID);
    }

    public void sendMessage(String string, String string2, YahooIdentity yahooIdentity) throws IllegalStateException, IOException, IllegalIdentityException {
        this.checkStatus();
        if (!this.identities.containsKey(yahooIdentity.getId())) {
            throw new IllegalIdentityException("The YahooIdentity '" + yahooIdentity.getId() + "'is not a valid identity for this session.");
        }
        this.transmitMessage(string, yahooIdentity, string2);
    }

    public void sendBuzz(String string) throws IllegalStateException, IOException {
        this.sendMessage(string, "<ding>");
    }

    public void sendBuzz(String string, YahooIdentity yahooIdentity) throws IllegalStateException, IOException, IllegalIdentityException {
        this.sendMessage(string, "<ding>", yahooIdentity);
    }

    public SessionState getSessionStatus() {
        return this.sessionStatus;
    }

    public synchronized Status getStatus() {
        return this.status;
    }

    public synchronized void setStatus(Status status) throws IllegalArgumentException, IOException {
        if (this.sessionStatus == SessionState.UNSTARTED && status != Status.AVAILABLE && status != Status.INVISIBLE) {
            throw new IllegalArgumentException("Unstarted sessions can be available or invisible only");
        }
        if (status == Status.CUSTOM) {
            throw new IllegalArgumentException("Cannot set custom state without message");
        }
        this.status = status;
        this.customStatusMessage = null;
        if (this.sessionStatus != SessionState.UNSTARTED) {
            this.transmitNewStatus();
        }
    }

    public synchronized void setStatus(String string, boolean bl) throws IllegalArgumentException, IOException {
        if (this.sessionStatus == SessionState.UNSTARTED) {
            throw new IllegalArgumentException("Unstarted sessions can be available or invisible only");
        }
        if (string == null) {
            throw new IllegalArgumentException("Cannot set custom state with null message");
        }
        this.status = Status.CUSTOM;
        this.customStatusMessage = string;
        this.customStatusBusy = bl;
        this.transmitNewCustomStatus();
    }

    public String getCustomStatusMessage() {
        return this.customStatusMessage;
    }

    public boolean isCustomBusy() {
        return this.customStatusBusy;
    }

    public void refreshStats() throws IllegalStateException, IOException {
        this.checkStatus();
        this.transmitUserStat();
    }

    public boolean isValidYahooID(String string) {
        return this.identities.containsKey(string);
    }

    public YahooIdentity getPrimaryIdentity() {
        return this.primaryID;
    }

    public YahooIdentity getLoginIdentity() {
        return this.loginID;
    }

    public void activateIdentity(YahooIdentity yahooIdentity, boolean bl) throws IllegalStateException, IllegalIdentityException, IOException {
        this.checkStatus();
        if (!this.identities.containsKey(yahooIdentity.getId())) {
            throw new IllegalIdentityException("The YahooIdentity '" + yahooIdentity.getId() + "'is not a valid identity for this session.");
        }
        if (yahooIdentity.equals(this.primaryID)) {
            throw new IllegalIdentityException("Primary identity cannot be de/activated");
        }
        if (bl) {
            this.transmitIdActivate(yahooIdentity.getId());
        } else {
            this.transmitIdDeactivate(yahooIdentity.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTypingNotification(String string, Component component) {
        String string2 = this.primaryID.getId();
        String string3 = "user\n" + string2;
        Hashtable<String, TypingNotifier> hashtable = this.typingNotifiers;
        synchronized (hashtable) {
            if (this.typingNotifiers.containsKey(string3)) {
                return;
            }
            this.typingNotifiers.put(string3, new TypingNotifier(component, string, string2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTypingNotification(String string) {
        String string2 = this.primaryID.getId();
        String string3 = "user\n" + string2;
        Hashtable<String, TypingNotifier> hashtable = this.typingNotifiers;
        synchronized (hashtable) {
            TypingNotifier typingNotifier = this.typingNotifiers.get(string3);
            if (typingNotifier == null) {
                return;
            }
            typingNotifier.quit = true;
            typingNotifier.interrupt();
            this.typingNotifiers.remove(string3);
        }
    }

    public void keyTyped(String string) {
        String string2 = this.primaryID.getId();
        String string3 = "user\n" + string2;
        TypingNotifier typingNotifier = this.typingNotifiers.get(string3);
        if (typingNotifier != null) {
            typingNotifier.keyTyped();
        }
    }

    public Set<YahooGroup> getGroups() {
        return this.groups;
    }

    public Hashtable<String, YahooUser> getUsers() {
        return new Hashtable<String, YahooUser>(this.userStore.getUsers());
    }

    public YahooUser getUser(String string) {
        return this.userStore.get(string);
    }

    public String getImvironment() {
        return this.imvironment;
    }

    public String[] getCookies() {
        String[] stringArray = new String[]{this.cookieY, this.cookieT, this.cookieC};
        return stringArray;
    }

    public YahooConference createConference(String[] stringArray, String string) throws IllegalStateException, IOException, IllegalIdentityException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.primaryID.getId().equals(stringArray[i]) && !this.loginID.getId().equals(stringArray[i]) && !this.identities.containsKey(stringArray[i])) continue;
            throw new IllegalIdentityException(stringArray[i] + " is an identity of this session and cannot be used here");
        }
        return this.createConference(stringArray, string, this.loginID);
    }

    public YahooConference createConference(String[] stringArray, String string, YahooIdentity yahooIdentity) throws IllegalStateException, IOException, IllegalIdentityException {
        this.checkStatus();
        if (!this.identities.containsKey(yahooIdentity.getId())) {
            throw new IllegalIdentityException("The YahooIdentity '" + yahooIdentity.getId() + "'is not a valid identity for this session.");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.primaryID.getId().equals(stringArray[i]) && !this.loginID.getId().equals(stringArray[i]) && !this.identities.containsKey(stringArray[i])) continue;
            throw new IllegalIdentityException(stringArray[i] + " is an identity of this session and cannot be used here");
        }
        String string2 = this.getConferenceName(yahooIdentity.getId());
        this.transmitConfInvite(stringArray, yahooIdentity.getId(), string2, string);
        return this.getConference(string2);
    }

    public void acceptConferenceInvite(SessionConferenceEvent sessionConferenceEvent) throws IllegalStateException, IOException, NoSuchConferenceException {
        YahooConference yahooConference = sessionConferenceEvent.getRoom();
        this.checkStatus();
        this.transmitConfLogon(yahooConference.getName(), yahooConference.getIdentity().getId());
    }

    public void declineConferenceInvite(SessionConferenceEvent sessionConferenceEvent, String string) throws IllegalStateException, IOException, NoSuchConferenceException {
        YahooConference yahooConference = sessionConferenceEvent.getRoom();
        this.checkStatus();
        this.transmitConfDecline(yahooConference.getName(), yahooConference.getIdentity().getId(), string);
    }

    public void extendConference(YahooConference yahooConference, YahooIdentity yahooIdentity, String string) throws IllegalStateException, IOException, NoSuchConferenceException, IllegalIdentityException {
        this.checkStatus();
        String string2 = yahooIdentity.getId();
        if (this.primaryID.getId().equals(string2) || this.loginID.getId().equals(string2) || this.identities.containsKey(string2)) {
            throw new IllegalIdentityException(string2 + " is an identity of this session and cannot be used here");
        }
        this.transmitConfAddInvite(yahooIdentity, yahooConference.getName(), yahooConference.getIdentity().getId(), string);
    }

    public void sendConferenceMessage(YahooConference yahooConference, String string) throws IllegalStateException, IOException, NoSuchConferenceException {
        this.checkStatus();
        this.transmitConfMsg(yahooConference.getName(), yahooConference.getIdentity().getId(), string);
    }

    public void leaveConference(YahooConference yahooConference) throws IllegalStateException, IOException, NoSuchConferenceException {
        this.checkStatus();
        this.transmitConfLogoff(yahooConference.getName(), yahooConference.getIdentity().getId());
    }

    public void addFriend(String string, String string2) throws IllegalStateException, IOException {
        this.checkStatus();
        this.transmitFriendAdd(string, string2);
    }

    public void removeFriend(String string, String string2) throws IllegalStateException, IOException {
        this.checkStatus();
        this.transmitFriendRemove(string, string2);
    }

    public void renameGroup(String string, String string2) throws IllegalStateException, IOException {
        this.checkStatus();
        this.transmitGroupRename(string, string2);
    }

    public void rejectContact(SessionEvent sessionEvent, String string) throws IllegalArgumentException, IllegalStateException, IOException {
        if (sessionEvent.getFrom() == null || sessionEvent.getTo() == null) {
            throw new IllegalArgumentException("Missing to or from field in event object.");
        }
        this.checkStatus();
        this.transmitContactReject(sessionEvent.getFrom(), sessionEvent.getTo(), string);
    }

    public void ignoreContact(String string, boolean bl) throws IllegalStateException, IOException {
        this.checkStatus();
        this.transmitContactIgnore(string, bl);
    }

    public void refreshFriends() throws IllegalStateException, IOException {
        this.checkStatus();
        this.transmitList();
    }

    public void sendFileTransfer(String string, File file, String string2) throws IllegalStateException, FileTransferFailedException, IOException {
        this.checkStatus();
        this.transmitFileTransfer(string, string2, file);
    }

    public void saveFileTransferAs(SessionFileTransferEvent sessionFileTransferEvent, String string) throws FileTransferFailedException, IOException {
        this.saveFT(sessionFileTransferEvent, null, string);
    }

    public void saveFileTransferTo(SessionFileTransferEvent sessionFileTransferEvent, String string) throws FileTransferFailedException, IOException {
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        this.saveFT(sessionFileTransferEvent, string, sessionFileTransferEvent.getFilename());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFT(SessionFileTransferEvent sessionFileTransferEvent, String string, String string2) throws FileTransferFailedException, IOException {
        byte[] byArray = new byte[4096];
        HttpURLConnection httpURLConnection = (HttpURLConnection)sessionFileTransferEvent.getLocation().openConnection();
        Util.initURLConnection(httpURLConnection);
        httpURLConnection.setRequestProperty("User-Agent", "Mozilla/4.5 [en] (X11; U; FreeBSD 2.2.8-STABLE i386)");
        httpURLConnection.setRequestProperty("Cookie", this.cookieY + "; " + this.cookieT);
        httpURLConnection.connect();
        if (httpURLConnection.getResponseCode() != 200) {
            throw new FileTransferFailedException("Server HTTP error code: " + httpURLConnection.getResponseCode());
        }
        String string3 = httpURLConnection.getHeaderField("Content-Disposition");
        if (string != null && string3 != null) {
            int n = string3.indexOf("filename=");
            if (n >= 0) {
                string2 = string3.substring(n + 9);
            }
            if (string2.charAt(0) == '\"') {
                string2 = string2.substring(1, string2.length() - 1);
            }
        }
        if (string != null) {
            string2 = string + string2;
        }
        InputStream inputStream = httpURLConnection.getInputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
        try {
            int n;
            do {
                if ((n = inputStream.read(byArray)) <= 0) continue;
                bufferedOutputStream.write(byArray, 0, n);
            } while (n >= 0);
            bufferedOutputStream.flush();
        }
        finally {
            bufferedOutputStream.close();
            inputStream.close();
        }
        httpURLConnection.disconnect();
    }

    public void chatLogin(YahooChatLobby yahooChatLobby) throws IllegalStateException, IOException, LoginRefusedException {
        this.chatLogin(yahooChatLobby, this.loginID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chatLogin(YahooChatLobby yahooChatLobby, YahooIdentity yahooIdentity) throws IllegalStateException, IOException, LoginRefusedException, IllegalIdentityException {
        this.checkStatus();
        if (!this.identities.containsKey(yahooIdentity.getId())) {
            throw new IllegalIdentityException("The YahooIdentity '" + yahooIdentity.getId() + "'is not a valid identity for this session.");
        }
        Session session = this;
        synchronized (session) {
            if (this.chatSessionStatus != SessionState.UNSTARTED && this.chatSessionStatus != SessionState.LOGGED_ON) {
                throw new IllegalStateException("Chat session should be unstarted or messaging. You can't login to two chatrooms at the same time. Wait for one login to complete before connecting to the next one.");
            }
            this.chatSessionStatus = SessionState.CONNECTING;
        }
        long l = System.currentTimeMillis() + (long)Util.loginTimeout(60);
        this.chatID = yahooIdentity;
        try {
            this.transmitChatConnect(this.chatID.getId());
            while (this.chatSessionStatus != SessionState.CONNECTED && !this.past(l)) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.past(l)) {
                throw new InterruptedIOException("Chat connect timed out");
            }
            this.transmitChatJoin(yahooChatLobby.getNetworkName(), yahooChatLobby.getParentRoomId());
            while (this.chatSessionStatus == SessionState.CONNECTED && !this.past(l)) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.past(l)) {
                throw new InterruptedIOException("Chat login timed out");
            }
            if (this.chatSessionStatus == SessionState.FAILED) {
                throw (LoginRefusedException)this.loginException;
            }
            this.currentLobby = this.chatSessionStatus == SessionState.LOGGED_ON ? yahooChatLobby : null;
        }
        finally {
            if (this.chatSessionStatus != SessionState.LOGGED_ON) {
                this.chatSessionStatus = SessionState.FAILED;
                this.chatID = null;
            }
        }
    }

    public synchronized void chatLogout() throws IllegalStateException, IOException {
        this.checkStatus();
        this.checkChatStatus();
        this.transmitChatDisconnect(this.currentLobby.getNetworkName());
        this.currentLobby = null;
    }

    public synchronized void extendChat(String string, String string2) throws IllegalStateException, IOException {
        this.checkStatus();
        this.checkChatStatus();
        String string3 = this.currentLobby.getNetworkName();
        long l = this.currentLobby.getParentRoomId();
        this.transmitChatInvite(string3, l, string, string2);
    }

    public void sendChatMessage(String string) throws IllegalStateException, IOException {
        this.checkStatus();
        this.checkChatStatus();
        this.transmitChatMsg(this.currentLobby.getNetworkName(), string, false);
    }

    public void sendChatEmote(String string) throws IllegalStateException, IOException {
        this.checkStatus();
        this.checkChatStatus();
        this.transmitChatMsg(this.currentLobby.getNetworkName(), string, true);
    }

    public YahooChatLobby getCurrentChatLobby() {
        return this.currentLobby;
    }

    public SessionState getChatSessionStatus() {
        return this.chatSessionStatus;
    }

    public void resetChat() throws IllegalStateException {
        if (this.chatSessionStatus != SessionState.FAILED && this.chatSessionStatus != SessionState.UNSTARTED) {
            throw new IllegalStateException("Chat session currently active");
        }
        this.chatSessionStatus = SessionState.UNSTARTED;
    }

    protected void transmitAuth() throws IOException {
        if (this.sessionStatus != SessionState.CONNECTING) {
            throw new IllegalStateException("Cannot transmit an AUTH packet if you're not completely unconnected to the Yahoo Network. Current state: " + (Object)((Object)this.sessionStatus));
        }
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("0", this.loginID.getId());
        packetBodyBuffer.addElement("1", this.loginID.getId());
        this.sendPacket(packetBodyBuffer, ServiceType.AUTH);
    }

    protected void transmitAuthResp(String string, String string2) throws IOException {
        if (this.sessionStatus != SessionState.CONNECTED) {
            throw new IllegalStateException("Cannot transmit an AUTHRESP packet if you're not completely unconnected to the Yahoo Network. Current state: " + (Object)((Object)this.sessionStatus));
        }
        this.sessionStatus = SessionState.CONNECTED;
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("0", this.loginID.getId());
        packetBodyBuffer.addElement("6", string);
        packetBodyBuffer.addElement("96", string2);
        packetBodyBuffer.addElement("135", "6,0,0,1710");
        packetBodyBuffer.addElement("2", "1");
        packetBodyBuffer.addElement("1", this.loginID.getId());
        this.sendPacket(packetBodyBuffer, ServiceType.AUTHRESP, this.status);
    }

    protected void transmitChatConnect(String string) throws IOException {
        this.chatSessionStatus = SessionState.CONNECTING;
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("109", this.primaryID.getId());
        packetBodyBuffer.addElement("1", string);
        packetBodyBuffer.addElement("6", "abcde");
        this.sendPacket(packetBodyBuffer, ServiceType.CHATCONNECT);
    }

    protected void transmitChatCreate(long l, String string, String string2, boolean bl) throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", this.chatID.getId());
        packetBodyBuffer.addElement("104", string);
        packetBodyBuffer.addElement("105", string2);
        packetBodyBuffer.addElement("126", "0");
        packetBodyBuffer.addElement("128", l + "");
        packetBodyBuffer.addElement("129", l + "");
        packetBodyBuffer.addElement("62", "2");
        this.sendPacket(packetBodyBuffer, ServiceType.getServiceType(169));
    }

    protected void transmitChatDisconnect(String string) throws IOException {
        this.chatSessionStatus = SessionState.UNSTARTED;
        this.currentLobby = null;
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("104", string);
        packetBodyBuffer.addElement("109", this.chatID.getId());
        this.sendPacket(packetBodyBuffer, ServiceType.CHATDISCONNECT);
    }

    protected void transmitChatInvite(String string, long l, String string2, String string3) throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", this.chatID.getId());
        packetBodyBuffer.addElement("104", string);
        packetBodyBuffer.addElement("117", string3);
        packetBodyBuffer.addElement("118", string2);
        packetBodyBuffer.addElement("129", l + "");
        this.sendPacket(packetBodyBuffer, ServiceType.getServiceType(157));
    }

    protected void transmitChatJoin(String string, long l) throws IOException {
        if (this.sessionStatus != SessionState.CONNECTED) {
            throw new IllegalStateException("Logging on is only possible right after successfully connecting to the network.");
        }
        if (string == null || string.length() < 3 || !string.contains(":")) {
            throw new IllegalStateException("Argument 'netname' cannot be null and must include network name, containing a room and lobby name seperated by a colon (':') character.");
        }
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", this.chatID.getId());
        packetBodyBuffer.addElement("104", string);
        packetBodyBuffer.addElement("129", Long.toString(l));
        packetBodyBuffer.addElement("62", "2");
        this.sendPacket(packetBodyBuffer, ServiceType.CHATJOIN);
    }

    protected void transmitChatMsg(String string, String string2, boolean bl) throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", this.chatID.getId());
        packetBodyBuffer.addElement("104", string);
        packetBodyBuffer.addElement("117", string2);
        if (bl) {
            packetBodyBuffer.addElement("124", "2");
        } else {
            packetBodyBuffer.addElement("124", "1");
        }
        if (Util.isUtf8(string2)) {
            packetBodyBuffer.addElement("97", "1");
        }
        this.sendPacket(packetBodyBuffer, ServiceType.CHATMSG);
    }

    protected void transmitChatPM(String string, String string2) throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("5", string);
        packetBodyBuffer.addElement("14", string2);
        this.sendPacket(packetBodyBuffer, ServiceType.CHATPM);
    }

    protected void transmitChatPing() throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        this.sendPacket(packetBodyBuffer, ServiceType.CHATPING);
    }

    protected void transmitConfAddInvite(YahooIdentity yahooIdentity, String string, String string2, String string3) throws IOException, NoSuchConferenceException {
        this.getConference(string);
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", string2);
        packetBodyBuffer.addElement("51", yahooIdentity.getId());
        packetBodyBuffer.addElement("57", string);
        Set<YahooUser> set = this.getConference(string).getUsers();
        for (YahooUser yahooUser : set) {
            packetBodyBuffer.addElement("52", yahooUser.getId());
            packetBodyBuffer.addElement("53", yahooUser.getId());
        }
        packetBodyBuffer.addElement("58", string3);
        packetBodyBuffer.addElement("13", "0");
        this.sendPacket(packetBodyBuffer, ServiceType.CONFADDINVITE);
    }

    protected void transmitConfDecline(String string, String string2, String string3) throws IOException, NoSuchConferenceException {
        YahooConference yahooConference = this.getConference(string);
        yahooConference.closeConference();
        Set<YahooUser> set = yahooConference.getUsers();
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", string2);
        for (YahooUser yahooUser : set) {
            packetBodyBuffer.addElement("3", yahooUser.getId());
        }
        packetBodyBuffer.addElement("57", string);
        packetBodyBuffer.addElement("14", string3);
        this.sendPacket(packetBodyBuffer, ServiceType.CONFDECLINE);
    }

    protected void transmitConfInvite(String[] stringArray, String string, String string2, String string3) throws IOException {
        this.conferences.put(string2, new YahooConference(this.userStore, this.identities.get(string), string2, this, false));
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", string);
        packetBodyBuffer.addElement("50", this.primaryID.getId());
        for (int i = 0; i < stringArray.length; ++i) {
            packetBodyBuffer.addElement("52", stringArray[i]);
        }
        packetBodyBuffer.addElement("57", string2);
        packetBodyBuffer.addElement("58", string3);
        packetBodyBuffer.addElement("13", "0");
        this.sendPacket(packetBodyBuffer, ServiceType.CONFINVITE);
    }

    protected void transmitConfLogoff(String string, String string2) throws IOException, NoSuchConferenceException {
        YahooConference yahooConference = this.getConference(string);
        yahooConference.closeConference();
        Set<YahooUser> set = yahooConference.getUsers();
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", string2);
        for (YahooUser yahooUser : set) {
            packetBodyBuffer.addElement("3", yahooUser.getId());
        }
        packetBodyBuffer.addElement("57", string);
        this.sendPacket(packetBodyBuffer, ServiceType.CONFLOGOFF);
    }

    protected void transmitConfLogon(String string, String string2) throws IOException, NoSuchConferenceException {
        Set<YahooUser> set = this.getConference(string).getUsers();
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", string2);
        for (YahooUser yahooUser : set) {
            packetBodyBuffer.addElement("3", yahooUser.getId());
        }
        packetBodyBuffer.addElement("57", string);
        this.sendPacket(packetBodyBuffer, ServiceType.CONFLOGON);
    }

    protected void transmitConfMsg(String string, String string2, String string3) throws IOException, NoSuchConferenceException {
        Set<YahooUser> set = this.getConference(string).getUsers();
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", string2);
        for (YahooUser yahooUser : set) {
            packetBodyBuffer.addElement("53", yahooUser.getId());
        }
        packetBodyBuffer.addElement("57", string);
        packetBodyBuffer.addElement("14", string3);
        if (Util.isUtf8(string3)) {
            packetBodyBuffer.addElement("97", "1");
        }
        this.sendPacket(packetBodyBuffer, ServiceType.CONFMSG);
    }

    protected void transmitContactIgnore(String string, boolean bl) throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", this.primaryID.getId());
        packetBodyBuffer.addElement("7", string);
        if (bl) {
            packetBodyBuffer.addElement("13", "1");
        } else {
            packetBodyBuffer.addElement("13", "2");
        }
        this.sendPacket(packetBodyBuffer, ServiceType.CONTACTIGNORE);
    }

    protected void transmitContactReject(String string, String string2, String string3) throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", string2);
        packetBodyBuffer.addElement("7", string);
        packetBodyBuffer.addElement("14", string3);
        this.sendPacket(packetBodyBuffer, ServiceType.CONTACTREJECT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transmitFileTransfer(String string, String string2, File file) throws FileTransferFailedException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 'file' cannot be null.");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("The provided file object does not denote a normal file (but possibly a directory).");
        }
        if (file.length() == 0L) {
            throw new FileTransferFailedException("File transfer: empty file");
        }
        String string3 = this.cookieY + "; " + this.cookieT;
        byte[] byArray = new byte[]{50, 57, -64, -128};
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("0", this.primaryID.getId());
        packetBodyBuffer.addElement("5", string);
        packetBodyBuffer.addElement("28", Long.toString(file.length()));
        packetBodyBuffer.addElement("27", file.getName());
        packetBodyBuffer.addElement("14", string2);
        byte[] byArray2 = packetBodyBuffer.getBuffer();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.write(NetworkConstants.MAGIC, 0, 4);
        dataOutputStream.write(NetworkConstants.VERSION, 0, 4);
        dataOutputStream.writeShort(byArray2.length + 4 & 0xFFFF);
        dataOutputStream.writeShort(ServiceType.FILETRANSFER.getValue() & 0xFFFF);
        dataOutputStream.writeInt((int)(this.status.getValue() & 0xFFFFFFFFFFFFFFFFL));
        dataOutputStream.writeInt((int)(this.sessionId & 0xFFFFFFFFFFFFFFFFL));
        dataOutputStream.write(byArray2, 0, byArray2.length);
        dataOutputStream.write(byArray, 0, 4);
        byArray2 = byteArrayOutputStream.toByteArray();
        String string4 = Util.fileTransferHost();
        String string5 = "http://" + string4 + ":80/notifyft";
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(string5).openConnection();
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setDoOutput(true);
        Util.initURLConnection(httpURLConnection);
        httpURLConnection.setRequestProperty("Content-Length", Long.toString(file.length() + (long)byArray2.length));
        httpURLConnection.setRequestProperty("User-Agent", "Mozilla/4.5 [en] (X11; U; FreeBSD 2.2.8-STABLE i386)");
        httpURLConnection.setRequestProperty("Cookie", string3);
        httpURLConnection.connect();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(httpURLConnection.getOutputStream());
        try {
            bufferedOutputStream.write(byArray2);
            bufferedOutputStream.write(Util.getBytesFromFile(file));
            bufferedOutputStream.flush();
        }
        finally {
            bufferedOutputStream.close();
        }
        int n = httpURLConnection.getResponseCode();
        httpURLConnection.disconnect();
        if (n != 200) {
            throw new FileTransferFailedException("Server rejected upload");
        }
    }

    protected void transmitFriendAdd(String string, String string2) throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", this.primaryID.getId());
        packetBodyBuffer.addElement("7", string);
        packetBodyBuffer.addElement("65", string2);
        this.sendPacket(packetBodyBuffer, ServiceType.FRIENDADD);
    }

    protected void transmitFriendRemove(String string, String string2) throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", this.primaryID.getId());
        packetBodyBuffer.addElement("7", string);
        packetBodyBuffer.addElement("65", string2);
        this.sendPacket(packetBodyBuffer, ServiceType.FRIENDREMOVE);
    }

    protected void transmitGroupRename(String string, String string2) throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", this.primaryID.getId());
        packetBodyBuffer.addElement("65", string);
        packetBodyBuffer.addElement("67", string2);
        this.sendPacket(packetBodyBuffer, ServiceType.GOTGROUPRENAME);
    }

    protected void transmitIdActivate(String string) throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("3", string);
        this.sendPacket(packetBodyBuffer, ServiceType.IDACT);
    }

    protected void transmitIdDeactivate(String string) throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("3", string);
        this.sendPacket(packetBodyBuffer, ServiceType.IDDEACT);
    }

    protected void transmitIdle() throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", this.loginID.getId());
        packetBodyBuffer.addElement("0", this.primaryID.getId());
        this.sendPacket(packetBodyBuffer, ServiceType.IDLE);
    }

    protected void transmitNewStatus() throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("10", String.valueOf(this.status.getValue()));
        packetBodyBuffer.addElement("19", "");
        packetBodyBuffer.addElement("97", "1");
        this.sendPacket(packetBodyBuffer, ServiceType.Y6_STATUS_UPDATE, Status.AVAILABLE);
    }

    protected void transmitNewCustomStatus() throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("10", "99");
        packetBodyBuffer.addElement("19", this.customStatusMessage);
        packetBodyBuffer.addElement("97", "1");
        packetBodyBuffer.addElement("47", this.customStatusBusy ? "1" : "0");
        packetBodyBuffer.addElement("187", "0");
        this.sendPacket(packetBodyBuffer, ServiceType.Y6_STATUS_UPDATE, Status.AVAILABLE);
    }

    protected void transmitList() throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", this.primaryID.getId());
        this.sendPacket(packetBodyBuffer, ServiceType.LIST);
    }

    protected void transmitLogoff() throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("0", this.loginID.getId());
        this.sendPacket(packetBodyBuffer, ServiceType.LOGOFF);
        this.ipThread.stopMe();
        this.network.close();
    }

    protected void transmitMessage(String string, YahooIdentity yahooIdentity, String string2) throws IOException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Argument 'to' cannot be null or an empty String.");
        }
        if (yahooIdentity == null) {
            throw new IllegalArgumentException("Argument 'yid' cannot be null.");
        }
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("0", this.primaryID.getId());
        packetBodyBuffer.addElement("1", yahooIdentity.getId());
        packetBodyBuffer.addElement("5", string);
        packetBodyBuffer.addElement("14", string2);
        if (Util.isUtf8(string2)) {
            packetBodyBuffer.addElement("97", "1");
        }
        packetBodyBuffer.addElement("63", ";" + this.imvironment);
        packetBodyBuffer.addElement("64", "0");
        this.sendPacket(packetBodyBuffer, ServiceType.MESSAGE, Status.OFFLINE);
        TypingNotifier typingNotifier = this.typingNotifiers.get(string);
        if (typingNotifier != null) {
            typingNotifier.stopTyping();
        }
    }

    protected void transmitNotify(String string, String string2, boolean bl, String string3, String string4) throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("4", string2);
        packetBodyBuffer.addElement("5", string);
        packetBodyBuffer.addElement("14", string3);
        if (bl) {
            packetBodyBuffer.addElement("13", "1");
        } else {
            packetBodyBuffer.addElement("13", "0");
        }
        packetBodyBuffer.addElement("49", string4);
        this.sendPacket(packetBodyBuffer, ServiceType.NOTIFY, Status.TYPING);
    }

    protected void transmitPings() throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        this.sendPacket(packetBodyBuffer, ServiceType.PING);
        if (this.currentLobby != null) {
            this.transmitChatPing();
        }
    }

    protected void transmitUserStat() throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        this.sendPacket(packetBodyBuffer, ServiceType.USERSTAT);
    }

    protected void transmitStealthSession(int n, int n2, String string, String string2) throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", string);
        packetBodyBuffer.addElement("31", n + "");
        packetBodyBuffer.addElement("13", n2 + "");
        packetBodyBuffer.addElement("7", string2);
        this.sendPacket(packetBodyBuffer, ServiceType.getServiceType(186));
    }

    protected void receiveAddIgnore(YMSG9Packet yMSG9Packet) {
    }

    protected void receiveAuth(YMSG9Packet yMSG9Packet) throws IOException {
        String[] stringArray;
        if (this.sessionStatus != SessionState.CONNECTING) {
            throw new IllegalStateException("Received a response to an AUTH packet, outside the normal login flow. Current state: " + (Object)((Object)this.sessionStatus));
        }
        String string = yMSG9Packet.getValue("13");
        try {
            stringArray = string != null && string.equals("1") ? ChallengeResponseV10.getStrings(this.loginID.getId(), this.password, yMSG9Packet.getValue("94")) : ChallengeResponseV9.getStrings(this.loginID.getId(), this.password, yMSG9Packet.getValue("94"));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new YMSG9BadFormatException("auth", yMSG9Packet, noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            throw new YMSG9BadFormatException("auth", yMSG9Packet, iOException);
        }
        this.sessionStatus = SessionState.CONNECTED;
        this.transmitAuthResp(stringArray[0], stringArray[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void receiveAuthResp(YMSG9Packet yMSG9Packet) {
        try {
            if (!yMSG9Packet.exists("66")) return;
            long l = Long.parseLong(yMSG9Packet.getValue("66"));
            switch (AuthenticationState.getStatus(l)) {
                case LOCKED: {
                    URL uRL;
                    try {
                        uRL = new URL(yMSG9Packet.getValue("20"));
                    }
                    catch (Exception exception) {
                        uRL = null;
                    }
                    this.loginException = new AccountLockedException("User " + this.loginID + " has been locked out", uRL);
                    return;
                }
                case BAD: {
                    this.loginException = new LoginRefusedException("User " + this.loginID + " refused login", AuthenticationState.BAD);
                    return;
                }
                case BADUSERNAME: {
                    this.loginException = new LoginRefusedException("User " + this.loginID + " unknown", AuthenticationState.BADUSERNAME);
                    return;
                }
            }
            return;
        }
        catch (NumberFormatException numberFormatException) {
            this.loginException = new LoginRefusedException("Number format exception" + numberFormatException.toString());
            return;
        }
        finally {
            this.ipThread.stopMe();
            this.sessionStatus = SessionState.FAILED;
        }
    }

    protected void receiveChatConnect(YMSG9Packet yMSG9Packet) {
        if (this.chatSessionStatus != SessionState.CONNECTING) {
            throw new IllegalStateException("Received a 'CHATCONNECT' packet outside of the logon process. Current state: " + (Object)((Object)this.chatSessionStatus));
        }
        this.chatSessionStatus = SessionState.CONNECTED;
    }

    protected void receiveChatDisconnect(YMSG9Packet yMSG9Packet) {
        if (this.chatSessionStatus != SessionState.UNSTARTED) {
            this.eventDispatchQueue.append(new SessionEvent(this), ServiceType.CHATDISCONNECT);
        }
        this.chatSessionStatus = SessionState.UNSTARTED;
    }

    protected void receiveChatExit(YMSG9Packet yMSG9Packet) {
        try {
            String string = yMSG9Packet.getValue("104");
            String string2 = yMSG9Packet.getValue("109");
            YahooChatLobby yahooChatLobby = this.chatroomManager.getLobby(string);
            if (yahooChatLobby == null) {
                throw new NoSuchChatroomException("Chatroom/lobby " + string + " not found.");
            }
            YahooChatUser yahooChatUser = yahooChatLobby.getUser(string2);
            if (yahooChatUser != null) {
                yahooChatLobby.removeUser(yahooChatUser);
            } else {
                yahooChatUser = this.createChatUser(yMSG9Packet, 0);
            }
            SessionChatEvent sessionChatEvent = new SessionChatEvent(this, 1, yahooChatLobby);
            sessionChatEvent.setChatUser(0, yahooChatUser);
            this.eventDispatchQueue.append(sessionChatEvent, ServiceType.CHATEXIT);
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("chat logoff", yMSG9Packet, exception);
        }
    }

    protected void receiveChatJoin(YMSG9Packet yMSG9Packet) {
        boolean bl = false;
        try {
            int n;
            if (yMSG9Packet.exists("114")) {
                this.loginException = new LoginRefusedException("User " + this.chatID + " refused chat login");
                bl = true;
                this.chatSessionStatus = SessionState.FAILED;
                return;
            }
            if ((yMSG9Packet = this.compoundChatLoginPacket(yMSG9Packet)) == null) {
                return;
            }
            String string = yMSG9Packet.getValue("104");
            YahooChatLobby yahooChatLobby = this.chatroomManager.getLobby(string);
            if (yahooChatLobby == null) {
                throw new NoSuchChatroomException("Chatroom/lobby " + string + " not found.");
            }
            for (n = Integer.parseInt(yMSG9Packet.getValue("108")); n > 0 && yMSG9Packet.getNthValue("109", n - 1) == null; --n) {
            }
            YahooChatUser yahooChatUser = yahooChatLobby.getUser(yMSG9Packet.getValue("109"));
            if (n == 1 && yahooChatUser != null) {
                int n2 = Integer.parseInt(yMSG9Packet.getValue("113"));
                String string2 = yMSG9Packet.getValue("141");
                int n3 = Integer.parseInt(yMSG9Packet.getValue("110"));
                String string3 = yMSG9Packet.getValue("142");
                yahooChatUser.setAttributes(n2);
                yahooChatUser.setAlias(string2);
                yahooChatUser.setAge(n3);
                yahooChatUser.setLocation(string3);
                SessionChatEvent sessionChatEvent = new SessionChatEvent(this, 1, yahooChatLobby);
                sessionChatEvent.setChatUser(0, yahooChatUser);
                this.eventDispatchQueue.append(sessionChatEvent, ServiceType.X_CHATUPDATE);
                return;
            }
            bl = yMSG9Packet.exists("61");
            if (bl) {
                yahooChatLobby.clearUsers();
            }
            Hashtable<String, YahooChatUser> hashtable = new Hashtable<String, YahooChatUser>();
            for (int i = 0; i < n; ++i) {
                yahooChatUser = this.createChatUser(yMSG9Packet, i);
                hashtable.put(yahooChatUser.getId(), yahooChatUser);
            }
            SessionChatEvent sessionChatEvent = new SessionChatEvent(this, n, yahooChatLobby);
            int n4 = 0;
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                yahooChatUser = (YahooChatUser)enumeration.nextElement();
                if (!yahooChatLobby.exists(yahooChatUser)) {
                    yahooChatLobby.addUser(yahooChatUser);
                }
                sessionChatEvent.setChatUser(n4++, yahooChatUser);
            }
            if (!bl) {
                if (sessionChatEvent.getChatUsers().length > 0) {
                    this.eventDispatchQueue.append(sessionChatEvent, ServiceType.CHATJOIN);
                }
            } else {
                this.chatSessionStatus = SessionState.LOGGED_ON;
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new YMSG9BadFormatException("chat login", yMSG9Packet, exception);
        }
        finally {
            if (bl && this.chatSessionStatus != SessionState.FAILED) {
                this.chatSessionStatus = SessionState.LOGGED_ON;
            }
        }
    }

    protected void receiveChatMsg(YMSG9Packet yMSG9Packet) {
        if (this.chatSessionStatus != SessionState.LOGGED_ON) {
            throw new IllegalStateException("Time out on chat login.");
        }
        try {
            String string = yMSG9Packet.getValue("104");
            YahooChatLobby yahooChatLobby = this.chatroomManager.getLobby(string);
            if (yahooChatLobby == null) {
                throw new NoSuchChatroomException("Chatroom/lobby " + string + " not found.");
            }
            YahooChatUser yahooChatUser = yahooChatLobby.getUser(yMSG9Packet.getValue("109"));
            if (yahooChatUser == null) {
                yahooChatUser = this.createChatUser(yMSG9Packet, 0);
            }
            SessionChatEvent sessionChatEvent = new SessionChatEvent((Object)this, yahooChatUser, yMSG9Packet.getValue("117"), yMSG9Packet.getValue("124"), yahooChatLobby);
            this.eventDispatchQueue.append(sessionChatEvent, ServiceType.CHATMSG);
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("chat message", yMSG9Packet, exception);
        }
    }

    protected void receiveChatPM(YMSG9Packet yMSG9Packet) {
        if (this.chatSessionStatus != SessionState.LOGGED_ON) {
            throw new IllegalStateException("Time out on chat login.");
        }
        try {
            SessionEvent sessionEvent = new SessionEvent(this, yMSG9Packet.getValue("5"), yMSG9Packet.getValue("4"), yMSG9Packet.getValue("14"));
            this.eventDispatchQueue.append(sessionEvent, ServiceType.MESSAGE);
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("chat PM", yMSG9Packet, exception);
        }
    }

    protected void receiveConfDecline(YMSG9Packet yMSG9Packet) {
        try {
            YahooConference yahooConference = this.getOrCreateConference(yMSG9Packet);
            SessionConferenceEvent sessionConferenceEvent = new SessionConferenceEvent(this, yMSG9Packet.getValue("1"), yMSG9Packet.getValue("54"), yMSG9Packet.getValue("14"), yahooConference, null);
            yahooConference.removeUser(sessionConferenceEvent.getFrom());
            if (!yahooConference.isClosed()) {
                this.eventDispatchQueue.append(sessionConferenceEvent, ServiceType.CONFDECLINE);
            }
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("conference decline", yMSG9Packet, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveConfLogoff(YMSG9Packet yMSG9Packet) {
        YahooConference yahooConference = this.getOrCreateConference(yMSG9Packet);
        Object object = yahooConference;
        synchronized (object) {
            if (!yahooConference.isInvited()) {
                yahooConference.addPacket(yMSG9Packet);
                return;
            }
        }
        try {
            object = new SessionConferenceEvent((Object)this, yMSG9Packet.getValue("1"), yMSG9Packet.getValue("56"), null, yahooConference);
            yahooConference.removeUser(((SessionEvent)object).getFrom());
            if (!yahooConference.isClosed()) {
                this.eventDispatchQueue.append((SessionEvent)object, ServiceType.CONFLOGOFF);
            }
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("conference logoff", yMSG9Packet, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveConfLogon(YMSG9Packet yMSG9Packet) {
        YahooConference yahooConference = this.getOrCreateConference(yMSG9Packet);
        Object object = yahooConference;
        synchronized (object) {
            if (!yahooConference.isInvited()) {
                yahooConference.addPacket(yMSG9Packet);
                return;
            }
        }
        try {
            object = new SessionConferenceEvent((Object)this, yMSG9Packet.getValue("1"), yMSG9Packet.getValue("53"), null, yahooConference);
            yahooConference.addUser(((SessionEvent)object).getFrom());
            if (!yahooConference.isClosed()) {
                this.eventDispatchQueue.append((SessionEvent)object, ServiceType.CONFLOGON);
            }
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("conference logon", yMSG9Packet, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveConfMsg(YMSG9Packet yMSG9Packet) {
        YahooConference yahooConference = this.getOrCreateConference(yMSG9Packet);
        Object object = yahooConference;
        synchronized (object) {
            if (!yahooConference.isInvited()) {
                yahooConference.addPacket(yMSG9Packet);
                return;
            }
        }
        try {
            object = new SessionConferenceEvent((Object)this, yMSG9Packet.getValue("1"), yMSG9Packet.getValue("3"), yMSG9Packet.getValue("14"), yahooConference);
            if (!yahooConference.isClosed()) {
                this.eventDispatchQueue.append((SessionEvent)object, ServiceType.CONFMSG);
            }
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("conference mesg", yMSG9Packet, exception);
        }
    }

    protected void receiveContactIgnore(YMSG9Packet yMSG9Packet) {
        try {
            String string = yMSG9Packet.getValue("0");
            boolean bl = yMSG9Packet.getValue("13").charAt(0) == '1';
            int n = Integer.parseInt(yMSG9Packet.getValue("66"));
            if (n == 0) {
                YahooUser yahooUser = this.userStore.getOrCreate(string);
                yahooUser.setIgnored(bl);
                SessionFriendEvent sessionFriendEvent = new SessionFriendEvent(this, 1);
                sessionFriendEvent.setUser(0, yahooUser);
                this.eventDispatchQueue.append(sessionFriendEvent, ServiceType.ISAWAY);
            } else {
                String string2 = "Contact ignore error: ";
                switch (n) {
                    case 2: {
                        string2 = string2 + "Already on ignore list";
                        break;
                    }
                    case 3: {
                        string2 = string2 + "Not currently ignored";
                        break;
                    }
                    case 12: {
                        string2 = string2 + "Cannot ignore friend";
                        break;
                    }
                    default: {
                        string2 = string2 + "Unknown error";
                    }
                }
                this.errorMessage(yMSG9Packet, string2);
            }
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("contact ignore", yMSG9Packet, exception);
        }
    }

    protected void receiveContactNew(YMSG9Packet yMSG9Packet) {
        try {
            if (yMSG9Packet.length <= 0) {
                return;
            }
            if (yMSG9Packet.exists("7")) {
                this.updateFriendsStatus(yMSG9Packet);
                return;
            }
            if (yMSG9Packet.status == 7L) {
                SessionEvent sessionEvent = new SessionEvent(this, null, yMSG9Packet.getValue("3"), yMSG9Packet.getValue("14"));
                this.eventDispatchQueue.append(sessionEvent, ServiceType.CONTACTREJECT);
            } else {
                SessionEvent sessionEvent;
                String string = yMSG9Packet.getValue("1");
                String string2 = yMSG9Packet.getValue("3");
                String string3 = yMSG9Packet.getValue("14");
                String string4 = yMSG9Packet.getValue("15");
                if (string4 == null || string4.length() == 0) {
                    sessionEvent = new SessionEvent(this, string, string2, string3);
                } else {
                    long l = 1000L * Long.parseLong(string4);
                    sessionEvent = new SessionEvent(this, string, string2, string3, l);
                }
                sessionEvent.setStatus(yMSG9Packet.status);
                this.eventDispatchQueue.append(sessionEvent, ServiceType.CONTACTNEW);
            }
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("contact request", yMSG9Packet, exception);
        }
    }

    protected void receiveFileTransfer(YMSG9Packet yMSG9Packet) {
        try {
            String string = yMSG9Packet.getValue("5");
            String string2 = yMSG9Packet.getValue("4");
            String string3 = yMSG9Packet.getValue("14");
            if (!yMSG9Packet.exists("38")) {
                SessionEvent sessionEvent = new SessionEvent(this, string, string2, string3);
                this.eventDispatchQueue.append(sessionEvent, ServiceType.MESSAGE);
            } else {
                String string4 = yMSG9Packet.getValue("38");
                String string5 = yMSG9Packet.getValue("20");
                SessionFileTransferEvent sessionFileTransferEvent = new SessionFileTransferEvent(this, string, string2, string3, Long.valueOf(string4), string5);
                this.eventDispatchQueue.append(sessionFileTransferEvent, ServiceType.FILETRANSFER);
            }
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("file transfer", yMSG9Packet, exception);
        }
    }

    protected void receiveFriendAdd(YMSG9Packet yMSG9Packet) {
        try {
            String string = yMSG9Packet.getValue("7");
            String string2 = yMSG9Packet.getValue("65");
            YahooUser yahooUser = this.userStore.getOrCreate(string);
            this.insertFriend(yahooUser, string2);
            SessionFriendEvent sessionFriendEvent = new SessionFriendEvent(this, yahooUser, string2);
            this.eventDispatchQueue.append(sessionFriendEvent, ServiceType.FRIENDADD);
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("friend added", yMSG9Packet, exception);
        }
    }

    protected void receiveFriendRemove(YMSG9Packet yMSG9Packet) {
        try {
            String string = yMSG9Packet.getValue("7");
            String string2 = yMSG9Packet.getValue("65");
            YahooUser yahooUser = this.userStore.get(string);
            if (yahooUser == null) {
                return;
            }
            this.deleteFriend(yahooUser, string2);
            SessionFriendEvent sessionFriendEvent = new SessionFriendEvent(this, yahooUser, string2);
            this.eventDispatchQueue.append(sessionFriendEvent, ServiceType.FRIENDREMOVE);
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("friend removed", yMSG9Packet, exception);
        }
    }

    protected void receiveGroupRename(YMSG9Packet yMSG9Packet) {
        try {
            String string = yMSG9Packet.getValue("67");
            String string2 = yMSG9Packet.getValue("65");
            if (string == null || string2 == null) {
                return;
            }
            SessionGroupEvent sessionGroupEvent = new SessionGroupEvent(this, string, string2);
            this.eventDispatchQueue.append(sessionGroupEvent, ServiceType.GOTGROUPRENAME);
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("group rename", yMSG9Packet, exception);
        }
    }

    protected void receiveIdAct(YMSG9Packet yMSG9Packet) {
    }

    protected void receiveIdDeact(YMSG9Packet yMSG9Packet) {
    }

    protected void receiveStatusUpdate(YMSG9Packet yMSG9Packet) {
        this.updateFriendsStatus(yMSG9Packet);
    }

    protected void receiveIsAway(YMSG9Packet yMSG9Packet) {
        if (yMSG9Packet.exists("7")) {
            this.updateFriendsStatus(yMSG9Packet);
        }
    }

    protected void receiveIsBack(YMSG9Packet yMSG9Packet) {
        if (yMSG9Packet.exists("7")) {
            this.updateFriendsStatus(yMSG9Packet);
        }
    }

    protected void receiveList(YMSG9Packet yMSG9Packet) {
        String[] stringArray = new String[]{"87", "88", "89"};
        if (this.cachePacket == null) {
            this.cachePacket = yMSG9Packet;
        } else {
            this.cachePacket.merge(yMSG9Packet, stringArray);
        }
        if (yMSG9Packet.exists("59")) {
            this._receiveList(this.cachePacket);
        }
    }

    private void _receiveList(YMSG9Packet yMSG9Packet) {
        Object object;
        StringTokenizer stringTokenizer;
        Object object2;
        try {
            object2 = yMSG9Packet.getValue("87");
            if (object2 != null) {
                stringTokenizer = new StringTokenizer((String)object2, "\n");
                while (stringTokenizer.hasMoreTokens()) {
                    object = stringTokenizer.nextToken();
                    YahooGroup yahooGroup = new YahooGroup(((String)object).substring(0, ((String)object).indexOf(":")));
                    StringTokenizer stringTokenizer2 = new StringTokenizer(((String)object).substring(((String)object).indexOf(":") + 1), ",");
                    while (stringTokenizer2.hasMoreTokens()) {
                        String string = stringTokenizer2.nextToken();
                        YahooUser yahooUser = this.userStore.getOrCreate(string);
                        yahooGroup.addUser(yahooUser);
                        yahooUser.adjustGroupCount(1);
                    }
                    this.groups.add(yahooGroup);
                }
            }
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("friends list in list", yMSG9Packet, exception);
        }
        try {
            object2 = yMSG9Packet.getValue("88");
            if (object2 != null) {
                stringTokenizer = new StringTokenizer((String)object2, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    object2 = stringTokenizer.nextToken();
                    object = this.userStore.getOrCreate((String)object2);
                    ((YahooUser)object).setIgnored(true);
                }
            }
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("ignored list in list", yMSG9Packet, exception);
        }
        try {
            object2 = yMSG9Packet.getValue("89");
            if (object2 != null) {
                stringTokenizer = new StringTokenizer((String)object2, ",");
                this.identities.clear();
                while (stringTokenizer.hasMoreTokens()) {
                    object = stringTokenizer.nextToken();
                    this.identities.put((String)object, new YahooIdentity((String)object));
                }
            }
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("identities list in list", yMSG9Packet, exception);
        }
        try {
            object2 = yMSG9Packet.getValue("185");
            if (object2 != null) {
                stringTokenizer = new StringTokenizer((String)object2, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    object2 = stringTokenizer.nextToken();
                    object = this.userStore.getOrCreate((String)object2);
                    ((YahooUser)object).setStealthBlocked(true);
                }
            }
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("ignored list in list", yMSG9Packet, exception);
        }
        try {
            object2 = ConnectionHandler.extractCookies(yMSG9Packet);
            this.cookieY = object2[0];
            this.cookieT = object2[1];
            this.cookieC = object2[2];
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("cookies in list", yMSG9Packet, exception);
        }
        try {
            this.primaryID = yMSG9Packet.exists("3") ? new YahooIdentity(yMSG9Packet.getValue("3").trim()) : this.loginID;
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("primary identity in list", yMSG9Packet, exception);
        }
        this.primaryID.setPrimaryIdentity(true);
        this.loginID.setLoginIdentity(true);
        this.eventDispatchQueue.append(new SessionEvent(this), ServiceType.LIST);
    }

    protected void receiveLogoff(YMSG9Packet yMSG9Packet) {
        if (!yMSG9Packet.exists("7")) {
            this.sessionStatus = SessionState.UNSTARTED;
            this.ipThread.stopMe();
        } else {
            try {
                this.updateFriendsStatus(yMSG9Packet);
            }
            catch (Exception exception) {
                throw new YMSG9BadFormatException("online friends in logoff", yMSG9Packet, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveLogon(YMSG9Packet yMSG9Packet) throws IOException {
        block7: {
            if (this.sessionStatus != SessionState.CONNECTED) {
                throw new IllegalStateException("I received a LOGON packet outside of the logging in proces. Don't know how to interpret this.");
            }
            try {
                if (!yMSG9Packet.exists("7")) break block7;
                try {
                    this.updateFriendsStatus(yMSG9Packet);
                }
                catch (Exception exception) {
                    throw new YMSG9BadFormatException("online friends in logon", yMSG9Packet, exception);
                }
            }
            finally {
                if (this.sessionStatus != SessionState.LOGGED_ON) {
                    this.setStatus(this.status);
                    this.sessionStatus = SessionState.LOGGED_ON;
                }
            }
        }
    }

    protected void receiveMessage(YMSG9Packet yMSG9Packet) {
        try {
            if (!yMSG9Packet.exists("14")) {
                return;
            }
            if (yMSG9Packet.status == Status.NOTINOFFICE.getValue()) {
                int n = 0;
                while (yMSG9Packet.getNthValue("31", n) != null) {
                    SessionEvent sessionEvent;
                    String string = yMSG9Packet.getNthValue("5", n);
                    String string2 = yMSG9Packet.getNthValue("4", n);
                    String string3 = yMSG9Packet.getNthValue("14", n);
                    String string4 = yMSG9Packet.getNthValue("15", n);
                    if (string4 == null || string4.length() == 0) {
                        sessionEvent = new SessionEvent(this, string, string2, string3);
                    } else {
                        long l = 1000L * Long.parseLong(string4);
                        sessionEvent = new SessionEvent(this, string, string2, string3, l);
                    }
                    sessionEvent.setStatus(yMSG9Packet.status);
                    this.eventDispatchQueue.append(sessionEvent, ServiceType.X_OFFLINE);
                    ++n;
                }
            } else {
                String string;
                String string5;
                String string6 = yMSG9Packet.getValue("5");
                SessionEvent sessionEvent = new SessionEvent(this, string6, string5 = yMSG9Packet.getValue("4"), string = yMSG9Packet.getValue("14"));
                if (sessionEvent.getMessage().equalsIgnoreCase("<ding>")) {
                    this.eventDispatchQueue.append(sessionEvent, ServiceType.X_BUZZ);
                } else {
                    this.eventDispatchQueue.append(sessionEvent, ServiceType.MESSAGE);
                }
            }
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("message", yMSG9Packet, exception);
        }
    }

    protected void receiveNewMail(YMSG9Packet yMSG9Packet) {
        try {
            SessionNewMailEvent sessionNewMailEvent = !yMSG9Packet.exists("43") ? new SessionNewMailEvent(this, yMSG9Packet.getValue("9")) : new SessionNewMailEvent(this, yMSG9Packet.getValue("43"), yMSG9Packet.getValue("42"), yMSG9Packet.getValue("18"));
            this.eventDispatchQueue.append(sessionNewMailEvent, ServiceType.NEWMAIL);
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("new mail", yMSG9Packet, exception);
        }
    }

    protected void receiveNotify(YMSG9Packet yMSG9Packet) {
        try {
            if (yMSG9Packet.status == 1L) {
                SessionNotifyEvent sessionNotifyEvent = new SessionNotifyEvent(this, yMSG9Packet.getValue("5"), yMSG9Packet.getValue("4"), yMSG9Packet.getValue("14"), yMSG9Packet.getValue("49"), yMSG9Packet.getValue("13"));
                sessionNotifyEvent.setStatus(yMSG9Packet.status);
                this.eventDispatchQueue.append(sessionNotifyEvent, ServiceType.NOTIFY);
            }
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("notify", yMSG9Packet, exception);
        }
    }

    protected void receiveUserStat(YMSG9Packet yMSG9Packet) {
        this.status = Status.getStatus(yMSG9Packet.status);
    }

    protected void erroneousChatLogin(YMSG9Packet yMSG9Packet) {
        this.chatSessionStatus = SessionState.FAILED;
    }

    protected void sendPacket(PacketBodyBuffer packetBodyBuffer, ServiceType serviceType, Status status) throws IOException {
        this.network.sendPacket(packetBodyBuffer, serviceType, status.getValue(), this.sessionId);
    }

    protected void sendPacket(PacketBodyBuffer packetBodyBuffer, ServiceType serviceType) throws IOException {
        this.sendPacket(packetBodyBuffer, serviceType, Status.AVAILABLE);
    }

    private boolean past(long l) {
        return System.currentTimeMillis() > l;
    }

    private void openSession() throws IOException {
        this.network.open();
        this.ipThread = new InputThread(this);
        this.ipThread.start();
        this.pingerFuture = SCHEDULED_PINGER_SERVICE.scheduleAtFixedRate(new SessionPinger(this), 1200L, 1200L, TimeUnit.SECONDS);
    }

    void closeSession() throws IOException {
        if (this.ipThread != null && Thread.currentThread() != this.ipThread) {
            this.ipThread.stopMe();
            this.ipThread.interrupt();
            this.ipThread = null;
        }
        if (this.pingerFuture != null) {
            this.pingerFuture.cancel(false);
            this.pingerFuture = null;
        }
        this.eventDispatchQueue.kill();
        this.network.close();
    }

    private void checkStatus() throws IllegalStateException {
        if (this.sessionStatus != SessionState.LOGGED_ON) {
            throw new IllegalStateException("Not logged in");
        }
    }

    private void checkChatStatus() throws IllegalStateException {
        if (this.chatSessionStatus != SessionState.LOGGED_ON) {
            throw new IllegalStateException("Not logged in to a chatroom");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetData() {
        this.primaryID = null;
        this.loginID = null;
        this.password = null;
        this.cookieY = null;
        this.cookieT = null;
        this.cookieC = null;
        this.imvironment = null;
        this.customStatusMessage = null;
        this.customStatusBusy = false;
        this.conferences.clear();
        this.groups.clear();
        this.identities.clear();
        Hashtable<String, TypingNotifier> hashtable = this.typingNotifiers;
        synchronized (hashtable) {
            for (TypingNotifier typingNotifier : this.typingNotifiers.values()) {
                typingNotifier.quit = true;
                typingNotifier.interrupt();
            }
            this.typingNotifiers.clear();
        }
        this.loginException = null;
    }

    void errorMessage(YMSG9Packet yMSG9Packet, String string) {
        if (string == null) {
            string = yMSG9Packet.getValue("16");
        }
        SessionErrorEvent sessionErrorEvent = new SessionErrorEvent(this, string, yMSG9Packet.service);
        if (yMSG9Packet.exists("114")) {
            sessionErrorEvent.setCode(Integer.parseInt(yMSG9Packet.getValue("114").trim()));
        }
        this.eventDispatchQueue.append(sessionErrorEvent, ServiceType.X_ERROR);
    }

    void sendExceptionEvent(Exception exception, String string) {
        SessionExceptionEvent sessionExceptionEvent = new SessionExceptionEvent(this, string, exception);
        this.eventDispatchQueue.append(sessionExceptionEvent, ServiceType.X_EXCEPTION);
    }

    private YMSG9Packet compoundChatLoginPacket(YMSG9Packet yMSG9Packet) {
        if (yMSG9Packet.status != 5L && yMSG9Packet.status != 1L) {
            throw new IllegalArgumentException("Status must be either 1 or 5.");
        }
        if (yMSG9Packet.status == 5L) {
            if (this.cachePacket == null) {
                this.cachePacket = yMSG9Packet;
            } else {
                this.cachePacket.append(yMSG9Packet);
            }
            return null;
        }
        if (this.cachePacket != null) {
            this.cachePacket.append(yMSG9Packet);
            yMSG9Packet = this.cachePacket;
            this.cachePacket = null;
        }
        return yMSG9Packet;
    }

    private void updateFriendsStatus(YMSG9Packet yMSG9Packet) {
        boolean bl;
        String string = yMSG9Packet.getValue("8");
        if (string == null && yMSG9Packet.getValue("7") != null) {
            string = "1";
        }
        boolean bl2 = bl = yMSG9Packet.service == ServiceType.LOGOFF;
        if (string != null) {
            int n = Integer.parseInt(string);
            SessionFriendEvent sessionFriendEvent = new SessionFriendEvent(this, n);
            for (int i = 0; i < n; ++i) {
                Status status;
                YahooUser yahooUser = this.userStore.get(yMSG9Packet.getNthValue("7", i));
                if (yahooUser == null) {
                    String string2 = yMSG9Packet.getNthValue("7", i);
                    yahooUser = this.userStore.getOrCreate(string2);
                }
                long l = Long.parseLong(yMSG9Packet.getNthValue("10", i));
                String string3 = yMSG9Packet.getNthValue("7", i);
                Status status2 = status = bl ? Status.OFFLINE : Status.getStatus(l);
                if (yMSG9Packet.exists("17")) {
                    boolean bl3 = yMSG9Packet.getNthValue("17", i).equals("1");
                    boolean bl4 = yMSG9Packet.getNthValue("13", i).equals("1");
                    yahooUser.update(string3, status, bl3, bl4);
                } else {
                    String string4 = yMSG9Packet.getNthValue("13", i);
                    yahooUser.update(string3, status, string4);
                }
                if (yMSG9Packet.getNthValue("19", i) != null && yMSG9Packet.getNthValue("47", i) != null) {
                    yahooUser.setCustom(yMSG9Packet.getNthValue("19", i), yMSG9Packet.getNthValue("47", i));
                }
                if ((string = yMSG9Packet.getNthValue("138", i)) != null) {
                    yahooUser.setIdleTime("-1");
                }
                if ((string = yMSG9Packet.getNthValue("137", i)) != null) {
                    yahooUser.setIdleTime(string);
                }
                sessionFriendEvent.setUser(i, yahooUser);
            }
            this.eventDispatchQueue.append(sessionFriendEvent, ServiceType.ISAWAY);
        }
    }

    private void insertFriend(YahooUser yahooUser, String string) {
        YahooGroup yahooGroup = null;
        for (YahooGroup yahooGroup2 : this.groups) {
            if (!yahooGroup2.getName().equalsIgnoreCase(string)) continue;
            yahooGroup = yahooGroup2;
            break;
        }
        if (yahooGroup == null) {
            yahooGroup = new YahooGroup(string);
            this.groups.add(yahooGroup);
        }
        if (!yahooGroup.contains(yahooUser)) {
            yahooGroup.addUser(yahooUser);
            yahooUser.adjustGroupCount(1);
        }
    }

    private void deleteFriend(YahooUser yahooUser, String string) {
        for (YahooGroup yahooGroup : this.groups) {
            if (!yahooGroup.getName().equalsIgnoreCase(string)) continue;
            yahooGroup.removeUser(yahooUser);
            yahooUser.adjustGroupCount(-1);
            if (!yahooGroup.isEmpty()) break;
            this.groups.remove(yahooGroup);
            break;
        }
    }

    private YahooChatUser createChatUser(YMSG9Packet yMSG9Packet, int n) {
        yMSG9Packet.generateQuickSetAccessors("109");
        YahooUser yahooUser = this.userStore.getOrCreate(yMSG9Packet.getNthValue("109", n));
        int n2 = Integer.parseInt(yMSG9Packet.getValueFromNthSetQA("113", n));
        String string = yMSG9Packet.getValueFromNthSetQA("141", n);
        int n3 = Integer.parseInt(yMSG9Packet.getValueFromNthSetQA("110", n));
        String string2 = yMSG9Packet.getValueFromNthSetQA("142", n);
        return new YahooChatUser(yahooUser, n2, string, n3, string2);
    }

    private String getConferenceName(String string) {
        return string + "-" + this.conferenceCount++;
    }

    private YahooConference getConference(String string) throws NoSuchConferenceException {
        YahooConference yahooConference = this.conferences.get(string);
        if (yahooConference == null) {
            throw new NoSuchConferenceException("Conference " + string + " not found.");
        }
        return yahooConference;
    }

    YahooConference getOrCreateConference(YMSG9Packet yMSG9Packet) {
        String string = yMSG9Packet.getValue("57");
        YahooIdentity yahooIdentity = this.identities.get(yMSG9Packet.getValue("1"));
        YahooConference yahooConference = this.conferences.get(string);
        if (yahooConference == null) {
            yahooConference = new YahooConference(this.userStore, yahooIdentity, string, this);
            this.conferences.put(string, yahooConference);
        }
        return yahooConference;
    }

    void fire(SessionEvent sessionEvent, ServiceType serviceType) {
        if (sessionEvent == null) {
            throw new IllegalArgumentException("Argument 'event' cannot be null.");
        }
        if (serviceType == null) {
            throw new IllegalArgumentException("Argument 'type' cannot be null.");
        }
        this.eventDispatchQueue.append(sessionEvent, serviceType);
    }

    private class TypingNotifier
    extends KeyAdapter
    implements Runnable {
        public volatile boolean quit = false;
        private volatile long lastKey;
        private volatile int timeout = 30000;
        private volatile boolean typing = false;
        private Thread thread;
        private volatile Component typeSource;
        private volatile String target;
        private volatile String identity;

        public TypingNotifier(Component component, String string, String string2) {
            this.typeSource = component;
            this.target = string;
            this.identity = string2;
            if (this.typeSource != null) {
                this.typeSource.addKeyListener(this);
            }
            this.thread = new Thread((Runnable)this, "Typing Notification: " + string2 + "->" + string);
            this.thread.setPriority(1);
            this.thread.start();
        }

        public void keyTyped(KeyEvent keyEvent) {
            this.keyTyped();
        }

        void keyTyped() {
            if (!this.thread.isAlive() || Session.this.sessionStatus != SessionState.LOGGED_ON) {
                return;
            }
            this.lastKey = System.currentTimeMillis();
            if (!this.typing) {
                try {
                    Session.this.transmitNotify(this.target, this.identity, true, " ", "TYPING");
                }
                catch (IOException iOException) {
                    Session.this.sendExceptionEvent(iOException, "Source: TypingNotifier");
                    this.quit = true;
                }
            }
            this.typing = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (!this.quit) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (Session.this.sessionStatus != SessionState.LOGGED_ON || !this.typing || System.currentTimeMillis() - this.lastKey <= (long)this.timeout) continue;
                    try {
                        Session.this.transmitNotify(this.target, this.identity, false, " ", "TYPING");
                    }
                    catch (IOException iOException) {
                        Session.this.sendExceptionEvent(iOException, "Source: TypingNotifier");
                        this.quit = true;
                    }
                    this.typing = false;
                }
            }
            finally {
                if (this.typeSource != null) {
                    this.typeSource.removeKeyListener(this);
                }
            }
        }

        public void interrupt() {
            this.thread.interrupt();
        }

        public void stopTyping() {
            if (this.typing) {
                try {
                    Session.this.transmitNotify(this.target, this.identity, false, " ", "TYPING");
                }
                catch (IOException iOException) {
                    Session.this.sendExceptionEvent(iOException, "Source: TypingNotifier");
                    this.quit = true;
                }
                this.typing = false;
            }
        }
    }
}

