/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.flap;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.SeqNum;
import net.kano.joscar.flap.FlapCommand;
import net.kano.joscar.flap.FlapCommandFactory;
import net.kano.joscar.flap.FlapHeader;
import net.kano.joscar.flap.FlapPacket;
import net.kano.joscar.flap.FlapPacketEvent;
import net.kano.joscar.flap.FlapPacketListener;
import net.kano.joscar.flap.FlapProcessor;
import net.kano.joscar.flap.VetoableFlapPacketListener;
import net.kano.joscar.logging.Logger;
import net.kano.joscar.logging.LoggingSystem;
import net.kano.joscar.net.ConnProcessorExceptionEvent;
import net.kano.joscar.net.ConnProcessorImpl;

public abstract class AbstractFlapProcessor
extends ConnProcessorImpl
implements FlapProcessor {
    private static final Logger logger = LoggingSystem.getLogger("net.kano.joscar.flap");
    private static final int SEQNUM_MAX = 65535;
    private final CopyOnWriteArrayList<FlapPacketListener> packetListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<VetoableFlapPacketListener> vetoablePacketListeners = new CopyOnWriteArrayList();
    private final Object writeLock = new Object();
    private final Object readLock = new Object();
    private SeqNum seqNum = new SeqNum(0L, 65535L);
    private FlapCommandFactory commandFactory = null;

    public AbstractFlapProcessor() {
    }

    public AbstractFlapProcessor(Socket socket) throws IOException {
        this.attachToSocket(socket);
    }

    public final void addVetoablePacketListener(VetoableFlapPacketListener listener) {
        DefensiveTools.checkNull((Object)listener, (String)"listener");
        this.vetoablePacketListeners.addIfAbsent((Object)listener);
    }

    public final void removeVetoablePacketListener(VetoableFlapPacketListener listener) {
        DefensiveTools.checkNull((Object)listener, (String)"listener");
        this.vetoablePacketListeners.remove((Object)listener);
    }

    public final void addPacketListener(FlapPacketListener listener) {
        DefensiveTools.checkNull((Object)listener, (String)"listener");
        this.packetListeners.addIfAbsent((Object)listener);
    }

    public final void removePacketListener(FlapPacketListener listener) {
        DefensiveTools.checkNull((Object)listener, (String)"listener");
        this.packetListeners.remove((Object)listener);
    }

    public final synchronized void setFlapCmdFactory(FlapCommandFactory factory) {
        this.commandFactory = factory;
    }

    protected abstract void handlePacket(FlapPacket var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processPacketSynchronously(FlapPacket packet) {
        FlapCommandFactory factory;
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        boolean logFine = logger.logFineEnabled();
        boolean logFiner = logger.logFinerEnabled();
        if (logFine) {
            logger.logFine("FlapProcessor received packet: " + packet);
        }
        AbstractFlapProcessor abstractFlapProcessor = this;
        synchronized (abstractFlapProcessor) {
            factory = this.commandFactory;
        }
        FlapCommand cmd = null;
        if (factory != null) {
            try {
                cmd = factory.genFlapCommand(packet);
            }
            catch (Throwable t) {
                this.handleException(ConnProcessorExceptionEvent.ERRTYPE_CMD_GEN, t, packet);
            }
        }
        if (logFine) {
            logger.logFine("Flap command for " + packet + ": " + cmd);
        }
        FlapPacketEvent event = new FlapPacketEvent(this, packet, cmd);
        for (Object listener : this.vetoablePacketListeners) {
            VetoableFlapPacketListener.VetoResult result;
            if (logFiner) {
                logger.logFiner("Running vetoable flap packet listener: " + listener);
            }
            try {
                result = listener.handlePacket(event);
            }
            catch (Throwable t) {
                this.handleException(ConnProcessorExceptionEvent.ERRTYPE_PACKET_LISTENER, t, listener);
                continue;
            }
            if (result == VetoableFlapPacketListener.VetoResult.CONTINUE_PROCESSING) continue;
            if (logFiner) {
                logger.logFiner("Flap packet listener vetoed further processing: " + listener);
            }
            return;
        }
        for (Object listener : this.packetListeners) {
            if (logFiner) {
                logger.logFiner("Running Flap packet listener " + listener);
            }
            try {
                listener.handleFlapPacket(event);
            }
            catch (Throwable t) {
                this.handleException(ConnProcessorExceptionEvent.ERRTYPE_PACKET_LISTENER, t, listener);
            }
        }
        if (logFiner) {
            logger.logFiner("Finished handling Flap packet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendFlap(FlapCommand command) {
        DefensiveTools.checkNull((Object)command, (String)"command");
        boolean logFine = logger.logFineEnabled();
        boolean logFiner = logger.logFinerEnabled();
        OutputStream out = this.getOutputStream();
        if (out == null) {
            return;
        }
        if (logFiner) {
            logger.logFiner("Sending Flap command " + command);
        }
        Object object = this.writeLock;
        synchronized (object) {
            ByteBlock block;
            int seq = (int)this.seqNum.next();
            FlapPacket packet = new FlapPacket(seq, command);
            try {
                block = ByteBlock.createByteBlock((LiveWritable)packet);
            }
            catch (Throwable t) {
                this.handleException(ConnProcessorExceptionEvent.ERRTYPE_CMD_WRITE, t, command);
                return;
            }
            if (logFine) {
                logger.logFine("Sending Flap packet " + packet + ": " + block.getLength() + " total bytes");
            }
            try {
                block.write(out);
            }
            catch (IOException e) {
                this.handleException(ConnProcessorExceptionEvent.ERRTYPE_CONNECTION_ERROR, e);
                return;
            }
        }
        if (logFiner) {
            logger.logFiner("Finished sending Flap command");
        }
    }

    public final void runFlapLoop() throws IOException {
        while (this.readNextFlap()) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean readNextFlap() throws IOException {
        boolean logFiner = logger.logFinerEnabled();
        InputStream inputStream = this.getInputStream();
        if (inputStream == null) {
            return false;
        }
        Object object = this.readLock;
        synchronized (object) {
            FlapHeader header = FlapHeader.readFLAPHeader(inputStream);
            if (logFiner) {
                logger.logFiner("Read flap header " + header);
            }
            if (header == null) {
                return false;
            }
            FlapPacket packet = FlapPacket.readRestOfFlap(header, inputStream);
            if (logFiner) {
                logger.logFiner("Read flap packet " + packet);
            }
            if (packet == null) {
                return false;
            }
            this.handlePacket(packet);
            return true;
        }
    }

    public void breakdown() {
        this.detach();
        this.packetListeners.clear();
        this.vetoablePacketListeners.clear();
    }

    public String toString() {
        return "FlapProcessor: seqNum=" + this.seqNum;
    }
}

