/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.ft;

import java.util.logging.Logger;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.ConnectionType;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.IncomingRvConnection;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.NextStateControllerInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnectionImpl;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnectionState;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvSessionConnectionInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.AbstractConnectionController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.ConnectToProxyForIncomingController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.OutgoingConnectionController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.RedirectConnectionController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.RedirectToProxyController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.StateController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.ConnectionFailedEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.RvConnectionEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.UnknownErrorEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.FailureEventInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.StateInfo;
import net.kano.joustsim.oscar.proxy.AimProxyInfo;

public abstract class IncomingRvConnectionImpl
extends RvConnectionImpl
implements IncomingRvConnection {
    private static final Logger LOGGER = Logger.getLogger(IncomingRvConnectionImpl.class.getName());
    private boolean accepted = false;
    private boolean rejected = false;
    private boolean alwaysRedirect = false;

    public IncomingRvConnectionImpl(Screenname screenname, RvSessionConnectionInfo rvsessioninfo) {
        this(AimProxyInfo.forNoProxy(), screenname, rvsessioninfo);
    }

    public IncomingRvConnectionImpl(AimProxyInfo proxy, Screenname screenname, RvSessionConnectionInfo rvsessioninfo) {
        super(proxy, screenname, rvsessioninfo);
    }

    public synchronized boolean isAccepted() {
        return this.accepted;
    }

    public synchronized boolean isRejected() {
        return this.rejected;
    }

    public synchronized boolean isAlwaysRedirectEnabled() {
        return this.alwaysRedirect;
    }

    public synchronized void setAlwaysRedirect(boolean alwaysRedirect) {
        this.alwaysRedirect = alwaysRedirect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept() throws IllegalStateException {
        AbstractConnectionController controller;
        IncomingRvConnectionImpl incomingRvConnectionImpl = this;
        synchronized (incomingRvConnectionImpl) {
            if (this.rejected) {
                throw new IllegalStateException("Transfer was already rejected");
            }
            if (this.accepted) {
                return;
            }
            this.accepted = true;
            boolean onlyUsingProxy = this.getSettings().isOnlyUsingProxy();
            boolean proxied = this.getRvSessionInfo().getConnectionInfo().isProxied();
            controller = !proxied && !this.isAlwaysRedirectEnabled() && !onlyUsingProxy ? new OutgoingConnectionController(ConnectionType.LAN) : (proxied && this.getSettings().isProxyRequestTrusted() ? new ConnectToProxyForIncomingController() : (!onlyUsingProxy ? new RedirectConnectionController() : new RedirectToProxyController()));
        }
        if (this.startStateController(controller)) {
            LOGGER.fine("Sending accept command to " + this.getBuddyScreenname());
            this.getRvSessionInfo().getRequestMaker().sendRvAccept();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reject() throws IllegalStateException {
        IncomingRvConnectionImpl incomingRvConnectionImpl = this;
        synchronized (incomingRvConnectionImpl) {
            if (this.accepted) {
                throw new IllegalStateException("transfer was already accepted");
            }
            if (this.rejected) {
                return;
            }
            this.rejected = true;
        }
        this.close();
    }

    protected boolean isSomeConnectionController(StateController controller) {
        return IncomingRvConnectionImpl.isLanController(controller) || IncomingRvConnectionImpl.isInternetController(controller) || controller instanceof RedirectConnectionController || controller instanceof RedirectToProxyController || controller instanceof ConnectToProxyForIncomingController;
    }

    protected synchronized NextStateControllerInfo getNextControllerFromError(StateController oldController, StateInfo oldState) {
        RvConnectionEvent event;
        if (oldState instanceof FailureEventInfo) {
            FailureEventInfo failureEventInfo = (FailureEventInfo)oldState;
            event = failureEventInfo.getEvent();
        } else {
            event = new UnknownErrorEvent();
        }
        if (oldController instanceof OutgoingConnectionController) {
            OutgoingConnectionController outController = (OutgoingConnectionController)oldController;
            if (outController.getTimeoutType() == ConnectionType.LAN) {
                return new NextStateControllerInfo(new OutgoingConnectionController(ConnectionType.INTERNET));
            }
            return new NextStateControllerInfo(new ConnectToProxyForIncomingController());
        }
        if (oldController instanceof ConnectToProxyForIncomingController) {
            return new NextStateControllerInfo(new RedirectConnectionController());
        }
        if (oldController instanceof RedirectConnectionController) {
            return new NextStateControllerInfo(new RedirectToProxyController());
        }
        if (oldController instanceof RedirectToProxyController) {
            NextStateControllerInfo next = this.tryRetry(oldController, event, new RedirectToProxyController());
            if (next != null) {
                return next;
            }
            return new NextStateControllerInfo(RvConnectionState.FAILED, (RvConnectionEvent)new ConnectionFailedEvent(event));
        }
        return this.getNextControllerFromUnknownError(oldController, oldState, event);
    }

    protected abstract NextStateControllerInfo getNextControllerFromUnknownError(StateController var1, StateInfo var2, RvConnectionEvent var3);

    public boolean isOpen() {
        return this.isAccepted() && super.isOpen();
    }
}

