/*
 * Decompiled with CFR 0.152.
 */
package org.xmpp.jnodes.jingle;

import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;
import org.xmpp.jnodes.jingle.IncomingSessionListener;
import org.xmpp.jnodes.jingle.JingleIQ;
import org.xmpp.jnodes.jingle.JingleSession;
import org.xmpp.jnodes.jingle.MediaProvider;
import org.xmpp.jnodes.jingle.RawUdpTransportProvider;

public class JingleSessionManager
implements PacketListener {
    private final XMPPConnection connection;
    private final ConcurrentHashMap<String, JingleSession> sessions = new ConcurrentHashMap();
    private final ConcurrentHashMap<IncomingSessionListener, IncomingSessionListener> listeners = new ConcurrentHashMap();
    private final MediaProvider mediaProvider;
    private final RawUdpTransportProvider rawUdpTransportProvider;

    public JingleSessionManager(XMPPConnection connection, MediaProvider mediaProvider, RawUdpTransportProvider rawUdpTransportProvider) {
        this.connection = connection;
        this.mediaProvider = mediaProvider;
        this.rawUdpTransportProvider = rawUdpTransportProvider;
        connection.addPacketListener((PacketListener)this, new PacketFilter(){

            public boolean accept(Packet packet) {
                return packet instanceof JingleIQ;
            }
        });
    }

    public void addIncomingSessionListener(IncomingSessionListener incomingSessionListener) {
        this.listeners.put(incomingSessionListener, incomingSessionListener);
    }

    private String getID(JingleIQ iq) {
        return iq.getJingle().getInitiator() + iq.getJingle().getSid();
    }

    public void processPacket(Packet packet) {
        JingleIQ iq = (JingleIQ)packet;
        if ("session-initiate".equals(iq.getJingle().getAction())) {
            JingleSession js = new JingleSession(iq, false, this.mediaProvider, this.rawUdpTransportProvider, this.connection);
            this.sessions.put(this.getID(iq), js);
            for (IncomingSessionListener l : this.listeners.values()) {
                l.sessionReceived(js);
            }
        } else {
            JingleSession js = this.sessions.get(this.getID(iq));
            if (js != null) {
                js.processJingleIQ(iq);
            }
        }
    }
}

