/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.flapcmd;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flap.FlapCommand;
import net.kano.joscar.flap.FlapPacket;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.flapcmd.SnacPacket;

public class SnacFlapCmd
extends FlapCommand {
    public static final int CHANNEL_SNAC = 2;
    private final SnacPacket packet;

    public SnacFlapCmd(FlapPacket flapPacket) {
        super(2);
        DefensiveTools.checkNull(flapPacket, "flapPacket");
        ByteBlock byteBlock = flapPacket.getData();
        this.packet = SnacPacket.isValidSnacPacket(byteBlock) ? SnacPacket.readSnacPacket(byteBlock) : null;
    }

    public SnacFlapCmd(long l, SnacCommand snacCommand) {
        super(2);
        DefensiveTools.checkRange(l, "requestId", 0);
        this.packet = new SnacPacket(l, snacCommand);
    }

    public final SnacPacket getSnacPacket() {
        return this.packet;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        this.packet.write(outputStream);
    }

    public String toString() {
        return "SnacFlapCmd: packet=" + this.packet;
    }
}

