/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.conn.ConnCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class MigrationNotice
extends ConnCommand {
    private static final int TYPE_HOST = 5;
    private static final int TYPE_COOKIE = 6;
    private final int[] families;
    private final String host;
    private final ByteBlock cookie;

    protected MigrationNotice(SnacPacket snacPacket) {
        super(18);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        int n = BinaryTools.getUShort(byteBlock, 0);
        this.families = new int[n];
        for (int i = 0; i < this.families.length; ++i) {
            this.families[i] = BinaryTools.getUShort(byteBlock, 2 + i * 2);
        }
        ByteBlock byteBlock2 = byteBlock.subBlock(2 + n * 2);
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(byteBlock2);
        this.host = immutableTlvChain.getString(5);
        this.cookie = immutableTlvChain.getLastTlv(6).getData();
    }

    public MigrationNotice(String string, ByteBlock byteBlock, int[] nArray) {
        super(18);
        this.families = nArray == null ? null : (int[])nArray.clone();
        this.host = string;
        this.cookie = byteBlock;
    }

    public final String getHost() {
        return this.host;
    }

    public final ByteBlock getCookie() {
        return this.cookie;
    }

    public final int[] getFamilies() {
        return this.families == null ? null : (int[])this.families.clone();
    }

    public void writeData(OutputStream outputStream) throws IOException {
        int n = this.families == null ? 0 : this.families.length;
        BinaryTools.writeUShort(outputStream, n);
        if (this.families != null) {
            for (int n2 : this.families) {
                BinaryTools.writeUShort(outputStream, n2);
            }
        }
        if (this.host != null) {
            Tlv.getStringInstance(5, this.host).write(outputStream);
        }
        if (this.cookie != null) {
            new Tlv(6, this.cookie).write(outputStream);
        }
    }

    public String toString() {
        return "MigrationNotice for " + (this.families == null ? -1 : this.families.length) + " families to " + this.host + " (cookie length=" + this.cookie.getLength() + ")";
    }
}

