/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.login;

import java.util.logging.Logger;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flap.FlapCommand;
import net.kano.joscar.flap.FlapPacketEvent;
import net.kano.joscar.flapcmd.CloseFlapCmd;
import net.kano.joscar.flapcmd.FlapErrorCmd;
import net.kano.joscar.flapcmd.LoginFlapCmd;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.snac.SnacPacketEvent;
import net.kano.joscar.snaccmd.auth.AuthCommand;
import net.kano.joscar.snaccmd.auth.AuthRequest;
import net.kano.joscar.snaccmd.auth.AuthResponse;
import net.kano.joscar.snaccmd.auth.ClientVersionInfo;
import net.kano.joscar.snaccmd.auth.KeyRequest;
import net.kano.joscar.snaccmd.auth.KeyResponse;
import net.kano.joscar.snaccmd.auth.SecuridRequest;
import net.kano.joscar.snaccmd.auth.SecuridResponse;
import net.kano.joscar.snaccmd.conn.SnacFamilyInfo;
import net.kano.joscar.snaccmd.error.SnacError;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.oscar.LoginServiceListener;
import net.kano.joustsim.oscar.oscar.OscarConnection;
import net.kano.joustsim.oscar.oscar.loginstatus.AuthFailureInfo;
import net.kano.joustsim.oscar.oscar.loginstatus.ClosedEarlyFailureInfo;
import net.kano.joustsim.oscar.oscar.loginstatus.DisconnectedFailureInfo;
import net.kano.joustsim.oscar.oscar.loginstatus.FlapErrorFailureInfo;
import net.kano.joustsim.oscar.oscar.loginstatus.LoginFailureInfo;
import net.kano.joustsim.oscar.oscar.loginstatus.LoginSuccessInfo;
import net.kano.joustsim.oscar.oscar.loginstatus.NoSecuridFailure;
import net.kano.joustsim.oscar.oscar.loginstatus.SnacErrorFailureInfo;
import net.kano.joustsim.oscar.oscar.loginstatus.TimeoutFailureInfo;
import net.kano.joustsim.oscar.oscar.service.Service;
import net.kano.joustsim.oscar.oscar.service.login.SecuridProvider;
import org.jetbrains.annotations.Nullable;

public class LoginService
extends Service {
    private static final Logger logger = Logger.getLogger(LoginService.class.getName());
    public static final ClientVersionInfo VERSIONINFO_WINAIM = new ClientVersionInfo("AOL Instant Messenger, version 5.5.3415/WIN32", -1, 5, 5, 0, 3415, 239L);
    public static final ClientVersionInfo VERSIONINFO_ICHAT = new ClientVersionInfo("Apple iChat", 12570, 1, 0, 0, 388, 198L);
    private final Screenname screenname;
    private final String password;
    private ClientVersionInfo versionInfo = VERSIONINFO_ICHAT;
    private CopyOnWriteArrayList<LoginServiceListener> listeners = new CopyOnWriteArrayList();
    private boolean notified = false;
    @Nullable
    private volatile SecuridProvider securidProvider = null;
    @Nullable
    private volatile Thread securidThread = null;

    public LoginService(AimConnection aimConnection, OscarConnection oscarConnection, Screenname screenname, String password) {
        super(aimConnection, oscarConnection, 23);
        DefensiveTools.checkNull((Object)screenname, (String)"screenname");
        DefensiveTools.checkNull((Object)password, (String)"password");
        this.screenname = screenname;
        this.password = password;
        this.setReady();
    }

    public SnacFamilyInfo getSnacFamilyInfo() {
        return AuthCommand.FAMILY_INFO;
    }

    public void addLoginListener(LoginServiceListener l) {
        this.listeners.addIfAbsent((Object)l);
    }

    public void removeLoginListener(LoginServiceListener l) {
        this.listeners.remove((Object)l);
    }

    public synchronized ClientVersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    public synchronized void setVersionInfo(ClientVersionInfo versionInfo) {
        this.versionInfo = versionInfo;
    }

    public SecuridProvider getSecuridProvider() {
        return this.securidProvider;
    }

    public void setSecuridProvider(SecuridProvider securidProvider) {
        this.securidProvider = securidProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireLoginSucceeded(LoginSuccessInfo info) {
        logger.fine("Login process succeeded: " + info);
        LoginService loginService = this;
        synchronized (loginService) {
            if (this.notified) {
                return;
            }
            this.notified = true;
        }
        this.setFinished();
        for (LoginServiceListener listener : this.listeners) {
            listener.loginSucceeded(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireLoginFailed(LoginFailureInfo info) {
        logger.fine("Login failed: " + info.getClass().getName() + ": " + info);
        LoginService loginService = this;
        synchronized (loginService) {
            if (this.notified) {
                return;
            }
            this.notified = true;
        }
        for (LoginServiceListener listener : this.listeners) {
            listener.loginFailed(info);
        }
        this.setFinished();
    }

    public void timeout(int timeout) {
        if (!this.getNotified()) {
            this.fireLoginFailed(new TimeoutFailureInfo(timeout));
        }
    }

    private synchronized boolean getNotified() {
        return this.notified;
    }

    public void connected() {
        logger.fine("Sending key request");
        this.sendFlap((FlapCommand)new LoginFlapCmd());
        this.sendSnac((SnacCommand)new KeyRequest(this.screenname.getFormatted()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishUp() {
        LoginService loginService = this;
        synchronized (loginService) {
            if (this.securidThread != null) {
                this.securidThread.interrupt();
            }
        }
        if (!this.getNotified()) {
            this.fireLoginFailed(new DisconnectedFailureInfo(this.getAimConnection().wantedDisconnect()));
        }
    }

    public void handleFlapPacket(FlapPacketEvent flapPacketEvent) {
        FlapCommand flap = flapPacketEvent.getFlapCommand();
        if (flap instanceof CloseFlapCmd) {
            CloseFlapCmd fc = (CloseFlapCmd)flap;
            this.fireLoginFailed(new ClosedEarlyFailureInfo(fc));
        } else if (flap instanceof FlapErrorCmd) {
            FlapErrorCmd fe = (FlapErrorCmd)flap;
            this.fireLoginFailed(new FlapErrorFailureInfo(fe));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSnacPacket(SnacPacketEvent snacPacketEvent) {
        SnacCommand snac = snacPacketEvent.getSnacCommand();
        if (snac instanceof KeyResponse) {
            KeyResponse kr = (KeyResponse)snac;
            logger.fine("Sending authorization request");
            this.sendSnac((SnacCommand)new AuthRequest(this.screenname.getFormatted(), this.password, this.getVersionInfo(), kr.getKey()));
        } else if (snac instanceof AuthResponse) {
            AuthResponse ar = (AuthResponse)snac;
            if (ar.getErrorCode() != -1) {
                this.fireLoginFailed(new AuthFailureInfo(ar));
            } else {
                this.fireLoginSucceeded(new LoginSuccessInfo(ar));
            }
        } else if (snac instanceof SecuridRequest) {
            final SecuridProvider provider = this.securidProvider;
            if (provider == null) {
                this.fireLoginFailed(new NoSecuridFailure());
            } else {
                Thread thread = new Thread(new Runnable(){

                    public void run() {
                        String securid = provider.getSecurid();
                        if (securid == null) {
                            LoginService.this.fireLoginFailed(new NoSecuridFailure());
                        } else {
                            LoginService.this.sendSnac((SnacCommand)new SecuridResponse(securid));
                        }
                    }
                });
                thread.setDaemon(true);
                LoginService loginService = this;
                synchronized (loginService) {
                    if (this.securidThread != null) {
                        this.securidThread.interrupt();
                    }
                    this.securidThread = thread;
                }
                thread.start();
            }
        } else if (snac instanceof SnacError) {
            SnacError se = (SnacError)snac;
            this.fireLoginFailed(new SnacErrorFailureInfo(se));
        }
    }
}

