/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers;

import java.io.IOException;
import java.net.InetAddress;
import net.kano.joscar.MiscTools;
import net.kano.joscar.rvcmd.RvConnectionInfo;
import net.kano.joscar.rvproto.rvproxy.RvProxyAckCmd;
import net.kano.joscar.rvproto.rvproxy.RvProxyCmd;
import net.kano.joscar.rvproto.rvproxy.RvProxyInitRecvCmd;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvSessionConnectionInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.AbstractProxyConnectionController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.ManualTimeoutController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.ConnectingToProxyEvent;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractConnectToProxyController
extends AbstractProxyConnectionController
implements ManualTimeoutController {
    public AbstractConnectToProxyController() {
        this.setConnector(new ConnectToProxyConnector());
    }

    protected void handleConnectingState() {
        InetAddress outAddr;
        int outPort = this.getConnector().getConnectionPort();
        try {
            outAddr = this.getConnector().getIpAddress();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.getRvConnection().getEventPost().fireEvent(new ConnectingToProxyEvent(outAddr, outPort));
    }

    protected void handleResolvingState() {
    }

    protected void handleAck(RvProxyAckCmd ackCmd) throws IOException {
    }

    protected void initializeProxy() throws IOException {
        RvSessionConnectionInfo conn = this.getRvSessionInfo();
        int port = conn.getConnectionInfo().getPort();
        String mysn = this.getRvConnection().getMyScreenname().getNormal();
        RvProxyInitRecvCmd initCmd = new RvProxyInitRecvCmd(mysn, conn.getRvSession().getRvSessionId(), port, conn.getRequestMaker().getCapabilityBlock());
        this.getProxyConnection().sendProxyPacket((RvProxyCmd)initCmd);
    }

    public class ConnectToProxyConnector
    extends AbstractProxyConnectionController.DefaultProxyConnector {
        public ConnectToProxyConnector() {
            super(AbstractConnectToProxyController.this);
        }

        @NotNull
        public InetAddress getIpAddress() throws IllegalStateException {
            RvConnectionInfo connInfo = AbstractConnectToProxyController.this.getRvSessionInfo().getConnectionInfo();
            if (!connInfo.isProxied()) {
                throw new IllegalStateException("Connection is not proxied: " + connInfo);
            }
            InetAddress proxyIp = connInfo.getProxyIP();
            if (proxyIp == null) {
                throw new IllegalStateException(MiscTools.getClassName((Object)this) + " has invalid connection info: " + connInfo);
            }
            return proxyIp;
        }

        public void checkConnectionInfo() throws Exception {
            this.getIpAddress();
        }
    }
}

