/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ssiitem;

import net.kano.joscar.DefensiveTools;
import net.kano.joscar.snaccmd.ssi.SsiItem;
import net.kano.joscar.ssiitem.BuddyItem;
import net.kano.joscar.ssiitem.DenyItem;
import net.kano.joscar.ssiitem.GroupItem;
import net.kano.joscar.ssiitem.IconItem;
import net.kano.joscar.ssiitem.PermitItem;
import net.kano.joscar.ssiitem.PrivacyItem;
import net.kano.joscar.ssiitem.RootItem;
import net.kano.joscar.ssiitem.SsiItemObj;
import net.kano.joscar.ssiitem.SsiItemObjectFactory;
import net.kano.joscar.ssiitem.VisibilityItem;

public class DefaultSsiItemObjFactory
implements SsiItemObjectFactory {
    public static boolean isRootItem(SsiItem ssiItem) {
        return ssiItem.getItemType() == 1 && ssiItem.getParentId() == 0;
    }

    public SsiItemObj getItemObj(SsiItem ssiItem) {
        DefensiveTools.checkNull(ssiItem, "item");
        int n = ssiItem.getItemType();
        if (n == 0) {
            return new BuddyItem(ssiItem);
        }
        if (n == 1) {
            if (DefaultSsiItemObjFactory.isRootItem(ssiItem)) {
                return new RootItem(ssiItem);
            }
            return new GroupItem(ssiItem);
        }
        if (n == 4) {
            return new PrivacyItem(ssiItem);
        }
        if (n == 20) {
            return new IconItem(ssiItem);
        }
        if (n == 2) {
            return new PermitItem(ssiItem);
        }
        if (n == 3) {
            return new DenyItem(ssiItem);
        }
        if (n == 5) {
            return new VisibilityItem(ssiItem);
        }
        return null;
    }
}

