/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.loc;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.StringBlock;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.icbm.SingleBuddyRequest;
import net.kano.joscar.snaccmd.loc.LocCommand;

public class GetDirInfoCmd
extends LocCommand
implements SingleBuddyRequest {
    private final String sn;

    protected GetDirInfoCmd(SnacPacket snacPacket) {
        super(11);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        StringBlock stringBlock = OscarTools.readScreenname(byteBlock);
        this.sn = stringBlock == null ? null : stringBlock.getString();
    }

    public GetDirInfoCmd(String string) {
        super(11);
        this.sn = string;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        if (this.sn != null) {
            OscarTools.writeScreenname(outputStream, this.sn);
        }
    }

    public String toString() {
        return "GetDirInfoCmd for " + this.sn;
    }
}

