/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.chat;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.EncodedStringInfo;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.MinimalEncoder;
import net.kano.joscar.OscarTools;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.MutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;
import org.jetbrains.annotations.Nullable;

public class ChatMsg
implements LiveWritable {
    public static final String CONTENTENCODING_DEFAULT = "binary";
    public static final String CONTENTTYPE_DEFAULT = "text/x-aolrtf";
    public static final String CONTENTTYPE_SECURE = "application/pkcs7-mime";
    private static final int TYPE_CHARSET = 2;
    private static final int TYPE_BODY = 1;
    private static final int TYPE_LANG = 3;
    private static final int TYPE_CONTENT_TYPE = 4;
    private static final int TYPE_CONTENT_ENCODING = 5;
    private final ByteBlock messageData;
    private final Locale language;
    private final String contentType;
    private final String contentEncoding;
    private String charset;

    public static ChatMsg readChatMsg(ByteBlock byteBlock) {
        DefensiveTools.checkNull(byteBlock, "msgBlock");
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(byteBlock);
        String string = immutableTlvChain.getString(4);
        String string2 = immutableTlvChain.getString(5);
        String string3 = immutableTlvChain.getString(2);
        ByteBlock byteBlock2 = immutableTlvChain.getLastTlv(1).getData();
        String string4 = immutableTlvChain.getString(3);
        return new ChatMsg(string, string2, string3, byteBlock2, new Locale(string4));
    }

    public ChatMsg(String string) {
        this(string, Locale.getDefault());
    }

    public ChatMsg(String string, Locale locale) {
        EncodedStringInfo encodedStringInfo = MinimalEncoder.encodeMinimally(string);
        this.contentType = CONTENTTYPE_DEFAULT;
        this.contentEncoding = CONTENTENCODING_DEFAULT;
        this.charset = encodedStringInfo.getCharset();
        this.messageData = ByteBlock.wrap(encodedStringInfo.getData());
        this.language = locale;
    }

    public ChatMsg(String string, String string2, String string3, ByteBlock byteBlock, Locale locale) {
        this.contentType = string;
        this.contentEncoding = string2;
        this.charset = string3;
        this.messageData = byteBlock;
        this.language = locale;
    }

    public final ByteBlock getMessageData() {
        return this.messageData;
    }

    public final String getContentType() {
        return this.contentType;
    }

    public final String getContentEncoding() {
        return this.contentEncoding;
    }

    public final String getCharset() {
        return this.charset;
    }

    public final Locale getLanguage() {
        return this.language;
    }

    @Nullable
    public final String getMessage() {
        if (this.contentType == null || this.contentType.equals(CONTENTTYPE_DEFAULT)) {
            return this.getMessageAsString();
        }
        return null;
    }

    public final String getMessageAsString() {
        return OscarTools.getString(this.messageData, this.charset);
    }

    public void write(OutputStream outputStream) throws IOException {
        MutableTlvChain mutableTlvChain = TlvTools.createMutableChain();
        if (this.contentType != null) {
            mutableTlvChain.addTlv(Tlv.getStringInstance(4, this.contentType));
        }
        if (this.charset != null) {
            mutableTlvChain.addTlv(Tlv.getStringInstance(2, this.charset));
        }
        if (this.language != null) {
            mutableTlvChain.addTlv(Tlv.getStringInstance(3, this.language.getLanguage()));
        }
        if (this.contentEncoding != null) {
            mutableTlvChain.addTlv(Tlv.getStringInstance(5, this.contentEncoding));
        }
        if (this.messageData != null) {
            mutableTlvChain.addTlv(new Tlv(1, this.messageData));
        }
        mutableTlvChain.write(outputStream);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ChatMsg: ");
        String string = this.getMessage();
        if (string != null) {
            stringBuffer.append(string + ": ");
        }
        stringBuffer.append("contentType=" + this.contentType);
        stringBuffer.append(", charset=" + this.charset);
        stringBuffer.append(", language=" + (this.language != null ? this.language.getLanguage() : null));
        stringBuffer.append(", contentEncoding=" + this.contentEncoding);
        stringBuffer.append(", msgData: " + this.messageData.getLength() + " bytes");
        return stringBuffer.toString();
    }
}

