/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.chat;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.AbstractIcbm;
import net.kano.joscar.snaccmd.chat.ChatMsg;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;
import net.kano.joscar.tlv.TlvTools;

public abstract class AbstractChatMsgIcbm
extends AbstractIcbm {
    private static final int TYPE_IS_PUBLIC = 1;
    private static final int TYPE_MSGBLOCK = 5;
    private final ChatMsg chatMsg;
    private final TlvChain chatTlvs;

    protected AbstractChatMsgIcbm(int n, SnacPacket snacPacket) {
        super(14, n, snacPacket);
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(this.getChannelData());
        Tlv tlv = immutableTlvChain.getLastTlv(5);
        if (tlv != null) {
            ByteBlock byteBlock = tlv.getData();
            this.chatMsg = ChatMsg.readChatMsg(byteBlock);
        } else {
            this.chatMsg = null;
        }
        this.chatTlvs = immutableTlvChain;
    }

    protected AbstractChatMsgIcbm(int n, long l, ChatMsg chatMsg) {
        super(14, n, l, 3);
        this.chatMsg = chatMsg;
        this.chatTlvs = null;
    }

    public final ChatMsg getMessage() {
        return this.chatMsg;
    }

    protected final TlvChain getChatTlvs() {
        return this.chatTlvs;
    }

    protected void writeChannelData(OutputStream outputStream) throws IOException {
        if (this.chatMsg != null) {
            ByteBlock byteBlock = ByteBlock.createByteBlock(this.chatMsg);
            new Tlv(5, byteBlock).write(outputStream);
        }
        this.writeChatTlvs(outputStream);
    }

    protected abstract void writeChatTlvs(OutputStream var1) throws IOException;

    public String toString() {
        return "AbstractChatMsgIcbm: <" + super.toString() + ">, " + "chatMsg=" + this.chatMsg;
    }
}

