/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.auth;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;

public final class ClientVersionInfo
implements LiveWritable {
    private static final int TYPE_VERSION_STRING = 3;
    private static final int TYPE_CLIENTID = 22;
    private static final int TYPE_MAJOR = 23;
    private static final int TYPE_MINOR = 24;
    private static final int TYPE_POINT = 25;
    private static final int TYPE_BUILD = 26;
    private static final int TYPE_DISTCODE = 20;
    private final String versionString;
    private final int clientid;
    private final int major;
    private final int minor;
    private final int point;
    private final int build;
    private final long distCode;

    public static ClientVersionInfo readClientVersionInfo(TlvChain tlvChain) {
        DefensiveTools.checkNull(tlvChain, "chain");
        String string = tlvChain.getString(3);
        int n = tlvChain.getUShort(22);
        int n2 = tlvChain.getUShort(23);
        int n3 = tlvChain.getUShort(24);
        int n4 = tlvChain.getUShort(25);
        int n5 = tlvChain.getUShort(26);
        long l = tlvChain.getUInt(20);
        return new ClientVersionInfo(string, n, n2, n3, n4, n5, l);
    }

    public ClientVersionInfo(String string, int n, int n2, int n3, int n4, long l) {
        this(string, -1, n, n2, n3, n4, l);
    }

    public ClientVersionInfo(String string, int n, int n2, int n3, int n4, int n5, long l) {
        DefensiveTools.checkRange(n2, "major", -1);
        DefensiveTools.checkRange(n, "clientid", -1);
        DefensiveTools.checkRange(n3, "minor", -1);
        DefensiveTools.checkRange(n4, "point", -1);
        DefensiveTools.checkRange(n5, "build", -1);
        DefensiveTools.checkRange(l, "distCode", -1L);
        this.versionString = string;
        this.clientid = n;
        this.major = n2;
        this.minor = n3;
        this.point = n4;
        this.build = n5;
        this.distCode = l;
    }

    public String getVersionString() {
        return this.versionString;
    }

    public int getClientid() {
        return this.clientid;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPoint() {
        return this.point;
    }

    public int getBuild() {
        return this.build;
    }

    public long getDistCode() {
        return this.distCode;
    }

    public void write(OutputStream outputStream) throws IOException {
        if (this.versionString != null) {
            Tlv.getStringInstance(3, this.versionString).write(outputStream);
        }
        if (this.clientid != -1) {
            Tlv.getUShortInstance(22, this.clientid).write(outputStream);
        }
        if (this.major != -1) {
            Tlv.getUShortInstance(23, this.major).write(outputStream);
        }
        if (this.minor != -1) {
            Tlv.getUShortInstance(24, this.minor).write(outputStream);
        }
        if (this.point != -1) {
            Tlv.getUShortInstance(25, this.point).write(outputStream);
        }
        if (this.build != -1) {
            Tlv.getUShortInstance(26, this.build).write(outputStream);
        }
        if (this.distCode != -1L) {
            Tlv.getUIntInstance(20, this.distCode).write(outputStream);
        }
    }

    public String toString() {
        return "ClientVersionInfo: , versionString='" + this.versionString + "'" + ", clientid=" + this.clientid + ", major=" + this.major + ", minor=" + this.minor + ", point=" + this.point + ", build=" + this.build + ", distCode=" + this.distCode;
    }
}

