/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.MiscTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.StringBlock;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.ExtraInfoBlock;
import net.kano.joscar.snaccmd.ShortCapabilityBlock;
import net.kano.joscar.snaccmd.WarningLevel;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.MutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullUserInfo
implements LiveWritable {
    public static final int MASK_UNCONFIRMED = 1;
    public static final int MASK_ADMIN = 2;
    public static final int MASK_AOL = 4;
    public static final int MASK_FREE = 16;
    public static final int MASK_WIRELESS = 128;
    public static final int MASK_AB = 1024;
    public static final int MASK_AWAY = 32;
    public static final long MASK_ALL = 0xFFFFFFFFL;
    public static final long ICQSTATUS_INVISIBLE = 256L;
    public static final long ICQSTATUS_DND = 2L;
    public static final long ICQSTATUS_OCCUPIED = 16L;
    public static final long ICQSTATUS_NA = 4L;
    public static final long ICQSTATUS_AWAY = 1L;
    public static final long ICQSTATUS_DEFAULT = 0L;
    public static final long ICQSTATUS_FFC = 32L;
    private static final int TYPE_USER_FLAG = 1;
    private static final int TYPE_ACCT_CREATED = 2;
    private static final int TYPE_ON_SINCE = 3;
    private static final int TYPE_IDLE_MINS = 4;
    private static final int TYPE_MEMBER_SINCE = 5;
    private static final int TYPE_CAPS = 13;
    private static final int TYPE_SESS_LEN_AIM = 15;
    private static final int TYPE_SESS_LEN_AOL = 16;
    private static final int TYPE_EXTRA_INFO = 29;
    private static final int TYPE_CERT_HASH = 27;
    private static final int TYPE_SHORT_CAPS = 25;
    private static final int TYPE_ICQSTATUS = 6;
    private final String sn;
    private final int totalSize;
    private final WarningLevel warningLevel;
    private final int flags;
    private final Date accountCreated;
    private final Date memberSince;
    private final long sessionLengthAIM;
    private final long sessionLengthAOL;
    private final Date onSince;
    private final int idleMins;
    private final List<CapabilityBlock> capabilityBlocks;
    private final Boolean away;
    private final List<ExtraInfoBlock> extraInfos;
    private final ByteBlock certInfoHash;
    private final List<ShortCapabilityBlock> shortCaps;
    private final long icqstatus;
    private final ImmutableTlvChain extraTlvs;

    @Nullable
    public static FullUserInfo readUserInfo(ByteBlock byteBlock) {
        ByteBlock byteBlock2;
        DefensiveTools.checkNull(byteBlock, "block");
        int n = byteBlock.getOffset();
        StringBlock stringBlock = OscarTools.readScreenname(byteBlock);
        if (stringBlock == null) {
            return null;
        }
        String string = stringBlock.getString();
        int n2 = stringBlock.getTotalSize();
        if (byteBlock.getLength() < n2 + 2) {
            return new FullUserInfo(string, n2);
        }
        ByteBlock byteBlock3 = byteBlock.subBlock(n2);
        int n3 = BinaryTools.getUShort(byteBlock3, 0);
        WarningLevel warningLevel = WarningLevel.getInstanceFromX10(n3);
        if ((byteBlock3 = byteBlock3.subBlock(2)).getLength() < 2) {
            return new FullUserInfo(string, warningLevel, n2 + 2);
        }
        int n4 = BinaryTools.getUShort(byteBlock3, 0);
        byteBlock3 = byteBlock3.subBlock(2);
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(byteBlock3, n4);
        Tlv tlv = immutableTlvChain.getLastTlv(1);
        Tlv tlv2 = immutableTlvChain.getLastTlv(2);
        Tlv tlv3 = immutableTlvChain.getLastTlv(3);
        Tlv tlv4 = immutableTlvChain.getLastTlv(4);
        Tlv tlv5 = immutableTlvChain.getLastTlv(5);
        Tlv tlv6 = immutableTlvChain.getLastTlv(13);
        Tlv tlv7 = immutableTlvChain.getLastTlv(15);
        Tlv tlv8 = immutableTlvChain.getLastTlv(16);
        Tlv tlv9 = immutableTlvChain.getLastTlv(29);
        Tlv tlv10 = immutableTlvChain.getLastTlv(27);
        Tlv tlv11 = immutableTlvChain.getLastTlv(25);
        Tlv tlv12 = immutableTlvChain.getLastTlv(6);
        MutableTlvChain mutableTlvChain = TlvTools.getMutableCopy(immutableTlvChain);
        mutableTlvChain.removeTlvs(1, 2, 3, 4, 5, 13, 15, 16, 29, 27, 25, 6);
        Boolean bl = null;
        int n5 = -1;
        if (tlv != null) {
            n5 = tlv.getDataAsUShort();
            bl = (n5 & 0x20) != 0;
        }
        Date date = null;
        if (tlv2 != null) {
            date = new Date(tlv2.getDataAsUInt() * 1000L);
        }
        Date date2 = null;
        if (tlv5 != null) {
            date2 = new Date(tlv5.getDataAsUInt() * 1000L);
        }
        long l = -1L;
        if (tlv7 != null) {
            l = tlv7.getDataAsUInt();
        }
        long l2 = -1L;
        if (tlv8 != null) {
            l2 = tlv8.getDataAsUInt();
        }
        Date date3 = null;
        if (tlv3 != null) {
            date3 = new Date(tlv3.getDataAsUInt() * 1000L);
        }
        int n6 = -1;
        if (tlv4 != null) {
            n6 = tlv4.getDataAsUShort();
        }
        List<CapabilityBlock> list = null;
        if (tlv6 != null) {
            list = CapabilityBlock.getCapabilityBlocks(tlv6.getData());
        }
        List<ExtraInfoBlock> list2 = null;
        if (tlv9 != null) {
            byteBlock2 = tlv9.getData();
            list2 = ExtraInfoBlock.readExtraInfoBlocks(byteBlock2);
        }
        byteBlock2 = null;
        if (tlv10 != null) {
            byteBlock2 = tlv10.getData();
        }
        List<ShortCapabilityBlock> list3 = null;
        if (tlv11 != null) {
            ByteBlock byteBlock4 = tlv11.getData();
            list3 = ShortCapabilityBlock.readShortCaps(byteBlock4);
        }
        long l3 = -1L;
        if (tlv12 != null) {
            l3 = tlv12.getDataAsUInt();
        }
        byteBlock3 = byteBlock3.subBlock(immutableTlvChain.getTotalSize());
        int n7 = byteBlock3.getOffset() - n;
        ImmutableTlvChain immutableTlvChain2 = TlvTools.getImmutableCopy(mutableTlvChain);
        return new FullUserInfo(string, warningLevel, n5, date, date2, l, l2, date3, n6, list, bl, list2, byteBlock2, list3, l3, immutableTlvChain2, n7);
    }

    private FullUserInfo(String string, int n) {
        this(string, null, n);
    }

    private FullUserInfo(String string, WarningLevel warningLevel, int n) {
        this(string, warningLevel, -1, null, null, -1L, -1L, null, -1, null, null, null, null, null, -1L, null, n);
    }

    public FullUserInfo(String string, WarningLevel warningLevel, int n, Date date, Date date2, long l, long l2, Date date3, int n2, List<CapabilityBlock> list, Boolean bl, List<ExtraInfoBlock> list2, ByteBlock byteBlock, List<ShortCapabilityBlock> list3, long l3) {
        this(string, warningLevel, n, date, date2, l, l2, date3, n2, list, bl, list2, byteBlock, list3, l3, null);
    }

    public FullUserInfo(String string, WarningLevel warningLevel, int n, Date date, Date date2, long l, long l2, Date date3, int n2, List<CapabilityBlock> list, Boolean bl, List<ExtraInfoBlock> list2, ByteBlock byteBlock, List<ShortCapabilityBlock> list3, long l3, ImmutableTlvChain immutableTlvChain) {
        this(string, warningLevel, n, date, date2, l, l2, date3, n2, list, bl, list2, byteBlock, list3, l3, immutableTlvChain, -1);
    }

    private FullUserInfo(String string, WarningLevel warningLevel, int n, Date date, Date date2, long l, long l2, Date date3, int n2, List<CapabilityBlock> list, Boolean bl, List<ExtraInfoBlock> list2, ByteBlock byteBlock, List<ShortCapabilityBlock> list3, long l3, ImmutableTlvChain immutableTlvChain, int n3) {
        DefensiveTools.checkNull(string, "sn");
        DefensiveTools.checkRange(l, "sessAIM", -1L);
        DefensiveTools.checkRange(l2, "sessAOL", -1L);
        DefensiveTools.checkRange(n2, "idleMins", -1);
        DefensiveTools.checkRange(n3, "totalSize", -1);
        List<CapabilityBlock> list4 = DefensiveTools.getSafeListCopy(list, "caps");
        List<ExtraInfoBlock> list5 = DefensiveTools.getSafeListCopy(list2, "extraInfos");
        List<ShortCapabilityBlock> list6 = DefensiveTools.getSafeListCopy(list3, "shortCaps");
        this.sn = string;
        this.warningLevel = warningLevel;
        this.flags = n;
        this.accountCreated = date;
        this.memberSince = date2;
        this.sessionLengthAIM = l;
        this.sessionLengthAOL = l2;
        this.onSince = date3;
        this.idleMins = n2;
        this.capabilityBlocks = list4;
        this.away = bl;
        this.extraInfos = list5;
        this.certInfoHash = byteBlock;
        this.shortCaps = list6;
        this.icqstatus = l3;
        this.extraTlvs = immutableTlvChain;
        this.totalSize = n3;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public final WarningLevel getWarningLevel() {
        return this.warningLevel;
    }

    public final int getFlags() {
        return this.flags;
    }

    public final Date getAccountCreated() {
        return this.accountCreated;
    }

    public final Date getMemberSince() {
        return this.memberSince;
    }

    public final long getSessionLengthAIM() {
        return this.sessionLengthAIM;
    }

    public final long getSessionLengthAOL() {
        return this.sessionLengthAOL;
    }

    public final Date getOnSince() {
        return this.onSince;
    }

    public final int getIdleMins() {
        return this.idleMins;
    }

    public final List<CapabilityBlock> getCapabilityBlocks() {
        return this.capabilityBlocks;
    }

    public final Boolean getAwayStatus() {
        return this.away;
    }

    public final List<ExtraInfoBlock> getExtraInfoBlocks() {
        return this.extraInfos;
    }

    public final ByteBlock getCertInfoHash() {
        return this.certInfoHash;
    }

    public List<ShortCapabilityBlock> getShortCapabilityBlocks() {
        return this.shortCaps;
    }

    public long getIcqStatus() {
        return this.icqstatus;
    }

    public final ImmutableTlvChain getExtraTlvs() {
        return this.extraTlvs;
    }

    public final int getTotalSize() {
        return this.totalSize;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        OscarTools.writeScreenname(outputStream, this.sn);
        if (this.warningLevel == null) {
            return;
        }
        BinaryTools.writeUByte(outputStream, this.warningLevel.getX10Value());
        MutableTlvChain mutableTlvChain = TlvTools.createMutableChain();
        if (this.flags != -1 || this.away != null) {
            int n;
            int n2 = n = this.flags == -1 ? 0 : this.flags;
            if (this.away != null) {
                n = this.away.booleanValue() ? (n |= 0x20) : (n &= 0xFFFFFFDF);
            }
            mutableTlvChain.addTlv(Tlv.getUShortInstance(1, n));
        }
        if (this.accountCreated != null) {
            long l = this.accountCreated.getTime() / 1000L;
            mutableTlvChain.addTlv(Tlv.getUIntInstance(2, l));
        }
        if (this.memberSince != null) {
            long l = this.memberSince.getTime() / 1000L;
            mutableTlvChain.addTlv(Tlv.getUIntInstance(5, l));
        }
        if (this.sessionLengthAIM != -1L) {
            mutableTlvChain.addTlv(Tlv.getUIntInstance(15, this.sessionLengthAIM));
        }
        if (this.sessionLengthAOL != -1L) {
            mutableTlvChain.addTlv(Tlv.getUIntInstance(16, this.sessionLengthAOL));
        }
        if (this.onSince != null) {
            long l = this.onSince.getTime() / 1000L;
            mutableTlvChain.addTlv(Tlv.getUIntInstance(3, l));
        }
        if (this.idleMins != -1) {
            mutableTlvChain.addTlv(Tlv.getUShortInstance(4, this.idleMins));
        }
        if (this.capabilityBlocks != null) {
            mutableTlvChain.addTlv(new Tlv(13, ByteBlock.wrap(CapabilityBlock.convertToBytes(this.capabilityBlocks))));
        }
        if (this.extraInfos != null) {
            mutableTlvChain.addTlv(new Tlv(29, ByteBlock.createByteBlock(this.extraInfos)));
        }
        if (this.certInfoHash != null) {
            mutableTlvChain.addTlv(new Tlv(27, this.certInfoHash));
        }
        if (this.icqstatus != -1L) {
            mutableTlvChain.addTlv(Tlv.getUIntInstance(6, this.icqstatus));
        }
        if (this.extraTlvs != null) {
            mutableTlvChain.addAll(this.extraTlvs);
        }
        mutableTlvChain.write(outputStream);
    }

    public String toString() {
        return "UserInfo for " + this.sn + (this.warningLevel != null && this.warningLevel.intValue() != 0 ? " <" + this.warningLevel.floatValue() + "%>" : "") + ": flags=0x" + Integer.toHexString(this.flags) + " (" + MiscTools.getFlagFieldsString(FullUserInfo.class, this.flags, "MASK_.*") + ")" + (this.icqstatus == -1L ? "" : ", ICQ status=" + MiscTools.getFlagFieldsString(FullUserInfo.class, this.icqstatus, "ICQSTATUS_.*")) + (this.accountCreated != null ? ", acctCrtd=" + this.accountCreated : "") + (this.memberSince != null ? ", memberSince=" + this.memberSince : "") + (this.sessionLengthAIM != -1L ? ", sessLenAim=" + this.sessionLengthAIM / 60L + "min" : "") + (this.sessionLengthAOL != -1L ? ", sessLenAol=" + this.sessionLengthAOL / 60L + "min" : "") + (this.onSince != null ? ", onSince=" + this.onSince : "") + (this.idleMins > 0 ? ", idleMins=" + this.idleMins : "") + (this.away != false ? ", away" : "") + (this.extraInfos != null ? ", extraInfos=" + this.extraInfos : "") + (this.certInfoHash != null ? ", encInfo=" + this.certInfoHash : "") + (this.extraTlvs != null && this.extraTlvs.getTlvCount() > 0 ? ", extraTlvs=" + this.extraTlvs.getTlvs() : "") + (this.shortCaps != null ? ", shortcaps: " + this.shortCaps : "") + (this.capabilityBlocks != null ? ", longcaps: " + this.capabilityBlocks : "");
    }
}

