/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ratelim;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.ratelim.QueueRunner;
import net.kano.joscar.ratelim.RateClassMonitor;
import net.kano.joscar.ratelim.RateLimitingQueueMgr;
import net.kano.joscar.ratelim.RateListener;
import net.kano.joscar.ratelim.RateMonitor;
import net.kano.joscar.ratelim.RateQueue;
import net.kano.joscar.snac.ClientSnacProcessor;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.SnacRequest;
import net.kano.joscar.snaccmd.conn.RateClassInfo;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectionQueueMgr {
    private final RateLimitingQueueMgr queueMgr;
    private final RateMonitor monitor;
    private final ClientSnacProcessor snacProcessor;
    private boolean paused = false;
    private final Map<RateClassMonitor, RateQueue> queues = new IdentityHashMap<RateClassMonitor, RateQueue>();
    private RateListener rateListener = new RateListener(){

        public void detached(RateMonitor rateMonitor, ClientSnacProcessor clientSnacProcessor) {
            rateMonitor.removeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset(RateMonitor rateMonitor) {
            ConnectionQueueMgr connectionQueueMgr = ConnectionQueueMgr.this;
            synchronized (connectionQueueMgr) {
                ConnectionQueueMgr.this.clearQueues();
            }
        }

        public void gotRateClasses(RateMonitor rateMonitor) {
            ConnectionQueueMgr.this.updateRateClasses();
        }

        public void rateClassUpdated(RateMonitor rateMonitor, RateClassMonitor rateClassMonitor, RateClassInfo rateClassInfo) {
            RateQueue rateQueue = ConnectionQueueMgr.this.getRateQueue(rateClassMonitor);
            ConnectionQueueMgr.this.queueMgr.getRunner().update(rateQueue);
        }

        public void rateClassLimited(RateMonitor rateMonitor, RateClassMonitor rateClassMonitor, boolean bl) {
            ConnectionQueueMgr.this.queueMgr.getRunner().update(ConnectionQueueMgr.this.getRateQueue(rateClassMonitor));
        }
    };

    ConnectionQueueMgr(RateLimitingQueueMgr rateLimitingQueueMgr, ClientSnacProcessor clientSnacProcessor) {
        DefensiveTools.checkNull(rateLimitingQueueMgr, "queueMgr");
        DefensiveTools.checkNull(clientSnacProcessor, "processor");
        this.queueMgr = rateLimitingQueueMgr;
        this.monitor = new RateMonitor(clientSnacProcessor);
        this.snacProcessor = clientSnacProcessor;
        this.monitor.addListener(this.rateListener);
    }

    public RateLimitingQueueMgr getParentQueueMgr() {
        return this.queueMgr;
    }

    public RateMonitor getRateMonitor() {
        return this.monitor;
    }

    public ClientSnacProcessor getSnacProcessor() {
        return this.snacProcessor;
    }

    private synchronized RateQueue getRateQueue(RateClassMonitor rateClassMonitor) {
        DefensiveTools.checkNull(rateClassMonitor, "classMonitor");
        return this.queues.get(rateClassMonitor);
    }

    @Nullable
    public synchronized RateQueue getRateQueue(CmdType cmdType) {
        DefensiveTools.checkNull(cmdType, "type");
        RateClassMonitor rateClassMonitor = this.monitor.getMonitor(cmdType);
        if (rateClassMonitor == null) {
            return null;
        }
        return this.getRateQueue(rateClassMonitor);
    }

    void queueSnac(SnacRequest snacRequest) {
        DefensiveTools.checkNull(snacRequest, "request");
        CmdType cmdType = CmdType.ofCmd(snacRequest.getCommand());
        RateQueue rateQueue = this.getRateQueue(cmdType);
        if (rateQueue == null) {
            this.queueMgr.sendSnac(this.snacProcessor, snacRequest);
        } else {
            rateQueue.enqueue(snacRequest);
            this.queueMgr.getRunner().update(rateQueue);
        }
    }

    synchronized void clearQueue() {
        for (RateQueue rateQueue : this.queues.values()) {
            rateQueue.clear();
        }
        this.paused = false;
    }

    synchronized void pause() {
        assert (!this.paused);
        this.paused = true;
    }

    synchronized void unpause() {
        assert (this.paused);
        this.paused = false;
        this.queueMgr.getRunner().update(this);
    }

    public synchronized boolean isPaused() {
        return this.paused;
    }

    private synchronized void updateRateClasses() {
        List<RateClassMonitor> list = this.monitor.getMonitors();
        Collection<RateQueue> collection = this.clearQueues();
        LinkedList linkedList = new LinkedList();
        for (RateQueue object2 : collection) {
            object2.dequeueAll(linkedList);
        }
        for (RateClassMonitor rateClassMonitor : list) {
            this.queues.put(rateClassMonitor, new RateQueue(this, rateClassMonitor));
        }
        for (SnacRequest snacRequest : linkedList) {
            this.queueSnac(snacRequest);
        }
        Collection<RateQueue> collection2 = this.queues.values();
        QueueRunner queueRunner = this.queueMgr.getRunner();
        queueRunner.addQueues(collection2);
        queueRunner.update(this);
    }

    private synchronized Collection<RateQueue> clearQueues() {
        Collection<RateQueue> collection = this.queues.values();
        this.queueMgr.getRunner().removeQueues(collection);
        this.queues.clear();
        return DefensiveTools.getUnmodifiableCopy(collection);
    }

    synchronized void detach() {
        this.clearQueue();
        this.clearQueues();
        this.monitor.detach();
    }

    public String toString() {
        return "ConnectionQueueMgr: paused=" + this.paused + ", queues=" + this.queues.keySet();
    }
}

